/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Member;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.rmi.AccessException;
/*     */ import java.rmi.MarshalException;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.rmi.Remote;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.transaction.InvalidTransactionException;
/*     */ import javax.transaction.TransactionRequiredException;
/*     */ import javax.transaction.TransactionRolledbackException;
/*     */ import org.omg.CORBA.INVALID_TRANSACTION;
/*     */ import org.omg.CORBA.MARSHAL;
/*     */ import org.omg.CORBA.NO_PERMISSION;
/*     */ import org.omg.CORBA.OBJECT_NOT_EXIST;
/*     */ import org.omg.CORBA.TRANSACTION_REQUIRED;
/*     */ import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ 
/*     */ public class RmiIdlUtil
/*     */ {
/*     */   public static boolean hasLegalRMIIIOPArguments(Method method)
/*     */   {
/*  48 */     Class[] params = method.getParameterTypes();
/*     */ 
/*  50 */     for (int i = 0; i < params.length; i++) {
/*  51 */       if (!isRMIIIOPType(params[i]))
/*  52 */         return false;
/*     */     }
/*  54 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean hasLegalRMIIIOPReturnType(Method method) {
/*  58 */     return isRMIIIOPType(method.getReturnType());
/*     */   }
/*     */ 
/*     */   public static boolean hasLegalRMIIIOPExceptionTypes(Method method)
/*     */   {
/*  70 */     Iterator it = Arrays.asList(method.getExceptionTypes()).iterator();
/*     */ 
/*  72 */     while (it.hasNext()) {
/*  73 */       Class exception = (Class)it.next();
/*     */ 
/*  75 */       if (!isRMIIDLExceptionType(exception)) {
/*  76 */         return false;
/*     */       }
/*     */     }
/*  79 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean throwsRemoteException(Method method)
/*     */   {
/*  88 */     Class[] exception = method.getExceptionTypes();
/*     */ 
/*  90 */     for (int i = 0; i < exception.length; i++) {
/*  91 */       if (exception[i].isAssignableFrom(RemoteException.class))
/*  92 */         return true;
/*     */     }
/*  94 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean isStatic(Member member)
/*     */   {
/* 102 */     return Modifier.isStatic(member.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isStatic(Class c)
/*     */   {
/* 109 */     return Modifier.isStatic(c.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isFinal(Member member)
/*     */   {
/* 117 */     return Modifier.isFinal(member.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isFinal(Class c)
/*     */   {
/* 124 */     return Modifier.isFinal(c.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isPublic(Member member)
/*     */   {
/* 132 */     return Modifier.isPublic(member.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isPublic(Class c)
/*     */   {
/* 139 */     return Modifier.isPublic(c.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isAllFieldsPublic(Class c)
/*     */   {
/*     */     try
/*     */     {
/* 147 */       Field[] list = c.getFields();
/* 148 */       for (int i = 0; i < list.length; i++)
/* 149 */         if (!Modifier.isPublic(list[i].getModifiers()))
/* 150 */           return false;
/*     */     } catch (Exception e) {
/* 152 */       return false;
/*     */     }
/* 154 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean isAbstract(Class c)
/*     */   {
/* 161 */     return Modifier.isAbstract(c.getModifiers());
/*     */   }
/*     */ 
/*     */   public static boolean isRMIIIOPType(Class type)
/*     */   {
/* 189 */     if (type.isPrimitive()) {
/* 190 */       return true;
/*     */     }
/*     */ 
/* 197 */     if (type.isArray()) {
/* 198 */       return isRMIIIOPType(type.getComponentType());
/*     */     }
/*     */ 
/* 205 */     if (org.omg.CORBA.Object.class.isAssignableFrom(type)) {
/* 206 */       return true;
/*     */     }
/*     */ 
/* 213 */     if (IDLEntity.class.isAssignableFrom(type)) {
/* 214 */       return true;
/*     */     }
/*     */ 
/* 221 */     if (isRMIIDLRemoteInterface(type)) {
/* 222 */       return true;
/*     */     }
/*     */ 
/* 229 */     if (isRMIIDLExceptionType(type)) {
/* 230 */       return true;
/*     */     }
/*     */ 
/* 238 */     return isRMIIDLValueType(type);
/*     */   }
/*     */ 
/*     */   public static boolean isRMIIDLRemoteInterface(Class type)
/*     */   {
/* 249 */     if (!Remote.class.isAssignableFrom(type)) {
/* 250 */       return false;
/*     */     }
/* 252 */     Iterator methodIterator = Arrays.asList(type.getMethods()).iterator();
/*     */ 
/* 254 */     while (methodIterator.hasNext()) {
/* 255 */       Method m = (Method)methodIterator.next();
/*     */ 
/* 263 */       if (!throwsRemoteException(m)) {
/* 264 */         return false;
/*     */       }
/*     */ 
/* 274 */       Iterator it = Arrays.asList(m.getExceptionTypes()).iterator();
/*     */ 
/* 276 */       while (it.hasNext()) {
/* 277 */         Class exception = (Class)it.next();
/*     */ 
/* 279 */         if (!isRMIIDLExceptionType(exception)) {
/* 280 */           return false;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 290 */     Iterator fieldIterator = Arrays.asList(type.getFields()).iterator();
/*     */ 
/* 292 */     while (fieldIterator.hasNext())
/*     */     {
/* 294 */       Field f = (Field)fieldIterator.next();
/*     */ 
/* 296 */       if ((!f.getType().isPrimitive()) && 
/* 299 */         (!f.getType().equals(String.class)))
/*     */       {
/* 302 */         return false;
/*     */       }
/*     */     }
/* 305 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean isAbstractInterface(Class type)
/*     */   {
/* 313 */     if (!type.isInterface()) {
/* 314 */       return false;
/*     */     }
/*     */ 
/* 319 */     if (org.omg.CORBA.Object.class.isAssignableFrom(type)) {
/* 320 */       return false;
/*     */     }
/*     */ 
/* 325 */     if (Remote.class.isAssignableFrom(type)) {
/* 326 */       return false;
/*     */     }
/* 328 */     Iterator methodIterator = Arrays.asList(type.getMethods()).iterator();
/*     */ 
/* 330 */     while (methodIterator.hasNext()) {
/* 331 */       Method m = (Method)methodIterator.next();
/*     */ 
/* 337 */       if (!throwsRemoteException(m)) {
/* 338 */         return false;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 343 */     return true;
/*     */   }
/*     */ 
/*     */   public static boolean isRMIIDLExceptionType(Class type)
/*     */   {
/* 354 */     if (!Throwable.class.isAssignableFrom(type)) {
/* 355 */       return false;
/*     */     }
/* 357 */     if (Error.class.isAssignableFrom(type)) {
/* 358 */       return false;
/*     */     }
/* 360 */     if (RuntimeException.class.isAssignableFrom(type)) {
/* 361 */       return false;
/*     */     }
/*     */ 
/* 364 */     return isRMIIDLValueType(type);
/*     */   }
/*     */ 
/*     */   public static boolean isRMIIDLValueType(Class type)
/*     */   {
/* 377 */     if (Remote.class.isAssignableFrom(type)) {
/* 378 */       return false;
/*     */     }
/*     */ 
/* 384 */     if (org.omg.CORBA.Object.class.isAssignableFrom(type)) {
/* 385 */       return false;
/*     */     }
/*     */ 
/* 395 */     return (type.getDeclaringClass() == null) || (!isStatic(type)) || 
/* 394 */       (isRMIIDLValueType(type.getDeclaringClass()));
/*     */   }
/*     */ 
/*     */   public static boolean isAbstractValueType(Class type)
/*     */   {
/* 402 */     if (!type.isInterface()) {
/* 403 */       return false;
/*     */     }
/* 405 */     if (org.omg.CORBA.Object.class.isAssignableFrom(type)) {
/* 406 */       return false;
/*     */     }
/* 408 */     boolean cannotBeRemote = false;
/* 409 */     boolean cannotBeAbstractInterface = false;
/*     */ 
/* 411 */     if (Remote.class.isAssignableFrom(type)) {
/* 412 */       cannotBeAbstractInterface = true;
/*     */     }
/*     */     else {
/* 415 */       cannotBeRemote = true;
/*     */     }
/*     */ 
/* 418 */     Iterator methodIterator = Arrays.asList(type.getMethods()).iterator();
/*     */ 
/* 420 */     while (methodIterator.hasNext()) {
/* 421 */       Method m = (Method)methodIterator.next();
/*     */ 
/* 423 */       if (!throwsRemoteException(m)) {
/* 424 */         cannotBeAbstractInterface = true;
/* 425 */         cannotBeRemote = true;
/* 426 */         break;
/*     */       }
/*     */ 
/* 429 */       Iterator it = Arrays.asList(m.getExceptionTypes()).iterator();
/*     */ 
/* 431 */       while (it.hasNext()) {
/* 432 */         Class exception = (Class)it.next();
/*     */ 
/* 434 */         if (!isRMIIDLExceptionType(exception)) {
/* 435 */           cannotBeRemote = true;
/* 436 */           break;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 441 */     if (!cannotBeRemote) {
/* 442 */       Iterator fieldIterator = Arrays.asList(type.getFields()).iterator();
/*     */ 
/* 444 */       while (fieldIterator.hasNext()) {
/* 445 */         Field f = (Field)fieldIterator.next();
/*     */ 
/* 447 */         if ((f.getType().isPrimitive()) || 
/* 449 */           (f.getType().equals(String.class)))
/*     */           continue;
/* 451 */         cannotBeRemote = true;
/*     */       }
/*     */     }
/*     */ 
/* 455 */     return (cannotBeRemote) && (cannotBeAbstractInterface);
/*     */   }
/*     */ 
/*     */   public static void rethrowIfCorbaSystemException(Exception e)
/*     */   {
/* 460 */     if ((e instanceof MarshalException))
/* 461 */       throw new MARSHAL(e.toString());
/* 462 */     if ((e instanceof NoSuchObjectException))
/* 463 */       throw new OBJECT_NOT_EXIST(e.toString());
/* 464 */     if ((e instanceof AccessException))
/* 465 */       throw new NO_PERMISSION(e.toString());
/* 466 */     if ((e instanceof TransactionRequiredException))
/* 467 */       throw new TRANSACTION_REQUIRED(e.toString());
/* 468 */     if ((e instanceof TransactionRolledbackException))
/* 469 */       throw new TRANSACTION_ROLLEDBACK(e.toString());
/* 470 */     if ((e instanceof InvalidTransactionException))
/* 471 */       throw new INVALID_TRANSACTION(e.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.RmiIdlUtil
 * JD-Core Version:    0.6.0
 */