/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class InterfaceAnalysis extends ContainerAnalysis
/*     */ {
/*     */   Map operationAnalysisMap;
/*  52 */   private static final Logger logger = Logger.getLogger(InterfaceAnalysis.class);
/*     */ 
/*  55 */   private static WorkCacheManager cache = new WorkCacheManager(InterfaceAnalysis.class);
/*     */   private boolean abstractInterface;
/*     */   private String[] allTypeIds;
/*     */ 
/*     */   public static InterfaceAnalysis getInterfaceAnalysis(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  61 */     return (InterfaceAnalysis)cache.getAnalysis(cls);
/*     */   }
/*     */ 
/*     */   protected InterfaceAnalysis(Class cls)
/*     */   {
/*  68 */     super(cls);
/*  69 */     logger.debug("new InterfaceAnalysis: " + cls.getName());
/*     */   }
/*     */ 
/*     */   protected void doAnalyze()
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  75 */     super.doAnalyze();
/*     */ 
/*  77 */     calculateOperationAnalysisMap();
/*  78 */     fixupCaseNames();
/*     */   }
/*     */ 
/*     */   public boolean isAbstractInterface()
/*     */   {
/*  85 */     return this.abstractInterface;
/*     */   }
/*     */ 
/*     */   public boolean isRmiIdlRemoteInterface()
/*     */   {
/*  90 */     return !this.abstractInterface;
/*     */   }
/*     */ 
/*     */   public String[] getAllTypeIds()
/*     */   {
/*  95 */     if (this.allTypeIds == null)
/*  96 */       logger.debug(this.cls + " null allTypeIds");
/*  97 */     return (String[])(String[])this.allTypeIds.clone();
/*     */   }
/*     */ 
/*     */   protected ArrayList getContainedEntries()
/*     */   {
/* 110 */     ArrayList ret = new ArrayList(this.constants.length + this.attributes.length + this.operations.length);
/*     */ 
/* 114 */     for (int i = 0; i < this.constants.length; i++)
/* 115 */       ret.add(this.constants[i]);
/* 116 */     for (int i = 0; i < this.attributes.length; i++)
/* 117 */       ret.add(this.attributes[i]);
/* 118 */     for (int i = 0; i < this.operations.length; i++) {
/* 119 */       ret.add(this.operations[i]);
/*     */     }
/* 121 */     return ret;
/*     */   }
/*     */ 
/*     */   protected void analyzeOperations()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 131 */     logger.debug(this.cls + " analyzeOperations");
/*     */ 
/* 133 */     if (!this.cls.isInterface()) {
/* 134 */       throw new IllegalArgumentException("Class \"" + this.cls.getName() + "\" is not an interface.");
/*     */     }
/*     */ 
/* 137 */     this.abstractInterface = RmiIdlUtil.isAbstractInterface(this.cls);
/* 138 */     calculateAllTypeIds();
/*     */ 
/* 140 */     int operationCount = 0;
/* 141 */     for (int i = 0; i < this.methods.length; i++)
/* 142 */       if ((this.m_flags[i] & 0xE) == 0)
/* 143 */         operationCount++;
/* 144 */     this.operations = new OperationAnalysis[operationCount];
/* 145 */     operationCount = 0;
/* 146 */     for (int i = 0; i < this.methods.length; i++) {
/* 147 */       if ((this.m_flags[i] & 0xE) == 0) {
/* 148 */         this.operations[operationCount] = new OperationAnalysis(this.methods[i]);
/* 149 */         operationCount++;
/*     */       }
/*     */     }
/*     */ 
/* 153 */     logger.debug(this.cls + " analyzeOperations operations=" + this.operations.length);
/*     */   }
/*     */ 
/*     */   protected void calculateOperationAnalysisMap()
/*     */   {
/* 163 */     this.operationAnalysisMap = new HashMap();
/*     */ 
/* 167 */     for (int i = 0; i < this.operations.length; i++) {
/* 168 */       OperationAnalysis oa = this.operations[i];
/* 169 */       this.operationAnalysisMap.put(oa.getIDLName(), oa);
/*     */     }
/*     */ 
/* 173 */     for (int i = 0; i < this.attributes.length; i++) {
/* 174 */       AttributeAnalysis attr = this.attributes[i];
/*     */ 
/* 176 */       OperationAnalysis oa = attr.getAccessorAnalysis();
/*     */ 
/* 180 */       if (oa != null) {
/* 181 */         this.operationAnalysisMap.put(oa.getIDLName(), oa);
/*     */ 
/* 183 */         oa = attr.getMutatorAnalysis();
/* 184 */         if (oa != null)
/* 185 */           this.operationAnalysisMap.put(oa.getIDLName(), oa);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void calculateAllTypeIds()
/*     */   {
/* 197 */     if (!isRmiIdlRemoteInterface()) {
/* 198 */       this.allTypeIds = new String[0];
/*     */     }
/*     */     else {
/* 201 */       ArrayList a = new ArrayList();
/* 202 */       InterfaceAnalysis[] intfs = getInterfaces();
/* 203 */       for (int i = 0; i < intfs.length; i++) {
/* 204 */         String[] ss = intfs[i].getAllTypeIds();
/*     */ 
/* 206 */         for (int j = 0; j < ss.length; j++)
/* 207 */           if (!a.contains(ss[j]))
/* 208 */             a.add(ss[j]);
/*     */       }
/* 210 */       this.allTypeIds = new String[a.size() + 1];
/* 211 */       this.allTypeIds[0] = getRepositoryId();
/* 212 */       for (int i = 1; i <= a.size(); i++)
/* 213 */         this.allTypeIds[i] = ((String)a.get(a.size() - i));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.InterfaceAnalysis
 * JD-Core Version:    0.6.0
 */