/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.Remote;
/*     */ import org.omg.CORBA.AttributeMode;
/*     */ 
/*     */ public class AttributeAnalysis extends AbstractAnalysis
/*     */ {
/*     */   private AttributeMode mode;
/*     */   private Class cls;
/* 186 */   private Method accessor = null;
/*     */ 
/* 192 */   private Method mutator = null;
/*     */ 
/* 197 */   private OperationAnalysis accessorAnalysis = null;
/*     */ 
/* 203 */   private OperationAnalysis mutatorAnalysis = null;
/*     */ 
/*     */   private AttributeAnalysis(String javaName, AttributeMode mode, Method accessor, Method mutator)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  57 */     super(Util.javaToIDLName(javaName), javaName);
/*     */ 
/*  59 */     this.mode = mode;
/*  60 */     this.cls = accessor.getReturnType();
/*  61 */     this.accessor = accessor;
/*  62 */     this.mutator = mutator;
/*     */ 
/*  65 */     if ((accessor.getDeclaringClass().isInterface()) && (Remote.class.isAssignableFrom(accessor.getDeclaringClass())))
/*     */     {
/*  67 */       this.accessorAnalysis = new OperationAnalysis(accessor);
/*  68 */       if (mutator != null) {
/*  69 */         this.mutatorAnalysis = new OperationAnalysis(mutator);
/*     */       }
/*  71 */       setIDLName(getIDLName());
/*     */     }
/*     */   }
/*     */ 
/*     */   AttributeAnalysis(String javaName, Method accessor)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  82 */     this(javaName, AttributeMode.ATTR_READONLY, accessor, null);
/*     */   }
/*     */ 
/*     */   AttributeAnalysis(String javaName, Method accessor, Method mutator)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  91 */     this(javaName, AttributeMode.ATTR_NORMAL, accessor, mutator);
/*     */   }
/*     */ 
/*     */   public AttributeMode getMode()
/*     */   {
/* 101 */     return this.mode;
/*     */   }
/*     */ 
/*     */   public Class getCls()
/*     */   {
/* 109 */     return this.cls;
/*     */   }
/*     */ 
/*     */   public Method getAccessor()
/*     */   {
/* 117 */     return this.accessor;
/*     */   }
/*     */ 
/*     */   public Method getMutator()
/*     */   {
/* 125 */     return this.mutator;
/*     */   }
/*     */ 
/*     */   public OperationAnalysis getAccessorAnalysis()
/*     */   {
/* 133 */     return this.accessorAnalysis;
/*     */   }
/*     */ 
/*     */   public OperationAnalysis getMutatorAnalysis()
/*     */   {
/* 141 */     return this.mutatorAnalysis;
/*     */   }
/*     */ 
/*     */   void setIDLName(String idlName)
/*     */   {
/* 154 */     super.setIDLName(idlName);
/*     */ 
/* 158 */     if ((idlName.charAt(0) >= 'A') && (idlName.charAt(0) <= 'Z') && ((idlName.length() <= 1) || (idlName.charAt(1) < 'A') || (idlName.charAt(1) > 'Z')))
/*     */     {
/* 161 */       idlName = idlName.substring(0, 1).toLowerCase() + idlName.substring(1);
/*     */     }
/*     */ 
/* 165 */     if (this.accessorAnalysis != null)
/* 166 */       this.accessorAnalysis.setIDLName("_get_" + idlName);
/* 167 */     if (this.mutatorAnalysis != null)
/* 168 */       this.mutatorAnalysis.setIDLName("_set_" + idlName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.AttributeAnalysis
 * JD-Core Version:    0.6.0
 */