/*     */ package org.jboss.iiop.jacorb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import org.apache.avalon.framework.configuration.Configurable;
/*     */ import org.apache.avalon.framework.configuration.Configuration;
/*     */ import org.apache.avalon.framework.configuration.ConfigurationException;
/*     */ import org.jacorb.orb.ORB;
/*     */ import org.jacorb.orb.factory.SocketFactory;
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityDomain;
/*     */ import org.jboss.security.ssl.DomainSocketFactory;
/*     */ import org.jboss.system.Registry;
/*     */ 
/*     */ public class SSLSocketFactory
/*     */   implements SocketFactory, Configurable
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(SSLSocketFactory.class);
/*     */ 
/*  56 */   private DomainSocketFactory domainFactory = null;
/*     */ 
/*     */   public SSLSocketFactory(ORB orb)
/*     */     throws IOException
/*     */   {
/*  63 */     log.info("Creating");
/*     */ 
/*  65 */     SecurityDomain securityDomain = (SecurityDomain)Registry.lookup(CorbaORBService.SSL_DOMAIN);
/*     */     try
/*     */     {
/*  70 */       this.domainFactory = new DomainSocketFactory(securityDomain);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  74 */       log.warn("Could not create DomainSocketFactory: " + e);
/*  75 */       log.debug("Exception creating DomainSockedFactory: ", e);
/*  76 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException, UnknownHostException
/*     */   {
/*  94 */     return this.domainFactory.createSocket(host, port);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port, int timeout)
/*     */     throws IOException, UnknownHostException
/*     */   {
/* 109 */     return this.domainFactory.createSocket(host, port, timeout);
/*     */   }
/*     */ 
/*     */   public boolean isSSL(Socket s)
/*     */   {
/* 114 */     return s instanceof SSLSocket;
/*     */   }
/*     */ 
/*     */   public void configure(Configuration configuration)
/*     */     throws ConfigurationException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.jacorb.SSLSocketFactory
 * JD-Core Version:    0.6.0
 */