/*     */ package org.jboss.iiop.jacorb;
/*     */ 
/*     */ import java.applet.Applet;
/*     */ import java.util.Properties;
/*     */ import org.jboss.iiop.naming.ORBInitialContextFactory;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.Context;
/*     */ import org.omg.CORBA.ContextList;
/*     */ import org.omg.CORBA.Current;
/*     */ import org.omg.CORBA.Environment;
/*     */ import org.omg.CORBA.ExceptionList;
/*     */ import org.omg.CORBA.INITIALIZE;
/*     */ import org.omg.CORBA.NO_IMPLEMENT;
/*     */ import org.omg.CORBA.NVList;
/*     */ import org.omg.CORBA.NamedValue;
/*     */ import org.omg.CORBA.ORBPackage.InvalidName;
/*     */ import org.omg.CORBA.Object;
/*     */ import org.omg.CORBA.OperationDef;
/*     */ import org.omg.CORBA.Request;
/*     */ import org.omg.CORBA.StructMember;
/*     */ import org.omg.CORBA.TCKind;
/*     */ import org.omg.CORBA.TypeCode;
/*     */ import org.omg.CORBA.UnionMember;
/*     */ import org.omg.CORBA.ValueMember;
/*     */ import org.omg.CORBA.portable.OutputStream;
/*     */ import org.omg.CORBA_2_3.ORB;
/*     */ 
/*     */ public class ORBSingleton extends ORB
/*     */ {
/*  58 */   private static ORB delegate = null;
/*     */ 
/*     */   public ORBSingleton()
/*     */   {
/*  62 */     if (delegate == null)
/*     */     {
/*  64 */       String className = "org.jacorb.orb.ORBSingleton";
/*     */       try
/*     */       {
/*  67 */         delegate = (ORB)Class.forName(className).newInstance();
/*  68 */         ORBInitialContextFactory.setORB(delegate);
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*  75 */         throw new INITIALIZE("can't instantiate ORBSingleton implementation " + className);
/*     */       }
/*     */ 
/*  79 */       ClassLoader cl = Thread.currentThread().getContextClassLoader();
/*  80 */       if (cl == null)
/*  81 */         cl = ClassLoader.getSystemClassLoader();
/*     */       try
/*     */       {
/*  84 */         delegate = (ORB)Class.forName(className, true, cl).newInstance();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/*  88 */         throw new INITIALIZE("can't instantiate ORBSingleton implementation " + className);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Any create_any()
/*     */   {
/* 102 */     return delegate.create_any();
/*     */   }
/*     */ 
/*     */   public TypeCode create_alias_tc(String id, String name, TypeCode original_type)
/*     */   {
/* 109 */     return delegate.create_alias_tc(id, name, original_type);
/*     */   }
/*     */ 
/*     */   public TypeCode create_array_tc(int length, TypeCode element_type)
/*     */   {
/* 114 */     return delegate.create_array_tc(length, element_type);
/*     */   }
/*     */ 
/*     */   public TypeCode create_enum_tc(String id, String name, String[] members)
/*     */   {
/* 119 */     return delegate.create_enum_tc(id, name, members);
/*     */   }
/*     */ 
/*     */   public TypeCode create_exception_tc(String id, String name, StructMember[] members)
/*     */   {
/* 126 */     return delegate.create_exception_tc(id, name, members);
/*     */   }
/*     */ 
/*     */   public TypeCode create_interface_tc(String id, String name)
/*     */   {
/* 131 */     return delegate.create_interface_tc(id, name);
/*     */   }
/*     */ 
/*     */   public TypeCode create_fixed_tc(short digits, short scale)
/*     */   {
/* 136 */     return delegate.create_fixed_tc(digits, scale);
/*     */   }
/*     */ 
/*     */   public TypeCode create_recursive_tc(String id)
/*     */   {
/* 141 */     return delegate.create_recursive_tc(id);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public TypeCode create_recursive_sequence_tc(int bound, int offset)
/*     */   {
/* 149 */     throw new NO_IMPLEMENT("deprecated by CORBA 2.3");
/*     */   }
/*     */ 
/*     */   public TypeCode create_sequence_tc(int bound, TypeCode element_type)
/*     */   {
/* 154 */     return delegate.create_sequence_tc(bound, element_type);
/*     */   }
/*     */ 
/*     */   public TypeCode create_string_tc(int bound)
/*     */   {
/* 159 */     return delegate.create_string_tc(bound);
/*     */   }
/*     */ 
/*     */   public TypeCode create_wstring_tc(int bound)
/*     */   {
/* 164 */     return delegate.create_wstring_tc(bound);
/*     */   }
/*     */ 
/*     */   public TypeCode create_struct_tc(String id, String name, StructMember[] members)
/*     */   {
/* 171 */     return delegate.create_struct_tc(id, name, members);
/*     */   }
/*     */ 
/*     */   public TypeCode create_union_tc(String id, String name, TypeCode discriminator_type, UnionMember[] members)
/*     */   {
/* 179 */     return delegate.create_union_tc(id, name, discriminator_type, members);
/*     */   }
/*     */ 
/*     */   public TypeCode get_primitive_tc(TCKind tcKind)
/*     */   {
/* 185 */     return delegate.get_primitive_tc(tcKind);
/*     */   }
/*     */ 
/*     */   public TypeCode create_value_tc(String id, String name, short type_modifier, TypeCode concrete_base, ValueMember[] members)
/*     */   {
/* 194 */     return delegate.create_value_tc(id, name, type_modifier, concrete_base, members);
/*     */   }
/*     */ 
/*     */   public TypeCode create_value_box_tc(String id, String name, TypeCode boxed_type)
/*     */   {
/* 202 */     return delegate.create_value_box_tc(id, name, boxed_type);
/*     */   }
/*     */ 
/*     */   public TypeCode create_abstract_interface_tc(String id, String name)
/*     */   {
/* 207 */     return delegate.create_abstract_interface_tc(id, name);
/*     */   }
/*     */ 
/*     */   public TypeCode create_native_tc(String id, String name)
/*     */   {
/* 212 */     return delegate.create_native_tc(id, name);
/*     */   }
/*     */ 
/*     */   public ExceptionList create_exception_list()
/*     */   {
/* 219 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public NVList create_list(int count)
/*     */   {
/* 224 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public NamedValue create_named_value(String name, Any value, int flags)
/*     */   {
/* 229 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public NVList create_operation_list(Object obj)
/*     */   {
/* 234 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public NVList create_operation_list(OperationDef oper)
/*     */   {
/* 239 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public Object string_to_object(String str)
/*     */   {
/* 244 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public Environment create_environment()
/*     */   {
/* 249 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public ContextList create_context_list()
/*     */   {
/* 254 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public OutputStream create_output_stream()
/*     */   {
/* 259 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Current get_current()
/*     */   {
/* 267 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public Context get_default_context()
/*     */   {
/* 272 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public Request get_next_response()
/*     */   {
/* 277 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public String[] list_initial_services()
/*     */   {
/* 282 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public String object_to_string(Object obj)
/*     */   {
/* 287 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public boolean poll_next_response()
/*     */   {
/* 292 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public Object resolve_initial_references(String identifier)
/*     */     throws InvalidName
/*     */   {
/* 298 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public void send_multiple_requests_deferred(Request[] req)
/*     */   {
/* 303 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public void send_multiple_requests_oneway(Request[] req)
/*     */   {
/* 308 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   protected void set_parameters(String[] args, Properties props)
/*     */   {
/* 313 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   protected void set_parameters(Applet app, Properties props)
/*     */   {
/* 318 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/* 323 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public void shutdown(boolean wait_for_completion)
/*     */   {
/* 328 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public boolean work_pending()
/*     */   {
/* 333 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ 
/*     */   public void perform_work()
/*     */   {
/* 338 */     throw new NO_IMPLEMENT("The Singleton ORB only permits factory methods");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.jacorb.ORBSingleton
 * JD-Core Version:    0.6.0
 */