/*     */ package org.jboss.ejb3.tx;
/*     */ 
/*     */ import javax.ejb.EJBException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TxUtils;
/*     */ 
/*     */ public class BMTInterceptor
/*     */   implements Interceptor
/*     */ {
/*     */   private TransactionManager tm;
/*     */   private boolean isStateless;
/*  49 */   protected static Logger log = Logger.getLogger(BMTInterceptor.class);
/*     */ 
/*     */   public BMTInterceptor(TransactionManager tm, boolean stateless)
/*     */   {
/*  53 */     this.tm = tm;
/*  54 */     this.isStateless = stateless;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  60 */     return BMTInterceptor.class.getName();
/*     */   }
/*     */ 
/*     */   public Object handleStateless(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  67 */     Container container = (Container)invocation.getAdvisor();
/*  68 */     boolean exceptionThrown = false;
/*     */     try
/*     */     {
/*  71 */       localObject1 = invocation.invokeNext();
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */       Object localObject1;
/*  75 */       exceptionThrown = true;
/*  76 */       checkStatelessDone(container, ex);
/*  77 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/*     */     }
/*     */ 
/*  87 */     ret;
/*     */   }
/*     */ 
/*     */   public Object handleStateful(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  94 */     EJBContainerInvocation ejb = (EJBContainerInvocation)invocation;
/*  95 */     Container container = (Container)invocation.getAdvisor();
/*     */ 
/*  97 */     StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
/*  98 */     Transaction tx = (Transaction)ctx.getMetaData().getMetaData("TX", "TX");
/*  99 */     if (tx != null)
/*     */     {
/* 101 */       ctx.getMetaData().addMetaData("TX", "TX", null, PayloadKey.TRANSIENT);
/* 102 */       this.tm.resume(tx);
/*     */     }
/*     */     try
/*     */     {
/* 106 */       localObject1 = invocation.invokeNext();
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/* 110 */       checkBadStateful(container);
/* 111 */       Transaction newTx = this.tm.getTransaction();
/* 112 */       if (newTx != null)
/*     */       {
/* 114 */         ctx.getMetaData().addMetaData("TX", "TX", newTx, PayloadKey.TRANSIENT);
/* 115 */         this.tm.suspend();
/*     */       }
/*     */       else
/*     */       {
/* 119 */         ctx.getMetaData().addMetaData("TX", "TX", null, PayloadKey.TRANSIENT);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 126 */     Transaction oldTx = this.tm.getTransaction();
/* 127 */     if (oldTx != null) this.tm.suspend();
/*     */ 
/*     */     try
/*     */     {
/* 131 */       if (this.isStateless) { localObject1 = handleStateless(invocation); jsr 24; }
/* 132 */       localObject1 = handleStateful(invocation);
/*     */     }
/*     */     finally
/*     */     {
/* 136 */       Object localObject1;
/* 136 */       if (oldTx != null) this.tm.resume(oldTx);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkStatelessDone(Container container, Exception ex)
/*     */   {
/* 144 */     int status = 6;
/*     */     try
/*     */     {
/* 148 */       status = this.tm.getStatus();
/*     */     }
/*     */     catch (SystemException sex)
/*     */     {
/* 152 */       log.error("Failed to get status", sex);
/*     */     }
/*     */ 
/* 155 */     switch (status)
/*     */     {
/*     */     case 0:
/*     */     case 1:
/*     */     case 7:
/*     */     case 8:
/*     */     case 9:
/*     */       try
/*     */       {
/* 164 */         this.tm.rollback();
/*     */       }
/*     */       catch (Exception sex)
/*     */       {
/* 168 */         log.error("Failed to rollback", sex);
/*     */       }
/*     */ 
/*     */     case 2:
/* 172 */       String msg = "Application error: BMT stateless bean " + container.getEjbName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
/*     */ 
/* 174 */       log.error(msg);
/*     */ 
/* 177 */       if (ex != null)
/*     */       {
/* 179 */         if ((ex instanceof EJBException)) {
/* 180 */           throw ((EJBException)ex);
/*     */         }
/* 182 */         throw new EJBException(msg, ex);
/*     */       }
/* 184 */       throw new EJBException(msg);
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     }
/*     */   }
/* 190 */   private void checkBadStateful(Container container) { int status = 6;
/*     */     try
/*     */     {
/* 194 */       status = this.tm.getStatus();
/*     */     }
/*     */     catch (SystemException ex)
/*     */     {
/* 198 */       log.error("Failed to get status", ex);
/*     */     }
/*     */ 
/* 201 */     switch (status)
/*     */     {
/*     */     case 1:
/*     */     case 7:
/*     */     case 8:
/*     */     case 9:
/*     */       try
/*     */       {
/* 209 */         this.tm.rollback();
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 213 */         log.error("Failed to rollback", ex);
/*     */       }
/* 215 */       String msg = "BMT stateful bean '" + container.getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString(status);
/*     */ 
/* 217 */       log.error(msg);
/*     */     case 2:
/*     */     case 3:
/*     */     case 4:
/*     */     case 5:
/*     */     case 6:
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.tx.BMTInterceptor
 * JD-Core Version:    0.6.0
 */