/*     */ package org.jboss.ejb3.timerservice.quartz;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.timerservice.TimedObjectInvoker;
/*     */ import org.jboss.ejb3.timerservice.TimerServiceFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerFactory;
/*     */ import org.quartz.impl.StdSchedulerFactory;
/*     */ import org.quartz.utils.DBConnectionManager;
/*     */ import org.quartz.utils.JNDIConnectionProvider;
/*     */ 
/*     */ public class QuartzTimerServiceFactory extends TimerServiceFactory
/*     */ {
/*  66 */   private static final Logger log = Logger.getLogger(QuartzTimerServiceFactory.class);
/*     */   private TransactionManager tm;
/*     */   private static Scheduler scheduler;
/*     */   private Properties properties;
/*     */   private Properties sqlProperties;
/*     */ 
/*     */   private void createSchema()
/*     */   {
/*     */     try
/*     */     {
/*  83 */       this.tm.begin();
/*     */       try
/*     */       {
/*  86 */         Connection conn = getConnection();
/*     */         try
/*     */         {
/*  89 */           boolean success = execute(conn, "CREATE_TABLE_JOB_DETAILS");
/*  90 */           if (success)
/*     */           {
/*  92 */             execute(conn, "CREATE_TABLE_JOB_LISTENERS");
/*  93 */             execute(conn, "CREATE_TABLE_TRIGGERS");
/*  94 */             execute(conn, "CREATE_TABLE_SIMPLE_TRIGGERS");
/*  95 */             execute(conn, "CREATE_TABLE_CRON_TRIGGERS");
/*  96 */             execute(conn, "CREATE_TABLE_BLOB_TRIGGERS");
/*  97 */             execute(conn, "CREATE_TABLE_TRIGGER_LISTENERS");
/*  98 */             execute(conn, "CREATE_TABLE_CALENDARS");
/*  99 */             execute(conn, "CREATE_TABLE_PAUSED_TRIGGER_GRPS");
/* 100 */             execute(conn, "CREATE_TABLE_FIRED_TRIGGERS");
/* 101 */             execute(conn, "CREATE_TABLE_SCHEDULER_STATE");
/* 102 */             execute(conn, "CREATE_TABLE_LOCKS");
/*     */ 
/* 104 */             execute(conn, "INSERT_TRIGGER_ACCESS");
/* 105 */             execute(conn, "INSERT_JOB_ACCESS");
/* 106 */             execute(conn, "INSERT_CALENDAR_ACCESS");
/* 107 */             execute(conn, "INSERT_STATE_ACCESS");
/* 108 */             execute(conn, "INSERT_MISFIRE_ACCESS");
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 113 */           conn.close();
/*     */         }
/* 115 */         this.tm.commit();
/*     */       }
/*     */       catch (SQLException e)
/*     */       {
/* 119 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (RollbackException e)
/*     */       {
/* 123 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (HeuristicMixedException e)
/*     */       {
/* 127 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (HeuristicRollbackException e)
/*     */       {
/* 131 */         throw new RuntimeException(e);
/*     */       }
/*     */       finally
/*     */       {
/* 135 */         if (this.tm.getStatus() == 0)
/* 136 */           this.tm.rollback();
/*     */       }
/*     */     }
/*     */     catch (SystemException e)
/*     */     {
/* 141 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (NotSupportedException e)
/*     */     {
/* 145 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public TimerService createTimerService(Container container, TimedObjectInvoker invoker)
/*     */   {
/* 158 */     Scheduler scheduler = getScheduler();
/* 159 */     if (scheduler == null) return null;
/*     */ 
/* 161 */     return new TimerServiceImpl(scheduler, container, invoker);
/*     */   }
/*     */ 
/*     */   private boolean execute(Connection conn, String stmtName) throws SQLException
/*     */   {
/* 166 */     String sql = this.sqlProperties.getProperty(stmtName);
/* 167 */     if (sql == null) {
/* 168 */       throw new IllegalStateException("No sql set for '" + stmtName + "'");
/*     */     }
/* 170 */     PreparedStatement stmt = conn.prepareStatement(sql);
/*     */     try
/*     */     {
/* 173 */       stmt.execute();
/* 174 */       i = 1;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */       int i;
/* 178 */       log.warn("sql failed: " + sql);
/* 179 */       if (log.isDebugEnabled())
/* 180 */         log.debug("sql failed: " + sql, e);
/* 181 */       return 0;
/*     */     }
/*     */     finally
/*     */     {
/* 185 */       stmt.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private Connection getConnection() throws SQLException
/*     */   {
/* 191 */     return DBConnectionManager.getInstance().getConnection("myDS");
/*     */   }
/*     */ 
/*     */   protected static Scheduler getScheduler()
/*     */   {
/* 199 */     if (scheduler == null)
/*     */     {
/* 201 */       return null;
/*     */     }
/*     */ 
/* 205 */     return scheduler;
/*     */   }
/*     */ 
/*     */   public void removeTimerService(TimerService aTimerService)
/*     */   {
/* 210 */     TimerServiceImpl timerService = (TimerServiceImpl)aTimerService;
/* 211 */     timerService.shutdown();
/*     */   }
/*     */ 
/*     */   public void restoreTimerService(TimerService aTimerService)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setDataSource(String jndiName)
/*     */   {
/* 221 */     JNDIConnectionProvider connectionProvider = new JNDIConnectionProvider(jndiName, false);
/*     */ 
/* 223 */     DBConnectionManager.getInstance().addConnectionProvider("myDS", connectionProvider);
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties props)
/*     */   {
/* 232 */     this.properties = props;
/*     */   }
/*     */ 
/*     */   public void setSqlProperties(Properties props)
/*     */   {
/* 237 */     this.sqlProperties = props;
/*     */   }
/*     */ 
/*     */   public synchronized void start() throws Exception
/*     */   {
/* 242 */     if (scheduler != null) {
/* 243 */       throw new IllegalStateException("already started");
/*     */     }
/* 245 */     log.debug("properties = " + this.properties);
/*     */ 
/* 247 */     InitialContext ctx = InitialContextFactory.getInitialContext();
/* 248 */     this.tm = ((TransactionManager)ctx.lookup("java:/TransactionManager"));
/*     */ 
/* 250 */     createSchema();
/*     */     SchedulerFactory factory;
/*     */     SchedulerFactory factory;
/* 254 */     if (this.properties == null)
/* 255 */       factory = new StdSchedulerFactory();
/*     */     else
/* 257 */       factory = new StdSchedulerFactory(this.properties);
/* 258 */     scheduler = factory.getScheduler();
/*     */ 
/* 260 */     scheduler.start();
/*     */   }
/*     */ 
/*     */   public synchronized void stop() throws Exception
/*     */   {
/* 265 */     if (scheduler == null) {
/* 266 */       throw new IllegalStateException("already stopped");
/*     */     }
/*     */ 
/* 271 */     scheduler.shutdown();
/*     */ 
/* 273 */     scheduler = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.timerservice.quartz.QuartzTimerServiceFactory
 * JD-Core Version:    0.6.0
 */