/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.LocalProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StatelessLocalProxy extends LocalProxy
/*     */ {
/*     */   private static final long serialVersionUID = -3241008127518089831L;
/*  46 */   private static final Logger log = Logger.getLogger(StatelessLocalProxy.class);
/*     */   AsynchProvider provider;
/*     */ 
/*     */   public StatelessLocalProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StatelessLocalProxy(Container container)
/*     */   {
/*  56 */     super(container);
/*     */   }
/*     */ 
/*     */   public StatelessLocalProxy(AsynchProvider provider, Container container)
/*     */   {
/*  61 */     super(container);
/*  62 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  68 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  70 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  73 */     Object ret = ProxyUtils.handleCallLocally(proxy, this, method, args);
/*  74 */     if (ret != null)
/*     */     {
/*  76 */       return ret;
/*     */     }
/*     */ 
/*  79 */     StatelessContainer container = (StatelessContainer)getContainer();
/*     */ 
/*  81 */     if (container == null)
/*     */     {
/*  83 */       throw new EJBException("Invalid invocation of local interface (null container)");
/*     */     }
/*     */ 
/*  86 */     return container.localInvoke(method, args, (FutureHolder)this.provider);
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/*  91 */     Class[] infs = proxy.getClass().getInterfaces();
/*  92 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/*  94 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/*  95 */       AsynchMixin mixin = new AsynchMixin();
/*  96 */       StatelessLocalProxy handler = new StatelessLocalProxy(mixin, getContainer());
/*  97 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 101 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 121 */     if (getContainer() == null) {
/* 122 */       return this.proxyName;
/*     */     }
/* 124 */     return getContainer().getEjbName();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessLocalProxy
 * JD-Core Version:    0.6.0
 */