/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.remoting.FamilyWrapper;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.remoting.BaseRemoteProxy;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ 
/*     */ public class StatelessClusteredProxy extends BaseRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = -4100015258079818357L;
/*     */   protected FamilyWrapper family;
/*     */   protected LoadBalancePolicy lbPolicy;
/*     */   AsynchProvider provider;
/*     */   protected String partitionName;
/*     */ 
/*     */   public StatelessClusteredProxy(Container container, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lbPolicy, String partitionName)
/*     */   {
/*  64 */     super(container, interceptors);
/*  65 */     this.family = family;
/*  66 */     this.lbPolicy = lbPolicy;
/*  67 */     this.partitionName = partitionName;
/*     */   }
/*     */ 
/*     */   public StatelessClusteredProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lbPolicy, String partitionName)
/*     */   {
/*  72 */     super(containerId, containerGuid, interceptors);
/*  73 */     this.provider = provider;
/*  74 */     this.family = family;
/*  75 */     this.lbPolicy = lbPolicy;
/*  76 */     this.partitionName = partitionName;
/*     */   }
/*     */ 
/*     */   public StatelessClusteredProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  86 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/*  88 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/*  91 */     long hash = MethodHashing.calculateHash(method);
/*  92 */     Object ret = ProxyUtils.handleCallLocally(hash, (JBossProxy)proxy, this, method, args);
/*  93 */     if (ret != null)
/*     */     {
/*  95 */       return ret;
/*     */     }
/*     */ 
/*  98 */     MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
/*  99 */     sri.setArguments(args);
/* 100 */     sri.setInstanceResolver(this.metadata);
/* 101 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/* 102 */     sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "CLUSTER_FAMILY_WRAPPER", this.family, PayloadKey.AS_IS);
/* 103 */     sri.getMetaData().addMetaData("CLUSTERED_REMOTING", "LOADBALANCE_POLICY", this.lbPolicy, PayloadKey.AS_IS);
/* 104 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 105 */     sri.getMetaData().addMetaData("PARTITION_NAME", "PARTITION_NAME", this.partitionName, PayloadKey.TRANSIENT);
/* 106 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/* 108 */     if (this.provider != null)
/*     */     {
/* 110 */       sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/*     */     }
/* 112 */     return sri.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 117 */     Class[] infs = proxy.getClass().getInterfaces();
/* 118 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 120 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 121 */       AsynchMixin mixin = new AsynchMixin();
/* 122 */       Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
/* 123 */       StatelessClusteredProxy handler = new StatelessClusteredProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.family, this.lbPolicy, this.partitionName);
/* 124 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 128 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 133 */     return this.containerId.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessClusteredProxy
 * JD-Core Version:    0.6.0
 */