/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.aspects.remoting.FamilyWrapper;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.Clustered;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
/*     */ import org.jboss.ha.client.loadbalance.RandomRobin;
/*     */ import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
/*     */ import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
/*     */ import org.jboss.ha.framework.interfaces.DistributedReplicantManager.ReplicantListener;
/*     */ import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
/*     */ import org.jboss.ha.framework.interfaces.HAPartition;
/*     */ import org.jboss.ha.framework.server.HATarget;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatelessClusterProxyFactory extends BaseStatelessProxyFactory
/*     */   implements RemoteProxyFactory, DistributedReplicantManager.ReplicantListener
/*     */ {
/*     */   private static final Logger log;
/*     */   private RemoteBinding binding;
/*     */   private Clustered clustered;
/*     */   private InvokerLocator locator;
/*     */   private DistributedReplicantManager drm;
/*     */   private HATarget hatarget;
/*     */   private String proxyFamilyName;
/*     */   private LoadBalancePolicy lbPolicy;
/*     */   private FamilyWrapper wrapper;
/*     */   private Object proxy;
/*     */ 
/*     */   public StatelessClusterProxyFactory(SessionContainer container, RemoteBinding binding, Clustered clustered)
/*     */   {
/*  70 */     super(container, binding.jndiBinding());
/*     */ 
/*  72 */     assert (clustered != null) : "clustered is null";
/*     */ 
/*  74 */     this.binding = binding;
/*  75 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   protected Class[] getInterfaces()
/*     */   {
/*  80 */     Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(getContainer());
/*  81 */     Class[] interfaces = new Class[remoteInterfaces.length + 1];
/*  82 */     System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
/*  83 */     interfaces[remoteInterfaces.length] = JBossProxy.class;
/*  84 */     return interfaces;
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  89 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/*  90 */     this.locator = new InvokerLocator(clientBindUrl);
/*  91 */     String partitionName = ((StatelessContainer)getContainer()).getPartitionName();
/*  92 */     this.proxyFamilyName = (((StatelessContainer)getContainer()).getDeploymentQualifiedName() + this.locator.getProtocol() + partitionName);
/*  93 */     HAPartition partition = (HAPartition)getContainer().getInitialContext().lookup("/HAPartition/" + partitionName);
/*  94 */     this.hatarget = new HATarget(partition, this.proxyFamilyName, this.locator, 2);
/*  95 */     ClusteringTargetsRepository.initTarget(this.proxyFamilyName, this.hatarget.getReplicants());
/*  96 */     ((StatelessContainer)getContainer()).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
/*  97 */     if ((this.clustered.loadBalancePolicy() == null) || (this.clustered.loadBalancePolicy().equals(LoadBalancePolicy.class)))
/*     */     {
/*  99 */       this.lbPolicy = new RandomRobin();
/*     */     }
/*     */     else
/*     */     {
/* 103 */       this.lbPolicy = ((LoadBalancePolicy)this.clustered.loadBalancePolicy().newInstance());
/*     */     }
/* 105 */     this.wrapper = new FamilyWrapper(this.proxyFamilyName, this.hatarget.getReplicants());
/*     */ 
/* 107 */     this.drm = partition.getDistributedReplicantManager();
/* 108 */     this.drm.registerListener(this.proxyFamilyName, this);
/*     */ 
/* 110 */     super.start();
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 115 */     super.stop();
/* 116 */     this.proxy = null;
/* 117 */     this.hatarget.destroy();
/* 118 */     this.drm.unregisterListener(this.proxyFamilyName, this);
/* 119 */     ((StatelessContainer)getContainer()).getClusterFamilies().remove(this.proxyFamilyName);
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 126 */     Object containerId = getContainer().getObjectName().getCanonicalName();
/* 127 */     String stackName = "ClusteredStatelessSessionClientInterceptors";
/* 128 */     if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */     {
/* 130 */       stackName = this.binding.interceptorStack();
/*     */     }
/* 132 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/*     */ 
/* 137 */     String partitionName = ((StatelessContainer)getContainer()).getPartitionName();
/*     */ 
/* 139 */     this.proxy = constructProxy(new StatelessClusteredProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.wrapper, this.lbPolicy, partitionName));
/*     */ 
/* 141 */     return this.proxy;
/*     */   }
/*     */ 
/*     */   protected StatelessHandleImpl getHandle()
/*     */   {
/* 165 */     StatelessHandleImpl handle = new StatelessHandleImpl();
/* 166 */     handle.jndiName = this.binding.jndiBinding();
/*     */ 
/* 168 */     return handle;
/*     */   }
/*     */ 
/*     */   public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId)
/*     */   {
/*     */     try
/*     */     {
/* 178 */       ArrayList targets = new ArrayList(newReplicants);
/* 179 */       this.wrapper.get().updateClusterInfo(targets, newReplicantsViewId);
/*     */ 
/* 182 */       if (this.proxy != null)
/* 183 */         bindProxy(this.proxy);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 187 */       log.error(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  56 */     log = Logger.getLogger(StatelessClusterProxyFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.StatelessClusterProxyFactory
 * JD-Core Version:    0.6.0
 */