/*     */ package org.jboss.ejb3.stateless;
/*     */ 
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import javassist.util.proxy.MethodHandler;
/*     */ import javassist.util.proxy.ProxyFactory;
/*     */ import javassist.util.proxy.ProxyObject;
/*     */ 
/*     */ public class JavassistProxy
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private MethodHandler handler;
/*     */   private Class[] interfaces;
/*     */ 
/*     */   protected static void pokeInterfaces(JavassistProxy proxy, Class[] interfaces)
/*     */   {
/*  65 */     proxy.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   private Object readResolve() throws ObjectStreamException
/*     */   {
/*  70 */     System.err.println("JavassistProxy.readResolve");
/*     */     try {
/*  72 */       ProxyFactory proxyFactory = new ProxyFactory()
/*     */       {
/*     */         protected ClassLoader getClassLoader() {
/*  75 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/*     */       };
/*  78 */       proxyFactory.setInterfaces(this.interfaces);
/*  79 */       proxyFactory.setSuperclass(JavassistProxy.class);
/*  80 */       Class proxyClass = proxyFactory.createClass();
/*  81 */       Constructor proxyConstructor = proxyClass.getConstructor((Class[])null);
/*  82 */       JavassistProxy proxy = (JavassistProxy)proxyConstructor.newInstance((Object[])null);
/*  83 */       proxy.setMethodHandler(this.handler);
/*  84 */       proxy.interfaces = this.interfaces;
/*  85 */       return proxy;
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  89 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/*  93 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/*  97 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 101 */     throw new RuntimeException(e.getTargetException());
/*     */   }
/*     */ 
/*     */   protected void setInterfaces(Class[] interfaces)
/*     */   {
/* 108 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   protected void setMethodHandler(MethodHandler handler)
/*     */   {
/* 114 */     ((ProxyObject)this).setHandler(handler);
/* 115 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   private Object writeReplace() throws ObjectStreamException
/*     */   {
/* 120 */     System.err.println("JavassistProxy.writeReplace");
/* 121 */     JavassistProxy replacement = new JavassistProxyReplacement();
/* 122 */     replacement.handler = this.handler;
/* 123 */     replacement.interfaces = this.interfaces;
/* 124 */     return replacement;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateless.JavassistProxy
 * JD-Core Version:    0.6.0
 */