/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.ejb.RemoteHome;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.advice.AdviceStack;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
/*     */ import org.jboss.aspects.remoting.PojiProxy;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.JBossProxy;
/*     */ import org.jboss.ejb3.ProxyFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.IsLocalProxyFactoryInterceptor;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ 
/*     */ public class StatefulRemoteProxyFactory extends BaseStatefulProxyFactory
/*     */   implements RemoteProxyFactory
/*     */ {
/*     */   private static final Logger log;
/*     */   private RemoteBinding binding;
/*     */   private InvokerLocator locator;
/*     */ 
/*     */   public StatefulRemoteProxyFactory(SessionContainer container, RemoteBinding binding)
/*     */   {
/*  69 */     super(container, binding.jndiBinding());
/*     */ 
/*  71 */     this.binding = binding;
/*     */   }
/*     */ 
/*     */   protected Class<?>[] getInterfaces()
/*     */   {
/*  76 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/*  77 */     RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
/*     */ 
/*  79 */     boolean bindTogether = false;
/*     */ 
/*  81 */     if ((remoteHome != null) && (bindHomeAndBusinessTogether(statefulContainer))) {
/*  82 */       bindTogether = true;
/*     */     }
/*     */ 
/*  85 */     Set remoteInterfaces = new HashSet();
/*  86 */     remoteInterfaces.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(getContainer())));
/*     */ 
/*  89 */     ensureEjb21ViewComplete(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces(getContainer()));
/*     */ 
/*  93 */     remoteInterfaces.add(JBossProxy.class);
/*     */ 
/*  96 */     if (bindTogether)
/*     */     {
/*  98 */       remoteInterfaces.add(remoteHome.value());
/*     */     }
/*     */ 
/* 102 */     return (Class[])remoteInterfaces.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   protected boolean bindHomeAndBusinessTogether(SessionContainer container)
/*     */   {
/* 108 */     return ProxyFactoryHelper.getHomeJndiName(container).equals(ProxyFactoryHelper.getRemoteJndiName(container));
/*     */   }
/*     */ 
/*     */   public void init() throws Exception
/*     */   {
/* 113 */     super.init();
/* 114 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/* 115 */     this.locator = new InvokerLocator(clientBindUrl);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 120 */     init();
/*     */ 
/* 122 */     super.start();
/* 123 */     Class[] interfaces = { ProxyFactory.class };
/* 124 */     String targetId = getTargetId();
/* 125 */     String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
/* 126 */     Object factoryProxy = createPojiProxy(targetId, interfaces, clientBindUrl);
/* 127 */     log.debug("Binding proxy factory for " + getContainer().getEjbName() + " in JNDI at " + this.jndiName + "StatefulProxyFactory" + " with client bind url " + clientBindUrl);
/*     */     try
/*     */     {
/* 130 */       Util.rebind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory", factoryProxy);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 134 */       NamingException namingException = new NamingException("Could not bind stateful remote proxy with ejb name " + getContainer().getEjbName() + " into JNDI under jndiName: " + getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
/* 135 */       namingException.setRootCause(e);
/* 136 */       throw namingException;
/*     */     }
/* 138 */     assert (!Dispatcher.singleton.isRegistered(targetId)) : (targetId + " is already registered");
/* 139 */     Dispatcher.singleton.registerTarget(targetId, this);
/*     */ 
/* 141 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/* 142 */     RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
/* 143 */     if ((remoteHome != null) && (!bindHomeAndBusinessTogether(statefulContainer)))
/*     */     {
/* 145 */       Object homeProxy = createHomeProxy(remoteHome.value());
/* 146 */       String homeJndiName = ProxyFactoryHelper.getHomeJndiName(getContainer());
/* 147 */       log.debug("Binding home proxy at " + homeJndiName);
/* 148 */       Util.rebind(getContainer().getInitialContext(), homeJndiName, homeProxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 154 */     Util.unbind(getContainer().getInitialContext(), this.jndiName + "StatefulProxyFactory");
/* 155 */     Dispatcher.singleton.unregisterTarget(getTargetId());
/*     */ 
/* 157 */     SessionContainer statefulContainer = (SessionContainer)getContainer();
/* 158 */     RemoteHome remoteHome = (RemoteHome)statefulContainer.resolveAnnotation(RemoteHome.class);
/* 159 */     if ((remoteHome != null) && (!bindHomeAndBusinessTogether(statefulContainer)))
/*     */     {
/* 161 */       Util.unbind(getContainer().getInitialContext(), ProxyFactoryHelper.getHomeJndiName(getContainer()));
/*     */     }
/* 163 */     super.stop();
/*     */   }
/*     */ 
/*     */   public Object createHomeProxy(Class homeInterface)
/*     */   {
/*     */     try
/*     */     {
/* 171 */       Object containerId = getContainer().getObjectName().getCanonicalName();
/* 172 */       String stackName = "StatefulSessionClientInterceptors";
/* 173 */       if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */       {
/* 175 */         stackName = this.binding.interceptorStack();
/*     */       }
/* 177 */       AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 178 */       if (stack == null) throw new RuntimeException("unable to find interceptor stack: " + stackName);
/* 179 */       StatefulHomeRemoteProxy proxy = new StatefulHomeRemoteProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.locator);
/*     */ 
/* 181 */       setEjb21Objects(proxy);
/* 182 */       Class[] intfs = { homeInterface };
/* 183 */       return Proxy.newProxyInstance(getContainer().getBeanClass().getClassLoader(), intfs, proxy);
/*     */     }
/*     */     catch (IllegalArgumentException e) {
/*     */     }
/* 187 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object createProxy()
/*     */   {
/* 192 */     String stackName = "StatefulSessionClientInterceptors";
/* 193 */     if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */     {
/* 195 */       stackName = this.binding.interceptorStack();
/*     */     }
/* 197 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 198 */     if (stack == null) throw new RuntimeException("unable to find interceptor stack: " + stackName);
/* 199 */     StatefulRemoteProxy proxy = new StatefulRemoteProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.locator);
/*     */ 
/* 201 */     setEjb21Objects(proxy);
/* 202 */     return constructProxy(proxy);
/*     */   }
/*     */ 
/*     */   protected StatefulHandleImpl getHandle()
/*     */   {
/* 207 */     StatefulHandleImpl handle = new StatefulHandleImpl();
/* 208 */     handle.jndiName = this.jndiName;
/*     */ 
/* 210 */     return handle;
/*     */   }
/*     */ 
/*     */   public Object createProxy(Object id)
/*     */   {
/* 215 */     String stackName = "StatefulSessionClientInterceptors";
/* 216 */     if ((this.binding.interceptorStack() != null) && (!this.binding.interceptorStack().equals("")))
/*     */     {
/* 218 */       stackName = this.binding.interceptorStack();
/*     */     }
/* 220 */     AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
/* 221 */     StatefulRemoteProxy proxy = new StatefulRemoteProxy(getContainer(), stack.createInterceptors((Advisor)getContainer(), null), this.locator, id);
/*     */ 
/* 223 */     setEjb21Objects(proxy);
/* 224 */     return constructProxy(proxy);
/*     */   }
/*     */ 
/*     */   protected String getTargetId()
/*     */   {
/* 232 */     assert (this.jndiName != null) : "jndiName is null";
/* 233 */     return this.jndiName + "StatefulProxyFactory";
/*     */   }
/*     */ 
/*     */   protected Object createPojiProxy(Object oid, Class[] interfaces, String uri) throws Exception
/*     */   {
/* 238 */     InvokerLocator locator = new InvokerLocator(uri);
/* 239 */     Interceptor[] interceptors = { IsLocalProxyFactoryInterceptor.singleton, InvokeRemoteInterceptor.singleton };
/* 240 */     PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
/* 241 */     return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, proxy);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  60 */     log = Logger.getLogger(StatefulRemoteProxyFactory.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulRemoteProxyFactory
 * JD-Core Version:    0.6.0
 */