/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.Handle;
/*     */ import javax.ejb.HomeHandle;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.session.BaseSessionRemoteProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class StatefulRemoteProxy extends BaseSessionRemoteProxy
/*     */ {
/*     */   private static final long serialVersionUID = -2164496320326661428L;
/*  55 */   private static final Logger log = Logger.getLogger(StatefulRemoteProxy.class);
/*     */   protected InvokerLocator uri;
/*     */   AsynchProvider provider;
/*     */   private Handle handle;
/*     */   private HomeHandle homeHandle;
/*     */   private EJBMetaData ejbMetaData;
/*     */ 
/*     */   public StatefulRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  66 */     super(container, interceptors);
/*  67 */     this.uri = uri;
/*     */   }
/*     */ 
/*     */   public StatefulRemoteProxy(Container container, Interceptor[] interceptors, InvokerLocator uri, Object id)
/*     */   {
/*  72 */     super(container, interceptors);
/*  73 */     this.uri = uri;
/*  74 */     this.id = id;
/*     */   }
/*     */ 
/*     */   public StatefulRemoteProxy(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, InvokerLocator uri)
/*     */   {
/*  79 */     super(containerId, containerGuid, interceptors);
/*  80 */     this.uri = uri;
/*  81 */     this.provider = provider;
/*     */   }
/*     */ 
/*     */   protected StatefulRemoteProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setHandle(StatefulHandleImpl handle)
/*     */   {
/*  90 */     this.handle = handle;
/*  91 */     handle.id = this.id;
/*     */   }
/*     */ 
/*     */   public void setHomeHandle(HomeHandle homeHandle)
/*     */   {
/*  96 */     this.homeHandle = homeHandle;
/*     */   }
/*     */ 
/*     */   public void setEjbMetaData(EJBMetaData ejbMetaData)
/*     */   {
/* 101 */     this.ejbMetaData = ejbMetaData;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 107 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/* 109 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/* 112 */     long hash = MethodHashing.calculateHash(method);
/* 113 */     Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
/* 114 */     if (ret != null)
/*     */     {
/* 116 */       return ret;
/*     */     }
/*     */ 
/* 119 */     ret = handleEjb21CallLocally(method, args);
/* 120 */     if (ret != null)
/*     */     {
/* 122 */       return ret;
/*     */     }
/*     */ 
/* 125 */     StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, this.id);
/* 126 */     sri.setArguments(args);
/* 127 */     sri.setInstanceResolver(this.metadata);
/* 128 */     sri.getMetaData().addMetaData("DISPATCHER", "OID", this.containerId, PayloadKey.AS_IS);
/* 129 */     sri.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", this.uri, PayloadKey.AS_IS);
/* 130 */     sri.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
/* 131 */     sri.getMetaData().addMetaData("IS_LOCAL", "GUID", this.containerGuid, PayloadKey.AS_IS);
/*     */ 
/* 133 */     if (this.provider != null)
/*     */     {
/* 135 */       sri.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/*     */     }
/*     */     try
/*     */     {
/* 139 */       Object rtn = sri.invokeNext();
/*     */ 
/* 141 */       if (this.id == null)
/*     */       {
/* 143 */         this.id = sri.getResponseAttachment("NEW_ID");
/*     */       }
/* 145 */       return rtn;
/*     */     }
/*     */     catch (ForwardId forward)
/*     */     {
/* 151 */       this.id = forward.getId();
/* 152 */     }throw forward.getCause();
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 158 */     Class[] infs = proxy.getClass().getInterfaces();
/* 159 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 161 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 162 */       AsynchMixin mixin = new AsynchMixin();
/* 163 */       Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
/* 164 */       StatefulRemoteProxy handler = new StatefulRemoteProxy(mixin, this.containerId, this.containerGuid, newInterceptors, this.uri);
/* 165 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 169 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 174 */     if (this.id != null)
/*     */     {
/* 176 */       return this.containerId.toString() + ":" + this.id.toString();
/*     */     }
/*     */ 
/* 181 */     GUID guid = new GUID();
/* 182 */     return this.containerId.toString() + ":" + guid.toString();
/*     */   }
/*     */ 
/*     */   private Object handleEjb21CallLocally(Method method, Object[] args)
/*     */   {
/* 188 */     if (method.equals(ProxyUtils.GET_HOME_HANDLE))
/*     */     {
/* 190 */       return this.homeHandle;
/* 191 */     }if (method.equals(ProxyUtils.GET_EJB_METADATA))
/*     */     {
/* 193 */       return this.ejbMetaData;
/* 194 */     }if (method.equals(ProxyUtils.GET_HANDLE))
/*     */     {
/* 196 */       return this.handle;
/*     */     }
/*     */ 
/* 199 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulRemoteProxy
 * JD-Core Version:    0.6.0
 */