/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.dgc.VMID;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.LocalProxy;
/*     */ import org.jboss.ejb3.ProxyUtils;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ 
/*     */ public class StatefulLocalProxy extends LocalProxy
/*     */ {
/*     */   private static final long serialVersionUID = 206913210970415540L;
/*     */   protected Object id;
/*     */   AsynchProvider provider;
/*  57 */   protected boolean isClustered = false;
/*     */ 
/*     */   public StatefulLocalProxy(Container container, Object id, VMID vmid)
/*     */   {
/*  61 */     super(container);
/*  62 */     this.id = id;
/*  63 */     this.containerGuid = Ejb3Registry.guid(container, vmid);
/*  64 */     this.isClustered = ((SessionContainer)container).isClustered();
/*     */   }
/*     */ 
/*     */   public StatefulLocalProxy(AsynchProvider provider, Container container, Object id)
/*     */   {
/*  69 */     super(container);
/*  70 */     this.provider = provider;
/*  71 */     this.id = id;
/*  72 */     this.containerGuid = Ejb3Registry.guid(container);
/*  73 */     this.isClustered = ((SessionContainer)container).isClustered();
/*     */   }
/*     */ 
/*     */   public StatefulLocalProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  83 */     super.readExternal(in);
/*  84 */     this.id = in.readObject();
/*  85 */     this.isClustered = in.readBoolean();
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/*  91 */     super.writeExternal(out);
/*  92 */     out.writeObject(this.id);
/*  93 */     out.writeBoolean(this.isClustered);
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/*  99 */     if (method.getDeclaringClass() == AsynchProvider.class)
/*     */     {
/* 101 */       return this.provider.getFuture();
/*     */     }
/*     */ 
/* 105 */     Object ret = ProxyUtils.handleCallLocally(proxy, this, method, args);
/* 106 */     if (ret != null)
/*     */     {
/* 108 */       return ret;
/*     */     }
/*     */ 
/* 111 */     Container container = Ejb3Registry.findContainer(this.containerGuid);
/* 112 */     if ((this.isClustered) && (container == null) && (Ejb3Registry.hasClusterContainer(this.containerClusterUid))) {
/* 113 */       container = Ejb3Registry.getClusterContainer(this.containerClusterUid);
/*     */     }
/* 115 */     if (container == null) {
/* 116 */       throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
/*     */     }
/* 118 */     SessionContainer sfsb = (SessionContainer)container;
/* 119 */     return sfsb.localInvoke(this.id, method, args, (FutureHolder)this.provider);
/*     */   }
/*     */ 
/*     */   public Object getAsynchronousProxy(Object proxy)
/*     */   {
/* 124 */     Class[] infs = proxy.getClass().getInterfaces();
/* 125 */     if (!ProxyUtils.isAsynchronous(infs))
/*     */     {
/* 127 */       Class[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
/* 128 */       AsynchMixin mixin = new AsynchMixin();
/* 129 */       StatefulLocalProxy handler = new StatefulLocalProxy(mixin, getContainer(), this.id);
/* 130 */       return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, handler);
/*     */     }
/*     */ 
/* 134 */     return proxy;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 139 */     if ((getContainer() != null) && (this.id != null))
/*     */     {
/* 141 */       return getContainer().getEjbName().toString() + ":" + this.id.toString();
/*     */     }
/*     */ 
/* 144 */     return this.proxyName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulLocalProxy
 * JD-Core Version:    0.6.0
 */