/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.RemoteException;
/*     */ import java.security.AccessControlException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Handle;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ 
/*     */ public class StatefulHandleImpl
/*     */   implements Handle
/*     */ {
/*  53 */   private static final Logger log = Logger.getLogger(StatefulHandleImpl.class);
/*     */   static final long serialVersionUID = -6324520755180597156L;
/*     */   protected static final Method GET_EJB_OBJECT;
/*  62 */   private Object invokerID = null;
/*     */   public int objectName;
/*     */   public String jndiName;
/*     */   public String invokerProxyBinding;
/*     */   public Invoker invoker;
/*     */   public Object id;
/*     */   protected Hashtable jndiEnv;
/*     */ 
/*     */   public StatefulHandleImpl()
/*     */   {
/*     */   }
/*     */ 
/*     */   public StatefulHandleImpl(int objectName, String jndiName, Invoker invoker, String invokerProxyBinding, Object id, Object invokerID)
/*     */   {
/* 110 */     this.jndiName = jndiName;
/* 111 */     this.id = id;
/* 112 */     this.jndiEnv = ((Hashtable)NamingContextFactory.lastInitialContextEnv.get());
/*     */     try
/*     */     {
/* 115 */       String property = System.getProperty("org.jboss.ejb.sfsb.handle.V327");
/* 116 */       if (property != null)
/*     */       {
/* 118 */         this.invokerProxyBinding = invokerProxyBinding;
/* 119 */         this.invokerID = invokerID;
/* 120 */         this.objectName = objectName;
/* 121 */         this.invoker = invoker;
/*     */       }
/*     */     }
/*     */     catch (AccessControlException ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getID()
/*     */   {
/* 135 */     return this.id;
/*     */   }
/*     */ 
/*     */   public String getJNDIName()
/*     */   {
/* 143 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public EJBObject getEJBObject()
/*     */     throws RemoteException
/*     */   {
/*     */     try
/*     */     {
/* 168 */       InitialContext ic = InitialContextFactory.getInitialContext(this.jndiEnv);
/*     */ 
/* 170 */       Proxy proxy = (Proxy)ic.lookup(this.jndiName);
/*     */ 
/* 172 */       return (EJBObject)proxy;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 176 */       t.printStackTrace();
/* 177 */     }throw new RemoteException("Error during getEJBObject", t);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  71 */       GET_EJB_OBJECT = Handle.class.getMethod("getEJBObject", new Class[0]);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  75 */       e.printStackTrace();
/*  76 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulHandleImpl
 * JD-Core Version:    0.6.0
 */