/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ 
/*     */ public class StatefulBeanContextReference
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 2644760020735482423L;
/*     */   private transient StatefulBeanContext beanContext;
/*     */   private Object oid;
/*     */   private String containerGuid;
/*     */   private String containerClusterUid;
/*  47 */   private boolean isClustered = false;
/*     */ 
/*     */   public StatefulBeanContextReference(StatefulBeanContext beanContext)
/*     */   {
/*  63 */     assert (beanContext != null) : "beanContext is null";
/*     */ 
/*  65 */     this.beanContext = beanContext;
/*  66 */     this.oid = beanContext.getId();
/*  67 */     this.containerGuid = Ejb3Registry.guid(beanContext.getContainer());
/*  68 */     this.containerClusterUid = Ejb3Registry.clusterUid(beanContext.getContainer());
/*  69 */     this.isClustered = beanContext.getContainer().isClustered();
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext getBeanContext()
/*     */   {
/*  86 */     if (this.beanContext == null)
/*     */     {
/*  88 */       StatefulContainer container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
/*  89 */       if ((this.isClustered) && (container == null)) {
/*  90 */         container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
/*     */       }
/*     */ 
/*  93 */       this.beanContext = container.getCache().get(this.oid, false);
/*     */ 
/*  95 */       assert (this.beanContext != null) : "beanContext no longer in cache";
/*     */     }
/*  97 */     return this.beanContext;
/*     */   }
/*     */ 
/*     */   private Object writeReplace()
/*     */   {
/* 102 */     return new Serialized(this, null);
/*     */   }
/*     */ 
/*     */   private static class Serialized
/*     */     implements Serializable
/*     */   {
/*     */     private Object oid;
/*     */     private String containerGuid;
/*     */     private String containerClusterUid;
/*  54 */     private boolean isClustered = false;
/*     */ 
/*     */     private Serialized(StatefulBeanContextReference ref)
/*     */     {
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.StatefulBeanContextReference
 * JD-Core Version:    0.6.0
 */