/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.SessionSynchronization;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.ejb3.cache.StatefulCache;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ 
/*     */ public class SessionSynchronizationInterceptor
/*     */   implements Interceptor
/*     */ {
/*     */   private TransactionManager tm;
/*     */ 
/*     */   public SessionSynchronizationInterceptor()
/*     */   {
/*  49 */     this.tm = TxUtil.getTransactionManager();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  54 */     return null;
/*     */   }
/*     */ 
/*     */   protected void registerSessionSynchronization(StatefulBeanContext ctx)
/*     */     throws SystemException
/*     */   {
/* 107 */     if (ctx.isTxSynchronized()) return;
/* 108 */     Transaction tx = this.tm.getTransaction();
/* 109 */     if (tx == null) return;
/* 110 */     if (tx.getStatus() == 1) return;
/* 111 */     SFSBSessionSynchronization synch = new SFSBSessionSynchronization(ctx);
/* 112 */     SessionSynchronization bean = (SessionSynchronization)ctx.getInstance();
/*     */     try
/*     */     {
/* 115 */       bean.afterBegin();
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 119 */       throw e;
/*     */     }
/*     */     catch (RemoteException e)
/*     */     {
/* 123 */       throw new EJBException(e);
/*     */     }
/*     */     try
/*     */     {
/* 127 */       tx.registerSynchronization(synch);
/*     */     }
/*     */     catch (RollbackException ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/* 136 */     StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
/* 137 */     StatefulBeanContext target = (StatefulBeanContext)ejb.getBeanContext();
/* 138 */     if ((target.getInstance() instanceof SessionSynchronization))
/*     */     {
/* 140 */       registerSessionSynchronization(target);
/*     */     }
/* 142 */     return ejb.invokeNext();
/*     */   }
/*     */ 
/*     */   protected static class SFSBSessionSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     private StatefulBeanContext ctx;
/*     */ 
/*     */     public SFSBSessionSynchronization(StatefulBeanContext ctx)
/*     */     {
/*  63 */       this.ctx = ctx;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*  68 */       SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
/*     */       try
/*     */       {
/*  71 */         bean.beforeCompletion();
/*     */       }
/*     */       catch (RemoteException e)
/*     */       {
/*  75 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/*  81 */       this.ctx.setTxSynchronized(false);
/*  82 */       SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
/*     */       try
/*     */       {
/*  85 */         if (status == 3)
/*     */         {
/*  87 */           bean.afterCompletion(true);
/*     */         }
/*     */         else
/*     */         {
/*  91 */           bean.afterCompletion(false);
/*     */         }
/*     */       }
/*     */       catch (RemoteException ignore)
/*     */       {
/*     */       }
/*     */       finally
/*     */       {
/*  99 */         StatefulContainer container = (StatefulContainer)this.ctx.getContainer();
/* 100 */         container.getCache().release(this.ctx);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.SessionSynchronizationInterceptor
 * JD-Core Version:    0.6.0
 */