/*     */ package org.jboss.ejb3.stateful;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.locks.ReentrantLock;
/*     */ import javax.ejb.EJBContext;
/*     */ import javax.management.ObjectName;
/*     */ import javax.persistence.EntityManager;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.ejb3.interceptor.InterceptorInfo;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ 
/*     */ public class ProxiedStatefulBeanContext extends StatefulBeanContext
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = -5156610459343035743L;
/*     */   private transient StatefulBeanContext delegate;
/*     */   private Object oid;
/*     */   private String containerId;
/*     */   private StatefulBeanContextReference parentRef;
/*     */ 
/*     */   public ProxiedStatefulBeanContext(StatefulBeanContext delegate)
/*     */   {
/*  62 */     super(delegate.getContainer(), delegate.getInstance());
/*     */ 
/*  64 */     this.delegate = delegate;
/*  65 */     this.oid = delegate.getId();
/*  66 */     this.containerId = ((SessionContainer)this.container).getObjectName().getCanonicalName();
/*  67 */     this.parentRef = new StatefulBeanContextReference(delegate.getContainedIn());
/*     */   }
/*     */ 
/*     */   protected StatefulBeanContext getDelegate()
/*     */   {
/*  72 */     if (this.delegate == null)
/*     */     {
/*  74 */       for (StatefulBeanContext ctx : this.parentRef.getBeanContext().getContains())
/*     */       {
/*  76 */         Object matchingOid = ctx.getId();
/*  77 */         if ((this.oid.equals(matchingOid)) && (ctx.getContainer().getObjectName().getCanonicalName().equals(this.containerId)))
/*     */         {
/*  81 */           this.delegate = ctx;
/*  82 */           break;
/*     */         }
/*     */       }
/*  85 */       if (this.delegate == null) {
/*  86 */         throw new RuntimeException("Failed to read delegate");
/*     */       }
/*     */ 
/*  91 */       this.markedForReplication = true;
/*     */     }
/*  93 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/*  98 */     out.writeObject(this.oid);
/*  99 */     out.writeUTF(this.containerId);
/* 100 */     out.writeObject(this.parentRef);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 106 */     this.oid = in.readObject();
/* 107 */     this.containerId = in.readUTF();
/* 108 */     this.parentRef = ((StatefulBeanContextReference)in.readObject());
/*     */ 
/* 110 */     assert (this.parentRef != null) : "parentRef is null";
/*     */   }
/*     */ 
/*     */   public List<StatefulBeanContext> getContains()
/*     */   {
/* 116 */     return getDelegate().getContains();
/*     */   }
/*     */ 
/*     */   public EntityManager getExtendedPersistenceContext(String id)
/*     */   {
/* 122 */     return getDelegate().getExtendedPersistenceContext(id);
/*     */   }
/*     */ 
/*     */   public void addExtendedPersistenceContext(String id, EntityManager pc)
/*     */   {
/* 128 */     getDelegate().addExtendedPersistenceContext(id, pc);
/*     */   }
/*     */ 
/*     */   public Map<String, EntityManager> getExtendedPersistenceContexts()
/*     */   {
/* 134 */     return getDelegate().getExtendedPersistenceContexts();
/*     */   }
/*     */ 
/*     */   public void removeExtendedPersistenceContext(String id)
/*     */   {
/* 140 */     getDelegate().removeExtendedPersistenceContext(id);
/*     */   }
/*     */ 
/*     */   public boolean scanForExtendedPersistenceContext(String id, StatefulBeanContext ignore)
/*     */   {
/* 146 */     return getDelegate().scanForExtendedPersistenceContext(id, ignore);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext getContainedIn()
/*     */   {
/* 152 */     return getDelegate().getContainedIn();
/*     */   }
/*     */ 
/*     */   public void addContains(StatefulBeanContext ctx)
/*     */   {
/* 158 */     getDelegate().addContains(ctx);
/*     */   }
/*     */ 
/*     */   public void removeContains(StatefulBeanContext ctx)
/*     */   {
/* 164 */     getDelegate().removeContains(ctx);
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext pushContainedIn()
/*     */   {
/* 170 */     return getDelegate().pushContainedIn();
/*     */   }
/*     */ 
/*     */   public void popContainedIn()
/*     */   {
/* 176 */     getDelegate().popContainedIn();
/*     */   }
/*     */ 
/*     */   public StatefulBeanContext getUltimateContainedIn()
/*     */   {
/* 182 */     return getDelegate().getUltimateContainedIn();
/*     */   }
/*     */ 
/*     */   public boolean isInUse()
/*     */   {
/* 189 */     return super.isInUse();
/*     */   }
/*     */ 
/*     */   public void setInUse(boolean inUse)
/*     */   {
/* 195 */     super.setInUse(inUse);
/*     */ 
/* 197 */     getDelegate().setInUse(inUse);
/*     */ 
/* 199 */     if (!inUse)
/*     */     {
/* 204 */       this.delegate = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDiscarded()
/*     */   {
/* 211 */     return getDelegate().isDiscarded();
/*     */   }
/*     */ 
/*     */   public void setDiscarded(boolean discarded)
/*     */   {
/* 217 */     getDelegate().setDiscarded(discarded);
/*     */   }
/*     */ 
/*     */   public boolean isRemoved()
/*     */   {
/* 223 */     return getDelegate().isRemoved();
/*     */   }
/*     */ 
/*     */   public ReentrantLock getLock()
/*     */   {
/* 229 */     return getDelegate().getLock();
/*     */   }
/*     */ 
/*     */   public boolean isInInvocation()
/*     */   {
/* 235 */     return getDelegate().isInInvocation();
/*     */   }
/*     */ 
/*     */   public void setInInvocation(boolean inInvocation)
/*     */   {
/* 241 */     getDelegate().setInInvocation(inInvocation);
/*     */   }
/*     */ 
/*     */   public Object getId()
/*     */   {
/* 247 */     return getDelegate().getId();
/*     */   }
/*     */ 
/*     */   public boolean isTxSynchronized()
/*     */   {
/* 260 */     return getDelegate().isTxSynchronized();
/*     */   }
/*     */ 
/*     */   public void setTxSynchronized(boolean txSynchronized)
/*     */   {
/* 266 */     getDelegate().setTxSynchronized(txSynchronized);
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/* 272 */     getDelegate().remove();
/*     */   }
/*     */ 
/*     */   public SessionContainer getContainer()
/*     */   {
/* 284 */     return getDelegate().getContainer();
/*     */   }
/*     */ 
/*     */   public Object getInstance()
/*     */   {
/* 290 */     return getDelegate().getInstance();
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 296 */     return getDelegate().getMetaData();
/*     */   }
/*     */ 
/*     */   public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos)
/*     */   {
/* 302 */     return getDelegate().getInterceptorInstances(interceptorInfos);
/*     */   }
/*     */ 
/*     */   public void extractBeanAndInterceptors()
/*     */   {
/* 308 */     getDelegate().extractBeanAndInterceptors();
/*     */   }
/*     */ 
/*     */   public void initialiseInterceptorInstances()
/*     */   {
/* 314 */     getDelegate().initialiseInterceptorInstances();
/*     */   }
/*     */ 
/*     */   public EJBContext getEJBContext()
/*     */   {
/* 320 */     return getDelegate().getEJBContext();
/*     */   }
/*     */ 
/*     */   public void prePassivate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postActivate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void passivateAfterReplication()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void activateAfterReplication()
/*     */   {
/*     */   }
/*     */ 
/*     */   public boolean getCanPassivate()
/*     */   {
/* 368 */     if (this.delegate == null)
/*     */     {
/* 372 */       return true;
/*     */     }
/*     */ 
/* 377 */     return !isInUse();
/*     */   }
/*     */ 
/*     */   public boolean getCanRemoveFromCache()
/*     */   {
/* 383 */     return getDelegate().getCanRemoveFromCache();
/*     */   }
/*     */ 
/*     */   public boolean getReplicationIsPassivation()
/*     */   {
/* 389 */     return getDelegate().getReplicationIsPassivation();
/*     */   }
/*     */ 
/*     */   public void setReplicationIsPassivation(boolean replicationIsPassivation)
/*     */   {
/* 395 */     getDelegate().setReplicationIsPassivation(replicationIsPassivation);
/*     */   }
/*     */ 
/*     */   public void preReplicate()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void postReplicate()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.stateful.ProxiedStatefulBeanContext
 * JD-Core Version:    0.6.0
 */