/*     */ package org.jboss.ejb3.security;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.CodeSource;
/*     */ import java.security.Policy;
/*     */ import java.security.Principal;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.HashMap;
/*     */ import java.util.Set;
/*     */ import javax.annotation.security.DeclareRoles;
/*     */ import javax.annotation.security.DenyAll;
/*     */ import javax.annotation.security.PermitAll;
/*     */ import javax.annotation.security.RolesAllowed;
/*     */ import javax.ejb.EJBAccessException;
/*     */ import javax.security.auth.Subject;
/*     */ import javax.security.jacc.EJBMethodPermission;
/*     */ import javax.security.jacc.EJBRoleRefPermission;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import javax.security.jacc.PolicyContextException;
/*     */ import org.jboss.aop.metadata.SimpleClassMetaDataBinding;
/*     */ import org.jboss.aop.metadata.SimpleClassMetaDataLoader;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.annotation.SecurityDomain;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.RealmMapping;
/*     */ import org.jboss.security.RunAsIdentity;
/*     */ 
/*     */ public class JaccHelper
/*     */ {
/*  63 */   static Logger log = Logger.getLogger(JaccHelper.class);
/*     */ 
/*     */   public static PolicyConfiguration initialiseJacc(String contextID)
/*     */     throws Exception
/*     */   {
/*  71 */     log.trace("Initialising JACC Context for deployment: " + contextID);
/*  72 */     PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
/*  73 */     boolean removeExistingContext = true;
/*  74 */     PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, removeExistingContext);
/*     */ 
/*  96 */     return pc;
/*     */   }
/*     */ 
/*     */   public static void putJaccInService(PolicyConfiguration pc, DeploymentUnit di)
/*     */     throws Exception
/*     */   {
/* 102 */     DeploymentUnit parentUnit = di.getParent();
/* 103 */     if (parentUnit != null)
/*     */     {
/* 105 */       String parentContextId = parentUnit.getSimpleName();
/* 106 */       PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 107 */       PolicyConfiguration parentpc = pcFactory.getPolicyConfiguration(parentContextId, false);
/* 108 */       if (parentpc != null)
/*     */       {
/* 110 */         parentpc.linkConfiguration(pc);
/* 111 */         pc.commit();
/* 112 */         log.trace("JACC Policy Configuration for deployment unit has been linked with parent");
/* 113 */         return;
/*     */       }
/*     */     }
/* 116 */     pc.commit();
/* 117 */     log.trace("JACC Policy Configuration for deployment unit has been put into service");
/*     */   }
/*     */ 
/*     */   public static void putJaccInService(PolicyConfiguration pc, DeploymentInfo di) throws Exception
/*     */   {
/* 122 */     di.context.put("javax.security.jacc.PolicyConfiguration", pc);
/*     */ 
/* 125 */     DeploymentInfo current = di;
/* 126 */     while (current.parent != null)
/*     */     {
/* 128 */       current = current.parent;
/*     */     }
/*     */ 
/* 131 */     PolicyConfiguration parentPC = (PolicyConfiguration)current.context.get("javax.security.jacc.PolicyConfiguration");
/*     */ 
/* 134 */     if ((parentPC != null) && (parentPC != pc))
/*     */     {
/* 136 */       parentPC.linkConfiguration(pc);
/*     */     }
/*     */ 
/* 139 */     pc.commit();
/* 140 */     log.trace("JACC Policy Configuration for deployment has been put in service");
/*     */   }
/*     */ 
/*     */   public static void unregisterJacc(String contextID) throws Exception
/*     */   {
/* 145 */     PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 146 */     PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
/* 147 */     pc.delete();
/*     */   }
/*     */ 
/*     */   public static void configureContainer(String jaccContextId, EJBContainer container)
/*     */   {
/*     */     try
/*     */     {
/* 155 */       addJaccContextToContainer(jaccContextId, container);
/* 156 */       PolicyConfigurationFactory pcFactory = Ejb3PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 157 */       PolicyConfiguration pc = pcFactory.getPolicyConfiguration(jaccContextId, false);
/*     */ 
/* 159 */       addPermissions(container, pc);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 163 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addPermissions(EJBContainer container, PolicyConfiguration pc)
/*     */   {
/* 169 */     SecurityDomain sd = (SecurityDomain)container.resolveAnnotation(SecurityDomain.class);
/*     */ 
/* 171 */     PermitAll beanUnchecked = (PermitAll)container.resolveAnnotation(PermitAll.class);
/* 172 */     RolesAllowed beanPermissions = (RolesAllowed)container.resolveAnnotation(RolesAllowed.class);
/*     */ 
/* 174 */     DeclareRoles beanDeclareRolesPerms = (DeclareRoles)container.resolveAnnotation(DeclareRoles.class);
/*     */ 
/* 176 */     if ((beanUnchecked != null) && (beanPermissions != null))
/*     */     {
/* 178 */       throw new RuntimeException("Cannot annotate a bean with both @Unchecked and @MethodPermissions");
/*     */     }
/*     */ 
/* 181 */     String ejbName = container.getEjbName();
/*     */ 
/* 184 */     if (beanDeclareRolesPerms != null)
/*     */     {
/* 186 */       String[] rolerefs = beanDeclareRolesPerms.value();
/* 187 */       int len = rolerefs != null ? rolerefs.length : 0;
/* 188 */       for (int i = 0; i < len; i++)
/*     */       {
/*     */         try
/*     */         {
/* 192 */           pc.addToRole(rolerefs[i], new EJBRoleRefPermission(ejbName, rolerefs[i]));
/*     */         }
/*     */         catch (PolicyContextException e)
/*     */         {
/* 196 */           throw new RuntimeException(e);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 203 */     for (Method m : container.getBeanClass().getMethods())
/*     */     {
/* 205 */       EJBMethodPermission permission = new EJBMethodPermission(ejbName, null, m);
/* 206 */       log.trace("Creating permission: " + permission);
/*     */ 
/* 208 */       PermitAll unchecked = (PermitAll)container.resolveAnnotation(m, PermitAll.class);
/* 209 */       RolesAllowed permissions = (RolesAllowed)container.resolveAnnotation(m, RolesAllowed.class);
/* 210 */       DenyAll exclude = (DenyAll)container.resolveAnnotation(m, DenyAll.class);
/*     */ 
/* 212 */       int annotationCount = getAnnotationCount(unchecked, permissions, exclude);
/*     */ 
/* 214 */       if ((annotationCount == 0) && (beanPermissions == null) && (beanUnchecked == null))
/*     */       {
/*     */         try
/*     */         {
/* 220 */           pc.addToUncheckedPolicy(permission);
/*     */         }
/*     */         catch (PolicyContextException e)
/*     */         {
/* 224 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/* 227 */       else if (annotationCount > 1)
/*     */       {
/* 229 */         throw new RuntimeException("You can only use one of @PermitAll, @DenyAll or @RolesAllowed per method");
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 235 */         if (unchecked != null)
/*     */         {
/* 237 */           pc.addToUncheckedPolicy(permission);
/* 238 */           log.trace("Adding permission to unchecked policy");
/*     */         }
/* 241 */         else if (permissions != null)
/*     */         {
/* 243 */           addToRole(pc, permission, permissions);
/*     */         }
/* 246 */         else if (exclude != null)
/*     */         {
/* 248 */           pc.addToExcludedPolicy(permission);
/* 249 */           log.trace("Adding permission to excluded policy");
/*     */         }
/* 253 */         else if (beanUnchecked != null)
/*     */         {
/* 255 */           pc.addToUncheckedPolicy(permission);
/* 256 */           log.trace("Adding permission to unchecked policy");
/*     */         }
/* 259 */         else if (beanPermissions != null)
/*     */         {
/* 261 */           addToRole(pc, permission, beanPermissions);
/*     */         }
/*     */         else
/*     */         {
/* 266 */           pc.addToUncheckedPolicy(permission);
/* 267 */           log.trace("Adding permission to unchecked policy");
/*     */         }
/*     */       }
/*     */       catch (PolicyContextException e) {
/* 271 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static int getAnnotationCount(PermitAll u, RolesAllowed mp, DenyAll e)
/*     */   {
/* 278 */     int annotations = 0;
/* 279 */     if (u != null) annotations++;
/* 280 */     if (mp != null) annotations++;
/* 281 */     if (e != null) annotations++;
/*     */ 
/* 283 */     return annotations;
/*     */   }
/*     */ 
/*     */   private static void addToRole(PolicyConfiguration pc, EJBMethodPermission p, RolesAllowed mp) throws PolicyContextException
/*     */   {
/* 288 */     String[] roles = mp.value();
/* 289 */     for (int i = 0; i < roles.length; i++)
/*     */     {
/* 291 */       pc.addToRole(roles[i], p);
/* 292 */       log.trace("Adding permission to role: " + roles[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void addJaccContextToContainer(String jaccContextId, EJBContainer container)
/*     */   {
/* 298 */     SimpleClassMetaDataLoader loader = SimpleClassMetaDataLoader.singleton;
/* 299 */     String name = container.getBeanClassName();
/* 300 */     SimpleClassMetaDataBinding jaccCtx = new SimpleClassMetaDataBinding(loader, name, "JACC", container.getBeanClassName());
/*     */ 
/* 303 */     jaccCtx.addDefaultMetaData("JACC", "ctx", jaccContextId);
/*     */ 
/* 306 */     container.addClassMetaData(jaccCtx);
/*     */   }
/*     */ 
/*     */   public static void checkPermission(CodeSource ejbCS, EJBMethodPermission methodPerm, RealmMapping realmMapping)
/*     */     throws EJBAccessException
/*     */   {
/*     */     try
/*     */     {
/* 315 */       Policy policy = Policy.getPolicy();
/*     */ 
/* 317 */       Subject caller = SecurityActions.getContextSubject();
/*     */ 
/* 319 */       RunAsIdentity rai = SecurityActions.peekRunAsIdentity();
/*     */ 
/* 321 */       Principal[] principals = null;
/* 322 */       if (rai != null)
/*     */       {
/* 324 */         Set runAsRoles = rai.getRunAsRoles();
/* 325 */         principals = new Principal[runAsRoles.size()];
/* 326 */         runAsRoles.toArray(principals);
/*     */       }
/*     */       else
/*     */       {
/* 338 */         Principal callerP = SecurityActions.getCallerPrincipal();
/* 339 */         Set principalSet = realmMapping.getUserRoles(callerP);
/* 340 */         if (principalSet == null)
/*     */         {
/* 342 */           principals = new Principal[0];
/*     */         }
/*     */         else
/*     */         {
/* 346 */           principals = new Principal[principalSet.size()];
/* 347 */           principalSet.toArray(principals);
/*     */         }
/*     */       }
/*     */ 
/* 351 */       ProtectionDomain pd = new ProtectionDomain(ejbCS, null, null, principals);
/* 352 */       if (!policy.implies(pd, methodPerm))
/*     */       {
/* 354 */         String msg = "Denied: " + methodPerm + ", caller=" + caller;
/*     */ 
/* 356 */         EJBAccessException e = new EJBAccessException(msg);
/* 357 */         throw e;
/*     */       }
/*     */     }
/*     */     catch (PolicyContextException e)
/*     */     {
/* 362 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.JaccHelper
 * JD-Core Version:    0.6.0
 */