/*    */ package org.jboss.ejb3.security;
/*    */ 
/*    */ import java.security.CodeSource;
/*    */ import java.security.ProtectionDomain;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.ejb3.EJBContainer;
/*    */ import org.jboss.security.RealmMapping;
/*    */ 
/*    */ public class JaccAuthorizationInterceptorFactory extends PerClassAspectFactoryAdaptor
/*    */   implements AspectFactory
/*    */ {
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/*    */     try
/*    */     {
/* 46 */       String contextID = (String)advisor.getDefaultMetaData().getMetaData("JACC", "ctx");
/*    */ 
/* 48 */       CodeSource ejbCS = advisor.getClazz().getProtectionDomain().getCodeSource();
/*    */ 
/* 50 */       String ejbName = ((EJBContainer)advisor).getEjbName();
/* 51 */       JaccAuthorizationInterceptor jai = new JaccAuthorizationInterceptor(ejbName, ejbCS);
/* 52 */       jai.setRealmMapping(getSecurityManager(advisor));
/* 53 */       return jai;
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 57 */     throw new RuntimeException(e);
/*    */   }
/*    */ 
/*    */   protected RealmMapping getSecurityManager(Advisor advisor)
/*    */   {
/* 63 */     Container container = (Container)advisor;
/* 64 */     return (RealmMapping)container.getSecurityManager(RealmMapping.class);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.security.JaccAuthorizationInterceptorFactory
 * JD-Core Version:    0.6.0
 */