/*     */ package org.jboss.ejb3.remoting;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.InvocationResponse;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.serial.io.MarshalledObjectForLocalCalls;
/*     */ 
/*     */ public class IsLocalInterceptor
/*     */   implements Interceptor, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 337700910587744646L;
/*  50 */   private static final Logger log = Logger.getLogger(IsLocalInterceptor.class);
/*     */   public static final String GUID = "GUID";
/*     */   public static final String IS_LOCAL = "IS_LOCAL";
/*     */   public static final String IS_LOCAL_EXCEPTION = "IS_LOCAL_EXCEPTION";
/*  57 */   private static final long stamp = System.currentTimeMillis();
/*  58 */   private long marshalledStamp = stamp;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  62 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  67 */     if (isLocal())
/*     */     {
/*  69 */       String guid = (String)invocation.getMetaData("IS_LOCAL", "GUID");
/*  70 */       Container container = Ejb3Registry.getContainer(guid);
/*     */ 
/*  72 */       return invokeLocal(invocation, container);
/*     */     }
/*  74 */     return invocation.invokeNext();
/*     */   }
/*     */ 
/*     */   protected Object invokeLocal(Invocation invocation, Container container) throws Throwable
/*     */   {
/*  79 */     Invocation copy = (Invocation)new MarshalledObjectForLocalCalls(invocation).get();
/*  80 */     copy.getMetaData().addMetaData("IS_LOCAL", "IS_LOCAL", Boolean.TRUE);
/*  81 */     InvocationResponse response = ((Advisor)container).dynamicInvoke(null, copy);
/*  82 */     Map contextInfo = response.getContextInfo();
/*  83 */     if (contextInfo != null)
/*     */     {
/*  85 */       MarshalledObjectForLocalCalls wrappedException = (MarshalledObjectForLocalCalls)response.getContextInfo().get("IS_LOCAL_EXCEPTION");
/*  86 */       if (wrappedException != null)
/*     */       {
/*  88 */         throw ((Throwable)wrappedException.get());
/*     */       }
/*     */     }
/*  91 */     invocation.setResponseContextInfo(response.getContextInfo());
/*  92 */     MarshalledObjectForLocalCalls wrapped = (MarshalledObjectForLocalCalls)response.getResponse();
/*  93 */     Object rtn = null;
/*  94 */     if (wrapped != null)
/*     */     {
/*  96 */       rtn = wrapped.get();
/*     */     }
/*  98 */     return rtn;
/*     */   }
/*     */ 
/*     */   protected boolean isLocal()
/*     */   {
/* 103 */     return stamp == this.marshalledStamp;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.remoting.IsLocalInterceptor
 * JD-Core Version:    0.6.0
 */