/*     */ package org.jboss.ejb3.pool;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
/*     */ import java.util.LinkedList;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class StrictMaxPool extends AbstractPool
/*     */ {
/*     */   public static final int DEFAULT_MAX_SIZE = 30;
/*     */   public static final long DEFAULT_TIMEOUT = 9223372036854775807L;
/*     */   private FIFOSemaphore strictMaxSize;
/*  50 */   private int inUse = 0;
/*     */   private long strictTimeout;
/*  59 */   protected LinkedList pool = new LinkedList();
/*     */ 
/*  63 */   protected int maxSize = 30;
/*     */ 
/*  65 */   Logger log = Logger.getLogger(StrictMaxPool.class);
/*     */ 
/*     */   public void initialize(Container container, int maxSize, long timeout)
/*     */   {
/*  79 */     super.initialize(container, maxSize, timeout);
/*  80 */     this.maxSize = maxSize;
/*  81 */     this.strictMaxSize = new FIFOSemaphore(maxSize);
/*  82 */     this.strictTimeout = timeout;
/*     */   }
/*     */ 
/*     */   public int getCurrentSize()
/*     */   {
/*  87 */     return getCreateCount() - getRemoveCount();
/*     */   }
/*     */ 
/*     */   public int getAvailableCount()
/*     */   {
/*  92 */     return this.maxSize - this.inUse;
/*     */   }
/*     */ 
/*     */   public int getMaxSize()
/*     */   {
/*  97 */     return this.maxSize;
/*     */   }
/*     */ 
/*     */   public void setMaxSize(int maxSize)
/*     */   {
/* 102 */     this.maxSize = maxSize;
/* 103 */     this.strictMaxSize = new FIFOSemaphore(maxSize);
/*     */   }
/*     */ 
/*     */   public BeanContext get()
/*     */   {
/* 114 */     boolean trace = this.log.isTraceEnabled();
/* 115 */     if (trace) {
/* 116 */       this.log.trace("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 121 */       boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
/* 122 */       if (trace)
/* 123 */         this.log.trace("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits());
/* 124 */       if (!acquired)
/* 125 */         throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/* 129 */       throw new EJBException("Pool strictMaxSize semaphore was interrupted");
/*     */     }
/*     */ 
/* 132 */     synchronized (this.pool)
/*     */     {
/* 134 */       if (!this.pool.isEmpty())
/*     */       {
/* 136 */         BeanContext bean = (BeanContext)this.pool.removeFirst();
/* 137 */         this.inUse += 1;
/* 138 */         return bean;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 143 */     this.inUse += 1;
/* 144 */     return create();
/*     */   }
/*     */ 
/*     */   public BeanContext get(Class[] initTypes, Object[] initValues)
/*     */   {
/* 150 */     boolean trace = this.log.isTraceEnabled();
/* 151 */     if (trace) {
/* 152 */       this.log.trace("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 157 */       boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
/* 158 */       if (trace)
/* 159 */         this.log.trace("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits());
/* 160 */       if (!acquired)
/* 161 */         throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/* 165 */       throw new EJBException("Pool strictMaxSize semaphore was interrupted");
/*     */     }
/*     */ 
/* 168 */     synchronized (this.pool)
/*     */     {
/* 170 */       if (!this.pool.isEmpty())
/*     */       {
/* 172 */         BeanContext bean = (BeanContext)this.pool.removeFirst();
/* 173 */         this.inUse += 1;
/* 174 */         return bean;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 179 */     this.inUse += 1;
/* 180 */     return create(initTypes, initValues);
/*     */   }
/*     */ 
/*     */   public void release(BeanContext ctx)
/*     */   {
/* 194 */     if (this.log.isTraceEnabled())
/*     */     {
/* 196 */       String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this + "#" + this.container.getBeanClass();
/*     */ 
/* 198 */       this.log.trace(msg);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 204 */       boolean removeIt = false;
/* 205 */       synchronized (this.pool)
/*     */       {
/* 207 */         if (this.pool.size() < this.maxSize)
/*     */         {
/* 209 */           this.pool.addFirst(ctx);
/*     */         }
/*     */         else
/*     */         {
/* 213 */           removeIt = true;
/*     */         }
/*     */       }
/* 216 */       if (removeIt) remove(ctx);
/*     */ 
/* 218 */       this.strictMaxSize.release();
/* 219 */       this.inUse -= 1;
/*     */     }
/*     */     catch (Exception ignored)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 229 */     freeAll();
/*     */   }
/*     */ 
/*     */   public void discard(BeanContext ctx)
/*     */   {
/* 234 */     if (this.log.isTraceEnabled())
/*     */     {
/* 236 */       String msg = "Discard instance:" + this + "#" + ctx + "#" + this.container.getBeanClass();
/*     */ 
/* 238 */       this.log.trace(msg);
/*     */     }
/*     */ 
/* 242 */     this.strictMaxSize.release();
/* 243 */     this.inUse -= 1;
/*     */ 
/* 246 */     super.discard(ctx);
/*     */   }
/*     */ 
/*     */   private void freeAll()
/*     */   {
/* 267 */     LinkedList clone = (LinkedList)this.pool.clone();
/* 268 */     for (int i = 0; i < clone.size(); i++)
/*     */     {
/* 270 */       BeanContext bc = (BeanContext)clone.get(i);
/*     */ 
/* 272 */       discard(bc);
/*     */     }
/* 274 */     this.pool.clear();
/* 275 */     this.inUse = 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.pool.StrictMaxPool
 * JD-Core Version:    0.6.0
 */