/*     */ package org.jboss.ejb3.pool;
/*     */ 
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractPool
/*     */   implements Pool
/*     */ {
/*     */   private static final Logger log;
/*     */   protected Injector[] injectors;
/*     */   protected Container container;
/*  43 */   protected int createCount = 0;
/*  44 */   protected int removeCount = 0;
/*     */ 
/*     */   public int getCreateCount()
/*     */   {
/*  53 */     return this.createCount;
/*     */   }
/*     */ 
/*     */   public int getRemoveCount()
/*     */   {
/*  58 */     return this.removeCount;
/*     */   }
/*     */ 
/*     */   public void initialize(Container container, int maxSize, long timeout)
/*     */   {
/*  63 */     assert (container != null) : "container is null";
/*     */ 
/*  65 */     this.container = container;
/*     */   }
/*     */   public abstract void setMaxSize(int paramInt);
/*     */ 
/*     */   @Deprecated
/*     */   protected BeanContext<?> create() {
/*  73 */     return create(null, null);
/*     */   }
/*     */ 
/*     */   protected BeanContext<?> create(Class[] initTypes, Object[] initValues)
/*     */   {
/*  79 */     BeanContext ctx = createBeanContext();
/*     */ 
/*  93 */     this.container.pushContext(ctx);
/*     */     try
/*     */     {
/*  96 */       if (this.injectors != null)
/*     */       {
/*  98 */         for (int i = 0; i < this.injectors.length; i++)
/*     */         {
/* 100 */           this.injectors[i].inject(ctx);
/*     */         }
/*     */       }
/*     */ 
/* 104 */       ctx.initialiseInterceptorInstances();
/*     */     }
/*     */     finally
/*     */     {
/* 109 */       this.container.popContext();
/*     */     }
/*     */ 
/* 118 */     this.container.invokePostConstruct(ctx, initValues);
/*     */ 
/* 121 */     this.container.invokeInit(ctx.getInstance(), initTypes, initValues);
/*     */ 
/* 123 */     this.createCount += 1;
/*     */ 
/* 125 */     return ctx;
/*     */   }
/*     */ 
/*     */   private BeanContext createBeanContext()
/*     */   {
/* 130 */     return this.container.createBeanContext();
/*     */   }
/*     */ 
/*     */   public void remove(BeanContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 137 */       this.container.invokePreDestroy(ctx);
/*     */     }
/*     */     finally
/*     */     {
/* 141 */       ctx.remove();
/* 142 */       this.removeCount += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void discard(BeanContext<?> ctx)
/*     */   {
/* 148 */     remove(ctx);
/*     */   }
/*     */ 
/*     */   public void setInjectors(Injector[] injectors)
/*     */   {
/* 153 */     this.injectors = injectors;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  39 */     log = Logger.getLogger(AbstractPool.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.pool.AbstractPool
 * JD-Core Version:    0.6.0
 */