/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class SessionEnterpriseBean extends EnterpriseBean
/*     */ {
/*  38 */   private static final Logger log = Logger.getLogger(SessionEnterpriseBean.class);
/*     */   public static final String STATELESS = "Stateless";
/*     */   public static final String STATEFUL = "Stateful";
/*  45 */   private String sessionType = "Stateless";
/*     */   private Method aroundInvoke;
/*     */   private Method postConstruct;
/*     */   private Method postActivate;
/*     */   private Method preDestroy;
/*     */   private Method prePassivate;
/*  51 */   private List<RemoveMethod> removeMethods = new ArrayList();
/*  52 */   private List<InitMethod> initMethods = new ArrayList();
/*     */ 
/*  54 */   private String clustered = null;
/*  55 */   private ClusterConfig clusterConfig = null;
/*  56 */   private CacheConfig cacheConfig = null;
/*     */ 
/*  58 */   private String concurrent = null;
/*     */ 
/*     */   public CacheConfig getCacheConfig()
/*     */   {
/*  62 */     return this.cacheConfig;
/*     */   }
/*     */ 
/*     */   public void setCacheConfig(CacheConfig cacheConfig)
/*     */   {
/*  67 */     this.cacheConfig = cacheConfig;
/*     */   }
/*     */ 
/*     */   public String getConcurrent()
/*     */   {
/*  72 */     return this.concurrent;
/*     */   }
/*     */ 
/*     */   public void setConcurrent(String concurrent)
/*     */   {
/*  77 */     this.concurrent = concurrent;
/*     */   }
/*     */ 
/*     */   public String getClustered()
/*     */   {
/*  82 */     return this.clustered;
/*     */   }
/*     */ 
/*     */   public void setClustered(String clustered)
/*     */   {
/*  87 */     this.clustered = clustered;
/*     */   }
/*     */ 
/*     */   public ClusterConfig getClusterConfig()
/*     */   {
/*  92 */     return this.clusterConfig;
/*     */   }
/*     */ 
/*     */   public void setClusterConfig(ClusterConfig clusterConfig)
/*     */   {
/*  97 */     this.clusterConfig = clusterConfig;
/*     */   }
/*     */ 
/*     */   public List<RemoveMethod> getRemoveMethods()
/*     */   {
/* 102 */     return this.removeMethods;
/*     */   }
/*     */ 
/*     */   public void addRemoveMethod(RemoveMethod method)
/*     */   {
/* 107 */     this.removeMethods.add(method);
/*     */   }
/*     */ 
/*     */   public List<InitMethod> getInitMethods()
/*     */   {
/* 112 */     return this.initMethods;
/*     */   }
/*     */ 
/*     */   public void addInitMethod(InitMethod method)
/*     */   {
/* 117 */     this.initMethods.add(method);
/*     */   }
/*     */ 
/*     */   public boolean isStateless()
/*     */   {
/* 122 */     return this.sessionType.equals("Stateless");
/*     */   }
/*     */ 
/*     */   public boolean isStateful()
/*     */   {
/* 127 */     return this.sessionType.equals("Stateful");
/*     */   }
/*     */ 
/*     */   public String getSessionType()
/*     */   {
/* 132 */     return this.sessionType;
/*     */   }
/*     */ 
/*     */   public void setSessionType(String sessionType)
/*     */   {
/* 137 */     this.sessionType = sessionType;
/*     */   }
/*     */ 
/*     */   public Method getAroundInvoke()
/*     */   {
/* 142 */     return this.aroundInvoke;
/*     */   }
/*     */ 
/*     */   public void setAroundInvoke(Method aroundInvoke)
/*     */   {
/* 147 */     this.aroundInvoke = aroundInvoke;
/*     */   }
/*     */ 
/*     */   public Method getPostActivate()
/*     */   {
/* 152 */     if (this.sessionType.equals("Stateless"))
/* 153 */       return null;
/* 154 */     return this.postActivate;
/*     */   }
/*     */ 
/*     */   public void setPostActivate(Method postActivate)
/*     */   {
/* 159 */     this.postActivate = postActivate;
/*     */   }
/*     */ 
/*     */   public Method getPostConstruct()
/*     */   {
/* 164 */     return this.postConstruct;
/*     */   }
/*     */ 
/*     */   public void setPostConstruct(Method postConstruct)
/*     */   {
/* 169 */     this.postConstruct = postConstruct;
/*     */   }
/*     */ 
/*     */   public Method getPreDestroy()
/*     */   {
/* 174 */     return this.preDestroy;
/*     */   }
/*     */ 
/*     */   public void setPreDestroy(Method preDestroy)
/*     */   {
/* 179 */     this.preDestroy = preDestroy;
/*     */   }
/*     */ 
/*     */   public Method getPrePassivate()
/*     */   {
/* 184 */     if (this.sessionType.equals("Stateless"))
/* 185 */       return null;
/* 186 */     return this.prePassivate;
/*     */   }
/*     */ 
/*     */   public void setPrePassivate(Method prePassivate)
/*     */   {
/* 191 */     this.prePassivate = prePassivate;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 196 */     StringBuffer sb = new StringBuffer(100);
/* 197 */     sb.append('[');
/* 198 */     sb.append(super.toString());
/* 199 */     sb.append(",");
/* 200 */     sb.append("sessionType=").append(this.sessionType);
/* 201 */     sb.append(']');
/* 202 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.SessionEnterpriseBean
 * JD-Core Version:    0.6.0
 */