/*      */ package org.jboss.ejb3.metamodel;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.net.URL;
/*      */ import java.util.List;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.SecurityRoleMetaData;
/*      */ import org.jboss.metamodel.descriptor.DDObjectFactory;
/*      */ import org.jboss.metamodel.descriptor.EjbLocalRef;
/*      */ import org.jboss.metamodel.descriptor.EjbRef;
/*      */ import org.jboss.metamodel.descriptor.InjectionTarget;
/*      */ import org.jboss.metamodel.descriptor.JndiRef;
/*      */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*      */ import org.jboss.metamodel.descriptor.NameValuePair;
/*      */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*      */ import org.jboss.metamodel.descriptor.ResourceRef;
/*      */ import org.jboss.util.StringPropertyReplacer;
/*      */ import org.jboss.util.xml.JBossEntityResolver;
/*      */ import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
/*      */ import org.jboss.xb.binding.JBossXBException;
/*      */ import org.jboss.xb.binding.ObjectModelFactory;
/*      */ import org.jboss.xb.binding.Unmarshaller;
/*      */ import org.jboss.xb.binding.UnmarshallerFactory;
/*      */ import org.jboss.xb.binding.UnmarshallingContext;
/*      */ import org.xml.sax.Attributes;
/*      */ 
/*      */ public class JBossDDObjectFactory extends DDObjectFactory
/*      */ {
/*   57 */   private static final Logger log = Logger.getLogger(JBossDDObjectFactory.class);
/*      */   private EjbJarDD dd;
/*      */   private Class ejbClass;
/*      */ 
/*      */   public static EjbJarDD parse(URL ddResource, EjbJarDD dd)
/*      */     throws JBossXBException, IOException
/*      */   {
/*   64 */     ObjectModelFactory factory = null;
/*   65 */     Unmarshaller unmarshaller = null;
/*      */ 
/*   67 */     if (ddResource != null)
/*      */     {
/*   69 */       log.debug("found jboss.xml " + ddResource);
/*      */ 
/*   71 */       if (dd == null) {
/*   72 */         dd = new EjbJarDD();
/*      */       }
/*   74 */       factory = new JBossDDObjectFactory(dd);
/*   75 */       UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
/*   76 */       unmarshaller = unmarshallerFactory.newUnmarshaller();
/*   77 */       unmarshaller.setEntityResolver(new JBossEntityResolver());
/*   78 */       unmarshaller.setNamespaceAware(true);
/*   79 */       unmarshaller.setSchemaValidation(true);
/*   80 */       unmarshaller.setValidation(true);
/*      */ 
/*   82 */       dd = (EjbJarDD)unmarshaller.unmarshal(ddResource.openStream(), factory, null);
/*      */     }
/*      */ 
/*   85 */     return dd;
/*      */   }
/*      */ 
/*      */   public JBossDDObjectFactory(EjbJarDD dd)
/*      */   {
/*   91 */     this.dd = dd;
/*      */   }
/*      */ 
/*      */   public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*   99 */     return this.dd;
/*      */   }
/*      */ 
/*      */   public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name)
/*      */   {
/*  104 */     return root;
/*      */   }
/*      */ 
/*      */   public Object newChild(EjbJarDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  114 */     Object child = null;
/*      */ 
/*  116 */     if (localName.equals("enterprise-beans"))
/*      */     {
/*  118 */       child = dd.getEnterpriseBeans();
/*  119 */       if (child == null)
/*      */       {
/*  121 */         dd.setEnterpriseBeans(new EnterpriseBeans());
/*  122 */         child = dd.getEnterpriseBeans();
/*      */       }
/*      */     }
/*  125 */     else if (localName.equals("assembly-descriptor"))
/*      */     {
/*  127 */       child = dd.getAssemblyDescriptor();
/*  128 */       if (child == null)
/*      */       {
/*  130 */         dd.setAssemblyDescriptor(new AssemblyDescriptor());
/*  131 */         child = dd.getAssemblyDescriptor();
/*      */       }
/*      */     }
/*  134 */     else if (localName.equals("resource-manager"))
/*      */     {
/*  136 */       child = new ResourceManager();
/*      */     }
/*  138 */     else if (localName.equals("webservices"))
/*      */     {
/*  140 */       child = dd.getWebservices();
/*  141 */       if (child == null)
/*      */       {
/*  143 */         dd.setWebservices(new Webservices());
/*  144 */         child = dd.getWebservices();
/*      */       }
/*      */     }
/*  147 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Consumer consumer, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  155 */     Object child = null;
/*      */ 
/*  157 */     if ((child = newEnvRefGroupChild(localName)) != null) {
/*  158 */       return child;
/*      */     }
/*  160 */     if (localName.equals("current-message"))
/*      */     {
/*  162 */       child = new CurrentMessage();
/*      */     }
/*  164 */     else if (localName.equals("message-properties"))
/*      */     {
/*  166 */       child = new MessageProperties();
/*      */     }
/*  168 */     else if (localName.equals("producer"))
/*      */     {
/*  170 */       child = new Producer(false);
/*      */     }
/*  172 */     else if (localName.equals("local-producer"))
/*      */     {
/*  174 */       child = new Producer(true);
/*      */     }
/*  176 */     else if (localName.equals("annotation"))
/*      */     {
/*  178 */       child = new XmlAnnotation();
/*      */     }
/*  180 */     else if (localName.equals("ignore-dependency"))
/*      */     {
/*  182 */       child = new InjectionTarget();
/*      */     }
/*  184 */     else if (localName.equals("remote-binding"))
/*      */     {
/*  186 */       child = new RemoteBinding();
/*      */     }
/*  188 */     else if (localName.equals("pool-config"))
/*      */     {
/*  190 */       child = new PoolConfig();
/*      */     }
/*      */ 
/*  193 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Service service, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  201 */     Object child = null;
/*      */ 
/*  203 */     if ((child = newEnvRefGroupChild(localName)) != null) {
/*  204 */       return child;
/*      */     }
/*  206 */     if (localName.equals("ignore-dependency"))
/*      */     {
/*  208 */       child = new InjectionTarget();
/*      */     }
/*  210 */     else if (localName.equals("annotation"))
/*      */     {
/*  212 */       child = new XmlAnnotation();
/*      */     }
/*  214 */     else if (localName.equals("remote-binding"))
/*      */     {
/*  216 */       child = new RemoteBinding();
/*      */     }
/*      */ 
/*  219 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(Webservices webservices, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  227 */     Object child = null;
/*      */ 
/*  229 */     if (localName.equals("webservice-description"))
/*      */     {
/*  231 */       child = new WebserviceDescription();
/*      */     }
/*      */ 
/*  234 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(CurrentMessage message, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  242 */     Object child = null;
/*      */ 
/*  244 */     if (localName.equals("method"))
/*      */     {
/*  246 */       child = new Method();
/*      */     }
/*      */ 
/*  249 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(MessageProperties properties, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  257 */     Object child = null;
/*      */ 
/*  259 */     if (localName.equals("method"))
/*      */     {
/*  261 */       child = new Method();
/*      */     }
/*      */ 
/*  264 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(MethodAttributes attributes, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  272 */     Object child = null;
/*      */ 
/*  274 */     if (localName.equals("method"))
/*      */     {
/*  276 */       child = new Method();
/*      */     }
/*      */ 
/*  279 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(AssemblyDescriptor descriptor, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  287 */     Object child = null;
/*      */ 
/*  289 */     if (localName.equals("message-destination"))
/*      */     {
/*  291 */       child = new MessageDestination();
/*      */     }
/*  293 */     if (localName.equals("security-role"))
/*      */     {
/*  295 */       child = new SecurityRoleMetaData("dummy_to_be_replaced_in_setValue");
/*      */     }
/*      */ 
/*  298 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(EnterpriseBeans ejbs, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  306 */     Object child = null;
/*      */ 
/*  308 */     if ((child = newEnvRefGroupChild(localName)) != null)
/*      */     {
/*  310 */       return child;
/*      */     }
/*      */ 
/*  313 */     if (localName.equals("session"))
/*      */     {
/*  315 */       this.ejbClass = SessionEnterpriseBean.class;
/*  316 */       child = ejbs;
/*      */     }
/*  318 */     else if (localName.equals("message-driven"))
/*      */     {
/*  320 */       this.ejbClass = MessageDrivenBean.class;
/*  321 */       child = ejbs;
/*      */     }
/*  323 */     else if (localName.equals("ejb"))
/*      */     {
/*  325 */       this.ejbClass = GenericBean.class;
/*  326 */       child = ejbs;
/*      */     }
/*  328 */     else if (localName.equals("service"))
/*      */     {
/*  330 */       child = new Service();
/*      */     }
/*  332 */     else if (localName.equals("consumer"))
/*      */     {
/*  334 */       child = new Consumer();
/*      */     }
/*  336 */     else if (localName.equals("method-attributes"))
/*      */     {
/*  338 */       child = new MethodAttributes();
/*      */     }
/*  340 */     else if (localName.equals("annotation"))
/*      */     {
/*  342 */       child = new XmlAnnotation();
/*      */     }
/*  344 */     else if (localName.equals("ignore-dependency"))
/*      */     {
/*  346 */       child = new InjectionTarget();
/*      */     }
/*  348 */     else if (localName.equals("cluster-config"))
/*      */     {
/*  350 */       child = new ClusterConfig();
/*      */     }
/*  352 */     else if (localName.equals("remote-binding"))
/*      */     {
/*  354 */       child = new RemoteBinding();
/*      */     }
/*  356 */     else if (localName.equals("cache-config"))
/*      */     {
/*  358 */       child = new CacheConfig();
/*      */     }
/*  360 */     else if (localName.equals("pool-config"))
/*      */     {
/*  362 */       child = new PoolConfig();
/*      */     }
/*  364 */     else if (localName.equals("default-activation-config"))
/*      */     {
/*  366 */       child = new ActivationConfig();
/*      */     }
/*  368 */     else if (localName.equals("port-component"))
/*      */     {
/*  370 */       child = new Ejb3PortComponent();
/*      */     }
/*  372 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(ActivationConfig parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  377 */     Object child = null;
/*      */ 
/*  379 */     if (localName.equals("default-activation-config-property"))
/*      */     {
/*  381 */       child = new NameValuePair();
/*      */     }
/*      */ 
/*  384 */     return child;
/*      */   }
/*      */ 
/*      */   public Object newChild(XmlAnnotation parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs)
/*      */   {
/*  389 */     Object child = null;
/*      */ 
/*  391 */     if (localName.equals("injection-target"))
/*      */     {
/*  393 */       child = new InjectionTarget();
/*      */     }
/*  395 */     else if (localName.equals("property"))
/*      */     {
/*  397 */       child = new NameValuePair();
/*      */     }
/*      */ 
/*  400 */     return child;
/*      */   }
/*      */ 
/*      */   public void addChild(SessionEnterpriseBean parent, Ejb3PortComponent portComp, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  405 */     parent.setPortComponent(portComp);
/*      */   }
/*      */ 
/*      */   public void addChild(XmlAnnotation parent, NameValuePair property, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  410 */     parent.addProperty(property);
/*      */   }
/*      */ 
/*      */   public void addChild(XmlAnnotation parent, InjectionTarget injectionTarget, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  415 */     parent.setInjectionTarget(injectionTarget);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, ActivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  420 */     parent.setDefaultActivationConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(ActivationConfig parent, NameValuePair property, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  425 */     parent.addActivationConfigProperty(property);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, Producer producer, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  430 */     if (producer.isLocal())
/*  431 */       parent.addLocalProducer(producer);
/*  432 */     else parent.addProducer(producer);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, RemoteBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  437 */     parent.addRemoteBinding(binding);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  442 */     parent.addMessageDestination(destination);
/*      */   }
/*      */ 
/*      */   public void addChild(AssemblyDescriptor parent, SecurityRoleMetaData srm, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  447 */     parent.addSecurityRoleMetaData(srm);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, CacheConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  455 */     parent.setCacheConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, PoolConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  463 */     parent.setPoolConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, MethodAttributes attributes, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  471 */     parent.setMethodAttributes(attributes);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, RemoteBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  476 */     parent.addRemoteBinding(binding);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, InjectionTarget ignoreDependency, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  481 */     parent.addIgnoreDependency(ignoreDependency);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, XmlAnnotation xmlAnnotation, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  486 */     parent.addXmlAnnotation(xmlAnnotation);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, Ejb3PortComponent portComp, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  491 */     parent.addPortComponent(portComp);
/*      */   }
/*      */ 
/*      */   public void addChild(MethodAttributes parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  496 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, CurrentMessage message, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  501 */     parent.setCurrentMessage(message);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, PoolConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  506 */     parent.setPoolConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, MessageProperties message, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  514 */     parent.setMessageProperties(message);
/*      */   }
/*      */ 
/*      */   public void addChild(CurrentMessage parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  522 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(MessageProperties parent, Method method, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  530 */     parent.addMethod(method);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, Service service, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  538 */     parent.addEnterpriseBean(service);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  546 */     parent.addEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, RemoteBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  554 */     parent.addRemoteBinding(binding);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  562 */     parent.addEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  570 */     parent.addResourceRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, JndiRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  578 */     parent.addJndiRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Service parent, ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  586 */     parent.addResourceEnvRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  594 */     parent.addEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  602 */     parent.addEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  610 */     parent.addResourceRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, JndiRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  618 */     parent.addJndiRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(Consumer parent, ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  626 */     parent.addResourceEnvRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, Consumer consumer, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  634 */     parent.addEnterpriseBean(consumer);
/*      */   }
/*      */ 
/*      */   public void addChild(Webservices parent, WebserviceDescription desc, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  642 */     parent.getWebserviceDescriptions().add(desc);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, JndiRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  650 */     parent.addJndiRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, ResourceManager manager, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  658 */     parent.addResourceManager(manager);
/*      */   }
/*      */ 
/*      */   public void addChild(EjbJarDD parent, Webservices webservices, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  666 */     parent.setWebservices(webservices);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, EnterpriseBeans ejbs, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  681 */     parent.updateEjbRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  689 */     parent.updateEjbLocalRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, ClusterConfig config, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  697 */     parent.setClusterConfig(config);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  705 */     parent.updateResourceRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  713 */     parent.updateMessageDestinationRef(ref);
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, ServiceRefMetaData sref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  721 */     String refName = sref.getServiceRefName();
/*  722 */     if (refName == null) {
/*  723 */       throw new IllegalStateException("Invalid service-ref-name: " + refName);
/*      */     }
/*  725 */     ServiceRefMetaData targetRef = parent.getServiceRef(refName);
/*  726 */     if (targetRef == null)
/*      */     {
/*  728 */       log.debug("Cannot find <service-ref> with name: " + refName);
/*  729 */       parent.addServiceRef(sref);
/*      */     }
/*      */     else
/*      */     {
/*  733 */       targetRef.merge(sref);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void addChild(EnterpriseBeans parent, ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName)
/*      */   {
/*  742 */     parent.updateResourceEnvRef(ref);
/*      */   }
/*      */ 
/*      */   public void setValue(XmlAnnotation xmlAnnotation, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  747 */     if (localName.equals("annotation-class"))
/*      */     {
/*  749 */       xmlAnnotation.setAnnotationClass(getValue(localName, value));
/*      */     }
/*  751 */     else if (localName.equals("annotation-implementation-class"))
/*      */     {
/*  753 */       xmlAnnotation.setAnnotationImplementationClass(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(NameValuePair property, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  759 */     if ((localName.equals("activation-config-property-name")) || (localName.equals("message-driven-config-property-name")) || (localName.equals("property-name")))
/*      */     {
/*  761 */       property.setName(getValue(localName, value));
/*      */     }
/*  763 */     else if ((localName.equals("activation-config-property-value")) || (localName.equals("message-driven-config-property-value")) || (localName.equals("property-value")))
/*      */     {
/*  765 */       property.setValue(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(ResourceManager manager, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  771 */     if (localName.equals("res-name"))
/*      */     {
/*  773 */       manager.setResourceName(getValue(localName, value));
/*      */     }
/*  775 */     else if (localName.equals("res-jndi-name"))
/*      */     {
/*  777 */       manager.setResourceJndiName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  783 */     if (localName.equals("message-destination-name"))
/*      */     {
/*  785 */       destination.setMessageDestinationName(getValue(localName, value));
/*      */     }
/*  787 */     else if (localName.equals("jndi-name"))
/*      */     {
/*  789 */       destination.setJndiName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(EnterpriseBeans ejbs, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  795 */     if (localName.equals("ejb-name"))
/*      */     {
/*  797 */       ejbs.setCurrentEjbName(value, this.ejbClass);
/*      */     }
/*  799 */     else if (localName.equals("jndi-name"))
/*      */     {
/*  801 */       ejbs.setJndiName(getValue(localName, value));
/*      */     }
/*  803 */     else if (localName.equals("home-jndi-name"))
/*      */     {
/*  805 */       ejbs.setHomeJndiName(getValue(localName, value));
/*      */     }
/*  807 */     else if (localName.equals("local-jndi-name"))
/*      */     {
/*  809 */       ejbs.setLocalJndiName(getValue(localName, value));
/*      */     }
/*  811 */     else if (localName.equals("local-home-jndi-name"))
/*      */     {
/*  813 */       ejbs.setLocalHomeJndiName(getValue(localName, value));
/*      */     }
/*  815 */     else if (localName.equals("security-domain"))
/*      */     {
/*  817 */       ejbs.setSecurityDomain(getValue(localName, value));
/*      */     }
/*  819 */     else if (localName.equals("depends"))
/*      */     {
/*  821 */       ejbs.addDependency(getValue(localName, value));
/*      */     }
/*  823 */     else if (localName.equals("run-as-principal"))
/*      */     {
/*  825 */       ejbs.setRunAsPrincipal(getValue(localName, value));
/*      */     }
/*  827 */     else if (localName.equals("aop-domain-name"))
/*      */     {
/*  829 */       ejbs.setAopDomainName(getValue(localName, value));
/*      */     }
/*  831 */     else if (localName.equals("resource-adapter-name"))
/*      */     {
/*  833 */       ejbs.setResourceAdapterName(getValue(localName, value));
/*      */     }
/*  835 */     else if (localName.equals("destination-jndi-name"))
/*      */     {
/*  837 */       ejbs.setDestinationJndiName(getValue(localName, value));
/*      */     }
/*  839 */     else if (localName.equals("mdb-user"))
/*      */     {
/*  841 */       ejbs.setMdbUser(getValue(localName, value));
/*      */     }
/*  843 */     else if (localName.equals("mdb-passwd"))
/*      */     {
/*  845 */       ejbs.setMdbPassword(getValue(localName, value));
/*      */     }
/*  847 */     else if (localName.equals("mdb-subscription-id"))
/*      */     {
/*  849 */       ejbs.setMdbSubscriptionId(getValue(localName, value));
/*      */     }
/*  851 */     else if (localName.equals("clustered"))
/*      */     {
/*  853 */       ejbs.setClustered(getValue(localName, value));
/*      */     }
/*  855 */     else if (localName.equals("concurrent"))
/*      */     {
/*  857 */       ejbs.setConcurrent(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Service service, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  866 */     if (localName.equals("ejb-name"))
/*      */     {
/*  868 */       service.setEjbName(getValue(localName, value));
/*      */     }
/*  870 */     if (localName.equals("object-name"))
/*      */     {
/*  872 */       service.setObjectName(getValue(localName, value));
/*      */     }
/*  874 */     else if (localName.equals("ejb-class"))
/*      */     {
/*  876 */       service.setEjbClass(getValue(localName, value));
/*      */     }
/*  878 */     if (localName.equals("xmbean"))
/*      */     {
/*  880 */       service.setXMBean(getValue(localName, value));
/*      */     }
/*  882 */     else if (localName.equals("local"))
/*      */     {
/*  884 */       service.setLocal(getValue(localName, value));
/*      */     }
/*  886 */     else if (localName.equals("remote"))
/*      */     {
/*  888 */       service.setRemote(getValue(localName, value));
/*      */     }
/*  890 */     else if (localName.equals("management"))
/*      */     {
/*  892 */       service.setManagement(getValue(localName, value));
/*      */     }
/*  894 */     else if (localName.equals("jndi-name"))
/*      */     {
/*  896 */       service.setJndiName(getValue(localName, value));
/*      */     }
/*  898 */     else if (localName.equals("local-jndi-name"))
/*      */     {
/*  900 */       service.setLocalJndiName(getValue(localName, value));
/*      */     }
/*  902 */     else if (localName.equals("security-domain"))
/*      */     {
/*  904 */       service.setSecurityDomain(getValue(localName, value));
/*      */     }
/*  906 */     else if (localName.equals("aop-domain-name"))
/*      */     {
/*  908 */       service.setAopDomainName(getValue(localName, value));
/*      */     }
/*  910 */     else if (localName.equals("depends"))
/*      */     {
/*  912 */       service.addDependency(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Consumer consumer, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  921 */     if (localName.equals("message-destination"))
/*      */     {
/*  923 */       consumer.setDestination(getValue(localName, value));
/*      */     }
/*  925 */     else if (localName.equals("message-destination-type"))
/*      */     {
/*  927 */       consumer.setDestinationType(getValue(localName, value));
/*      */     }
/*  929 */     else if (localName.equals("ejb-class"))
/*      */     {
/*  931 */       consumer.setEjbClass(getValue(localName, value));
/*  932 */       consumer.setEjbName(getValue(localName, value));
/*      */     }
/*  934 */     else if (localName.equals("local"))
/*      */     {
/*  936 */       consumer.setLocal(getValue(localName, value));
/*      */     }
/*  938 */     else if (localName.equals("remote"))
/*      */     {
/*  940 */       consumer.setRemote(getValue(localName, value));
/*      */     }
/*  942 */     else if (localName.equals("jndi-name"))
/*      */     {
/*  944 */       consumer.setJndiName(getValue(localName, value));
/*      */     }
/*  946 */     else if (localName.equals("local-jndi-name"))
/*      */     {
/*  948 */       consumer.setLocalJndiName(getValue(localName, value));
/*      */     }
/*  950 */     else if (localName.equals("security-domain"))
/*      */     {
/*  952 */       consumer.setSecurityDomain(getValue(localName, value));
/*      */     }
/*  954 */     else if (localName.equals("run-as-principal"))
/*      */     {
/*  956 */       consumer.setRunAsPrincipal(getValue(localName, value));
/*      */     }
/*  958 */     else if (localName.equals("aop-domain-name"))
/*      */     {
/*  960 */       consumer.setAopDomainName(getValue(localName, value));
/*      */     }
/*  962 */     else if (localName.equals("depends"))
/*      */     {
/*  964 */       consumer.addDependency(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(RemoteBinding binding, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  973 */     if (localName.equals("jndi-name"))
/*      */     {
/*  975 */       binding.setJndiName(getValue(localName, value));
/*      */     }
/*  977 */     else if (localName.equals("client-bind-url"))
/*      */     {
/*  979 */       binding.setClientBindUrl(getValue(localName, value));
/*      */     }
/*  981 */     else if (localName.equals("proxy-factory"))
/*      */     {
/*  983 */       binding.setProxyFactory(getValue(localName, value));
/*      */     }
/*  985 */     else if (localName.equals("interceptor-stack"))
/*      */     {
/*  987 */       binding.setInterceptorStack(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(MessageProperties properties, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/*  996 */     if (localName.equals("delivery"))
/*      */     {
/*  998 */       properties.setDelivery(getValue(localName, value));
/*      */     }
/* 1000 */     else if (localName.equals("class"))
/*      */     {
/* 1002 */       properties.setClassName(getValue(localName, value));
/*      */     }
/* 1004 */     else if (localName.equals("priority"))
/*      */     {
/* 1006 */       properties.setPriority(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(ClusterConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1015 */     if (localName.equals("load-balance-policy"))
/*      */     {
/* 1017 */       config.setLoadBalancePolicy(getValue(localName, value));
/*      */     }
/* 1019 */     else if (localName.equals("partition-name"))
/*      */     {
/* 1021 */       config.setPartition(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(CacheConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1030 */     if (localName.equals("cache-class"))
/*      */     {
/* 1032 */       config.setCacheClass(getValue(localName, value));
/*      */     }
/* 1034 */     else if (localName.equals("cache-max-size"))
/*      */     {
/* 1036 */       config.setMaxSize(getValue(localName, value));
/*      */     }
/* 1038 */     else if (localName.equals("idle-timeout-seconds"))
/*      */     {
/* 1040 */       config.setIdleTimeoutSeconds(getValue(localName, value));
/*      */     }
/* 1042 */     else if (localName.equals("remove-timeout-seconds"))
/*      */     {
/* 1044 */       config.setRemoveTimeoutSeconds(getValue(localName, value));
/*      */     }
/* 1046 */     else if (localName.equals("cache-name"))
/*      */     {
/* 1048 */       config.setName(getValue(localName, value));
/*      */     }
/* 1050 */     else if (localName.equals("persistence-manager"))
/*      */     {
/* 1052 */       config.setPersistenceManager(getValue(localName, value));
/*      */     }
/* 1054 */     else if (localName.equals("replication-is-passivation"))
/*      */     {
/* 1056 */       config.setReplicationIsPassivation(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(PoolConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1065 */     if (localName.equals("pool-class"))
/*      */     {
/* 1067 */       config.setPoolClass(getValue(localName, value));
/*      */     }
/* 1069 */     else if (localName.equals("pool-max-size"))
/*      */     {
/* 1071 */       config.setMaxSize(getValue(localName, value));
/*      */     }
/* 1073 */     else if (localName.equals("pool-timeout"))
/*      */     {
/* 1075 */       config.setTimeout(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Method method, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1084 */     if (localName.equals("method-name"))
/*      */     {
/* 1086 */       method.setMethodName(getValue(localName, value));
/*      */     }
/* 1088 */     else if (localName.equals("transaction-timeout"))
/*      */     {
/* 1090 */       method.setTransactionTimeout(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(EjbJarDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1099 */     if (localName.equals("security-domain"))
/*      */     {
/* 1101 */       dd.setSecurityDomain(getValue(localName, value));
/*      */     }
/* 1103 */     else if (localName.equals("unauthenticated-principal"))
/*      */     {
/* 1105 */       dd.setUnauthenticatedPrincipal(getValue(localName, value));
/*      */     }
/* 1107 */     else if (localName.equals("jmx-name"))
/*      */     {
/* 1109 */       dd.setJmxName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Producer producer, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1118 */     if (localName.equals("class"))
/*      */     {
/* 1120 */       producer.setClassName(getValue(localName, value));
/*      */     }
/* 1122 */     else if (localName.equals("connection-factory"))
/*      */     {
/* 1124 */       producer.setConnectionFactory(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Ejb3PortComponent portComp, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1134 */     if (localName.equals("port-component-name"))
/*      */     {
/* 1136 */       portComp.setPortComponentName(value);
/*      */     }
/* 1138 */     else if (localName.equals("port-component-uri"))
/*      */     {
/* 1140 */       portComp.setPortComponentURI(value);
/*      */     }
/* 1142 */     else if (localName.equals("transport-guarantee"))
/*      */     {
/* 1144 */       portComp.setTransportGuarantee(value);
/*      */     }
/* 1146 */     else if (localName.equals("auth-method"))
/*      */     {
/* 1148 */       portComp.setAuthMethod(value);
/*      */     }
/* 1150 */     else if (localName.equals("secure-wsdl-access"))
/*      */     {
/* 1152 */       portComp.setSecureWSDLAccess(Boolean.valueOf(value));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(Webservices webservices, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1161 */     if (localName.equals("context-root"))
/*      */     {
/* 1163 */       webservices.setContextRoot(value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(WebserviceDescription desc, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1172 */     if (localName.equals("webservice-description-name"))
/*      */     {
/* 1174 */       desc.setDescriptionName(value);
/*      */     }
/* 1176 */     else if (localName.equals("config-name"))
/*      */     {
/* 1178 */       desc.setConfigName(value);
/*      */     }
/* 1180 */     else if (localName.equals("config-file"))
/*      */     {
/* 1182 */       desc.setConfigFile(value);
/*      */     }
/* 1184 */     else if (localName.equals("wsdl-publish-location"))
/*      */     {
/* 1186 */       desc.setWsdlPublishLocation(value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setValue(SecurityRoleMetaData srm, UnmarshallingContext navigator, String namespaceURI, String localName, String value)
/*      */   {
/* 1195 */     if (localName.equals("role-name"))
/*      */     {
/* 1197 */       srm.setRoleName(getValue(localName, value));
/*      */     }
/* 1199 */     else if (localName.equals("principal-name"))
/*      */     {
/* 1201 */       srm.addPrincipalName(getValue(localName, value));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected String getValue(String name, String value)
/*      */   {
/* 1208 */     if ((value.startsWith("${")) && (value.endsWith("}")))
/*      */     {
/* 1210 */       String replacement = StringPropertyReplacer.replaceProperties(value);
/* 1211 */       if (replacement != null)
/* 1212 */         value = replacement;
/*      */     }
/* 1214 */     return value;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.JBossDDObjectFactory
 * JD-Core Version:    0.6.0
 */