/*     */ package org.jboss.ejb3.metamodel;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import javax.ejb.TransactionManagementType;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
/*     */ import org.jboss.metamodel.descriptor.InjectionTarget;
/*     */ import org.jboss.metamodel.descriptor.MessageDestinationRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceEnvRef;
/*     */ import org.jboss.metamodel.descriptor.ResourceRef;
/*     */ import org.jboss.metamodel.descriptor.SecurityRoleRef;
/*     */ 
/*     */ public abstract class EnterpriseBean extends EnvironmentRefGroup
/*     */   implements Injectable
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(EnterpriseBean.class);
/*     */   public static final String BEAN = "Bean";
/*     */   public static final String CONTAINER = "Container";
/*  56 */   private String ejbName = null;
/*     */ 
/*  58 */   private String home = null;
/*     */ 
/*  60 */   private String remote = null;
/*     */ 
/*  62 */   private String localHome = null;
/*     */ 
/*  64 */   private String local = null;
/*     */ 
/*  66 */   private String ejbClass = null;
/*     */ 
/*  68 */   private List<RemoteBinding> remoteBindings = new ArrayList();
/*     */   private SecurityIdentity securityIdentity;
/*  72 */   protected TransactionManagementType tmType = null;
/*     */   private String jndiName;
/*     */   private String homeJndiName;
/*     */   private String localJndiName;
/*     */   private String localHomeJndiName;
/*     */   private String securityDomain;
/*  83 */   private boolean callByValue = false;
/*     */ 
/*  85 */   private String aopDomainName = null;
/*     */ 
/*  87 */   private MethodAttributes methodAttributes = null;
/*     */ 
/*  89 */   private Collection<String> dependencies = new HashSet();
/*     */ 
/*  91 */   private Collection<InjectionTarget> ignoreDependencies = new HashSet();
/*     */ 
/*  93 */   private Collection<XmlAnnotation> xmlAnnotations = new HashSet();
/*     */ 
/*  95 */   private PoolConfig poolConfig = null;
/*     */   private Ejb3PortComponent portComponent;
/* 100 */   private Collection<SecurityRoleRef> securityRoleRefs = new HashSet();
/*     */ 
/*     */   public void addXmlAnnotation(XmlAnnotation annotation)
/*     */   {
/* 105 */     this.xmlAnnotations.add(annotation);
/*     */   }
/*     */ 
/*     */   public Collection<XmlAnnotation> getXmlAnnotations()
/*     */   {
/* 110 */     return this.xmlAnnotations;
/*     */   }
/*     */ 
/*     */   public void setPoolConfig(PoolConfig poolConfig)
/*     */   {
/* 115 */     this.poolConfig = poolConfig;
/*     */   }
/*     */ 
/*     */   public PoolConfig getPoolConfig()
/*     */   {
/* 120 */     return this.poolConfig;
/*     */   }
/*     */ 
/*     */   public void addRemoteBinding(RemoteBinding binding)
/*     */   {
/* 125 */     this.remoteBindings.add(binding);
/*     */   }
/*     */ 
/*     */   public List<RemoteBinding> getRemoteBindings()
/*     */   {
/* 130 */     return this.remoteBindings;
/*     */   }
/*     */ 
/*     */   public void addDependency(String depends)
/*     */   {
/* 135 */     this.dependencies.add(depends);
/*     */   }
/*     */ 
/*     */   public Collection<String> getDependencies()
/*     */   {
/* 140 */     return this.dependencies;
/*     */   }
/*     */ 
/*     */   public void addIgnoreDependency(InjectionTarget ignore)
/*     */   {
/* 145 */     this.ignoreDependencies.add(ignore);
/*     */   }
/*     */ 
/*     */   public Collection<InjectionTarget> getIgnoreDependencies()
/*     */   {
/* 150 */     return this.ignoreDependencies;
/*     */   }
/*     */ 
/*     */   public void mergeMessageDestinationRef(MessageDestinationRef ref)
/*     */   {
/* 155 */     MessageDestinationRef tmpRef = (MessageDestinationRef)this.messageDestinationRefs.get(ref.getMessageDestinationRefName());
/* 156 */     if (tmpRef != null)
/* 157 */       tmpRef.merge(ref);
/*     */   }
/*     */ 
/*     */   public void mergeResourceRef(ResourceRef ref)
/*     */   {
/* 162 */     ResourceRef tmpRef = (ResourceRef)this.resourceRefs.get(ref.getResRefName());
/* 163 */     if (tmpRef != null)
/* 164 */       tmpRef.merge(ref);
/*     */   }
/*     */ 
/*     */   public void mergeResourceEnvRef(ResourceEnvRef ref)
/*     */   {
/* 169 */     ResourceEnvRef tmpRef = (ResourceEnvRef)this.resourceEnvRefs.get(ref.getResRefName());
/* 170 */     if (tmpRef != null)
/* 171 */       tmpRef.merge(ref);
/*     */   }
/*     */ 
/*     */   public void setMethodAttributes(MethodAttributes methodAttributes)
/*     */   {
/* 176 */     this.methodAttributes = methodAttributes;
/*     */   }
/*     */ 
/*     */   public MethodAttributes getMethodAttributes()
/*     */   {
/* 181 */     return this.methodAttributes;
/*     */   }
/*     */ 
/*     */   public void setAopDomainName(String aopDomainName)
/*     */   {
/* 186 */     this.aopDomainName = aopDomainName;
/*     */   }
/*     */ 
/*     */   public String getAopDomainName()
/*     */   {
/* 191 */     return this.aopDomainName;
/*     */   }
/*     */ 
/*     */   public void setRunAsPrincipal(String principal)
/*     */   {
/* 200 */     if (this.securityIdentity == null)
/*     */     {
/* 202 */       this.securityIdentity = new SecurityIdentity();
/*     */     }
/* 204 */     this.securityIdentity.setRunAsPrincipal(principal);
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean callByValue)
/*     */   {
/* 209 */     this.callByValue = callByValue;
/*     */   }
/*     */ 
/*     */   public boolean isCallByValue()
/*     */   {
/* 214 */     return this.callByValue;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 219 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 224 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 229 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 234 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getHomeJndiName()
/*     */   {
/* 239 */     return this.homeJndiName;
/*     */   }
/*     */ 
/*     */   public void setHomeJndiName(String homeJndiName)
/*     */   {
/* 244 */     this.homeJndiName = homeJndiName;
/*     */   }
/*     */ 
/*     */   public String getLocalJndiName()
/*     */   {
/* 249 */     return this.localJndiName;
/*     */   }
/*     */ 
/*     */   public void setLocalJndiName(String localJndiName)
/*     */   {
/* 254 */     this.localJndiName = localJndiName;
/*     */   }
/*     */ 
/*     */   public String getLocalHomeJndiName()
/*     */   {
/* 259 */     return this.localHomeJndiName;
/*     */   }
/*     */ 
/*     */   public void setLocalHomeJndiName(String localHomeJndiName)
/*     */   {
/* 264 */     this.localHomeJndiName = localHomeJndiName;
/*     */   }
/*     */ 
/*     */   public TransactionManagementType getTransactionManagementType()
/*     */   {
/* 269 */     return this.tmType;
/*     */   }
/*     */ 
/*     */   public void setTransactionManagementType(String transactionType)
/*     */   {
/* 274 */     if (transactionType.equals("Bean"))
/* 275 */       this.tmType = TransactionManagementType.BEAN;
/* 276 */     else if (transactionType.equals("Container"))
/* 277 */       this.tmType = TransactionManagementType.CONTAINER;
/*     */   }
/*     */ 
/*     */   public boolean isSessionBean()
/*     */   {
/* 282 */     return this instanceof SessionEnterpriseBean;
/*     */   }
/*     */ 
/*     */   public boolean isConsumer()
/*     */   {
/* 287 */     return this instanceof Consumer;
/*     */   }
/*     */ 
/*     */   public boolean isEntityBean()
/*     */   {
/* 292 */     return this instanceof EntityEnterpriseBean;
/*     */   }
/*     */ 
/*     */   public boolean isMessageDrivenBean()
/*     */   {
/* 297 */     return this instanceof MessageDrivenBean;
/*     */   }
/*     */ 
/*     */   public boolean isService()
/*     */   {
/* 302 */     return this instanceof Service;
/*     */   }
/*     */ 
/*     */   public String getEjbName()
/*     */   {
/* 307 */     return this.ejbName;
/*     */   }
/*     */ 
/*     */   public void setEjbName(String ejbName)
/*     */   {
/* 312 */     this.ejbName = ejbName;
/*     */   }
/*     */ 
/*     */   public String getHome()
/*     */   {
/* 317 */     return this.home;
/*     */   }
/*     */ 
/*     */   public void setHome(String home)
/*     */   {
/* 322 */     this.home = home;
/*     */   }
/*     */ 
/*     */   public String getRemote()
/*     */   {
/* 327 */     return this.remote;
/*     */   }
/*     */ 
/*     */   public void setRemote(String remote)
/*     */   {
/* 332 */     this.remote = remote;
/*     */   }
/*     */ 
/*     */   public String getLocalHome()
/*     */   {
/* 337 */     return this.localHome;
/*     */   }
/*     */ 
/*     */   public void setLocalHome(String localHome)
/*     */   {
/* 342 */     this.localHome = localHome;
/*     */   }
/*     */ 
/*     */   public String getLocal()
/*     */   {
/* 347 */     return this.local;
/*     */   }
/*     */ 
/*     */   public void setLocal(String local)
/*     */   {
/* 352 */     this.local = local;
/*     */   }
/*     */ 
/*     */   public String getEjbClass()
/*     */   {
/* 357 */     return this.ejbClass;
/*     */   }
/*     */ 
/*     */   public void setEjbClass(String ejbClass)
/*     */   {
/* 362 */     this.ejbClass = ejbClass;
/*     */   }
/*     */ 
/*     */   public SecurityIdentity getSecurityIdentity()
/*     */   {
/* 367 */     return this.securityIdentity;
/*     */   }
/*     */ 
/*     */   public void setSecurityIdentity(SecurityIdentity securityIdentity)
/*     */   {
/* 372 */     this.securityIdentity = securityIdentity;
/*     */   }
/*     */ 
/*     */   public void addSecurityRoleRef(SecurityRoleRef roleRef)
/*     */   {
/* 377 */     this.securityRoleRefs.add(roleRef);
/*     */   }
/*     */ 
/*     */   public Collection<SecurityRoleRef> getSecurityRoleRefs()
/*     */   {
/* 382 */     return this.securityRoleRefs;
/*     */   }
/*     */ 
/*     */   public Ejb3PortComponent getPortComponent()
/*     */   {
/* 387 */     return this.portComponent;
/*     */   }
/*     */ 
/*     */   public void setPortComponent(Ejb3PortComponent portComponent)
/*     */   {
/* 392 */     this.portComponent = portComponent;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 397 */     StringBuffer sb = new StringBuffer(100);
/* 398 */     sb.append("ejbName=").append(this.ejbName);
/* 399 */     sb.append(",remoteBindings=").append(this.remoteBindings);
/* 400 */     sb.append(",jndiName=").append(this.jndiName);
/* 401 */     sb.append(",local=").append(this.local);
/* 402 */     sb.append(",remote=").append(this.remote);
/* 403 */     sb.append(",home=").append(this.home);
/* 404 */     sb.append(",localHome=").append(this.localHome);
/* 405 */     sb.append(",ejbClass=").append(this.ejbClass);
/* 406 */     sb.append(",ejbRefs=").append(this.ejbRefs);
/* 407 */     sb.append(",ejbLocalRefs=").append(this.ejbLocalRefs);
/* 408 */     sb.append(",resourceRefs=").append(this.resourceRefs);
/* 409 */     sb.append(",resourceEnvRefs=").append(this.resourceEnvRefs);
/* 410 */     sb.append(",methodAttributes=").append(this.methodAttributes);
/* 411 */     sb.append(",aopDomainName=").append(this.aopDomainName);
/* 412 */     sb.append(",dependencies=").append(this.dependencies);
/* 413 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.metamodel.EnterpriseBean
 * JD-Core Version:    0.6.0
 */