/*    */ package org.jboss.ejb3.mdb;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aop.util.MethodHashing;
/*    */ 
/*    */ public class ProducerProxy
/*    */   implements InvocationHandler, Serializable
/*    */ {
/*    */   private static final long serialVersionUID = -2077140072365253007L;
/*    */   protected ProducerManager producer;
/*    */   protected Interceptor[] interceptors;
/*    */ 
/*    */   public ProducerProxy(ProducerManager producer, Interceptor[] interceptors)
/*    */   {
/* 46 */     this.producer = producer;
/* 47 */     this.interceptors = interceptors;
/*    */   }
/*    */ 
/*    */   public ProducerProxy()
/*    */   {
/*    */   }
/*    */ 
/*    */   public Object invoke(Object proxy, Method method, Object[] args)
/*    */     throws Throwable
/*    */   {
/* 58 */     if (method.getName().equals("getProducerManager"))
/*    */     {
/* 60 */       return this.producer;
/*    */     }
/* 62 */     long hash = MethodHashing.calculateHash(method);
/* 63 */     MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
/* 64 */     sri.setArguments(args);
/* 65 */     return sri.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.ProducerProxy
 * JD-Core Version:    0.6.0
 */