/*     */ package org.jboss.ejb3.lang;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ 
/*     */ public class ClassHelper
/*     */ {
/*     */   private static String argumentTypesToString(Class<?>[] argTypes)
/*     */   {
/*  42 */     StringBuilder buf = new StringBuilder();
/*  43 */     buf.append("(");
/*  44 */     if (argTypes != null)
/*     */     {
/*  46 */       for (int i = 0; i < argTypes.length; i++)
/*     */       {
/*  48 */         if (i > 0)
/*     */         {
/*  50 */           buf.append(", ");
/*     */         }
/*  52 */         Class c = argTypes[i];
/*  53 */         buf.append(c == null ? "null" : c.getName());
/*     */       }
/*     */     }
/*  56 */     buf.append(")");
/*  57 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private static Method findPrivateMethod(Class<?> target, String methodName, Class<?>[] paramTypes)
/*     */   {
/*  63 */     if (target == null) {
/*  64 */       return null;
/*     */     }
/*     */ 
/*  67 */     for (Method method : target.getDeclaredMethods())
/*     */     {
/*  69 */       if (!method.getName().equals(methodName))
/*     */         continue;
/*  71 */       if (paramTypes == null) {
/*  72 */         return method;
/*     */       }
/*  74 */       if (Arrays.equals(method.getParameterTypes(), paramTypes)) {
/*  75 */         return method;
/*     */       }
/*     */     }
/*     */ 
/*  79 */     return findPrivateMethod(target.getSuperclass(), methodName, paramTypes);
/*     */   }
/*     */ 
/*     */   public static List<Method> getAllMethodsByName(Class<?> cls, String methodName)
/*     */   {
/*  92 */     List methods = new ArrayList();
/*  93 */     populateWithMethodsByName(methods, cls, methodName);
/*  94 */     return methods;
/*     */   }
/*     */ 
/*     */   public static List<Method> getAllMethodsByPrefix(Class<?> clazz, String methodNamePrefix)
/*     */   {
/* 107 */     List methods = new ArrayList();
/* 108 */     populateWithMethodsByPrefix(methods, clazz, methodNamePrefix);
/* 109 */     return methods;
/*     */   }
/*     */ 
/*     */   public static Method getPrivateMethod(Class<?> cls, String methodName, Class<?>[] paramTypes)
/*     */     throws NoSuchMethodException
/*     */   {
/* 127 */     assert (cls != null) : "cls is null";
/* 128 */     assert (methodName != null) : "methodName is null";
/*     */ 
/* 130 */     Method result = findPrivateMethod(cls, methodName, paramTypes);
/* 131 */     if (result == null) {
/* 132 */       throw new NoSuchMethodException(cls.getName() + "." + methodName + argumentTypesToString(paramTypes));
/*     */     }
/* 134 */     return result;
/*     */   }
/*     */ 
/*     */   private static void populateWithMethodsByName(List<Method> methods, Class<?> cls, String methodName)
/*     */   {
/* 140 */     if (cls == null) {
/* 141 */       return;
/*     */     }
/* 143 */     for (Method method : cls.getDeclaredMethods())
/*     */     {
/* 145 */       if (method.getName().equals(methodName)) {
/* 146 */         methods.add(method);
/*     */       }
/*     */     }
/* 149 */     populateWithMethodsByName(methods, cls.getSuperclass(), methodName);
/*     */   }
/*     */ 
/*     */   private static void populateWithMethodsByPrefix(List<Method> methods, Class<?> clazz, String methodNamePrefix)
/*     */   {
/* 155 */     if (clazz == null)
/*     */     {
/* 157 */       return;
/*     */     }
/*     */ 
/* 161 */     for (Method method : clazz.getDeclaredMethods())
/*     */     {
/* 163 */       if (method.getName().startsWith(methodNamePrefix)) {
/* 164 */         methods.add(method);
/*     */       }
/*     */     }
/* 167 */     populateWithMethodsByPrefix(methods, clazz.getSuperclass(), methodNamePrefix);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.lang.ClassHelper
 * JD-Core Version:    0.6.0
 */