/*     */ package org.jboss.ejb3.kernel;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryEntry;
/*     */ import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JNDIKernelRegistryPlugin
/*     */   implements KernelRegistryPlugin
/*     */ {
/*     */   private static final Logger log;
/*     */   public static final String JNDI_DEPENDENCY_PREFIX = "jndi:";
/*     */   private Context context;
/*     */   private Hashtable<?, ?> environment;
/*     */ 
/*     */   public JNDIKernelRegistryPlugin()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JNDIKernelRegistryPlugin(Hashtable environment)
/*     */   {
/*  58 */     this.environment = environment;
/*     */   }
/*     */ 
/*     */   public void create() throws NamingException
/*     */   {
/*  63 */     log.debug("Creating JNDIKernelRegistryPlugin");
/*  64 */     this.context = InitialContextFactory.getInitialContext(this.environment);
/*     */   }
/*     */ 
/*     */   public void destroy() throws NamingException
/*     */   {
/*  69 */     log.debug("Destroying JNDIKernelRegistryPlugin");
/*  70 */     if (this.context != null)
/*  71 */       this.context.close();
/*  72 */     this.context = null;
/*     */   }
/*     */ 
/*     */   public KernelRegistryEntry getEntry(Object name)
/*     */   {
/*  77 */     assert (name != null) : "name is null";
/*     */ 
/*  79 */     String s = String.valueOf(name);
/*  80 */     if (!s.startsWith("jndi:")) {
/*  81 */       return null;
/*     */     }
/*  83 */     if (log.isTraceEnabled()) {
/*  84 */       log.trace("get entry for " + name);
/*     */     }
/*     */     try
/*     */     {
/*  88 */       Object target = this.context.lookup(s.substring("jndi:".length()));
/*  89 */       if (log.isTraceEnabled()) {
/*  90 */         log.trace("found: " + target);
/*     */       }
/*  92 */       return new AbstractKernelRegistryEntry(name, target);
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/* 104 */       log.trace("not found");
/* 105 */       return null;
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 109 */       log.trace("entry can't be resolved", e);
/* 110 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 114 */       log.trace("entry can't be resolved", e);
/* 115 */     }throw e;
/*     */   }
/*     */ 
/*     */   public void setEnvironment(Hashtable<?, ?> env)
/*     */   {
/* 121 */     if (this.context != null)
/* 122 */       throw new IllegalStateException("context already initialized");
/* 123 */     this.environment = env;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  45 */     log = Logger.getLogger(JNDIKernelRegistryPlugin.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.kernel.JNDIKernelRegistryPlugin
 * JD-Core Version:    0.6.0
 */