/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.interceptor.InvocationContext;
/*     */ import org.jboss.ejb3.EJBContainerInvocation;
/*     */ 
/*     */ public class InvocationContextImpl
/*     */   implements InvocationContext
/*     */ {
/*     */   private int currentInterceptor;
/*     */   private int currentMethod;
/*     */   private int currentBeanMethod;
/*     */   InterceptorInfo[] interceptorInfos;
/*     */   Object[] instances;
/*     */   private Method[] beanAroundInvokes;
/*     */   private Map metadata;
/*     */   EJBContainerInvocation wrapped;
/*     */ 
/*     */   public InvocationContextImpl(EJBContainerInvocation inv, InterceptorInfo[] interceptorInfos, Object[] instances, Method[] beanAroundInvokes)
/*     */   {
/*  51 */     this.wrapped = inv;
/*  52 */     this.beanAroundInvokes = beanAroundInvokes;
/*     */ 
/*  54 */     if (interceptorInfos.length != instances.length)
/*     */     {
/*  56 */       throw new RuntimeException("interceptorInfos and instances have different length");
/*     */     }
/*     */ 
/*  59 */     this.interceptorInfos = interceptorInfos;
/*  60 */     this.instances = instances;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/*  65 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  70 */     return this.wrapped.getMethod();
/*     */   }
/*     */ 
/*     */   public Object[] getParameters()
/*     */   {
/*  75 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setParameters(Object[] params)
/*     */   {
/*  80 */     this.wrapped.setArguments(params);
/*     */   }
/*     */ 
/*     */   public Map getContextData()
/*     */   {
/*  85 */     if (this.metadata == null) {
/*  86 */       this.metadata = ClientInterceptorUtil.getClientMetadataMap(this.wrapped);
/*  87 */       if (this.metadata == null)
/*     */       {
/*  89 */         this.metadata = new HashMap();
/*     */       }
/*     */     }
/*  92 */     return this.metadata;
/*     */   }
/*     */ 
/*     */   public Object proceed()
/*     */     throws Exception
/*     */   {
/*     */     int oldMethod;
/*  97 */     if (this.currentInterceptor < this.interceptorInfos.length)
/*     */     {
/*  99 */       int oldInterceptor = this.currentInterceptor;
/* 100 */       oldMethod = this.currentMethod;
/*     */       try
/*     */       {
/* 103 */         int curr = this.currentInterceptor;
/* 104 */         int currMethod = this.currentMethod++;
/*     */ 
/* 106 */         InterceptorInfo info = this.interceptorInfos[curr];
/* 107 */         if (currMethod == info.getAroundInvokes().length)
/*     */         {
/* 109 */           curr = ++this.currentInterceptor;
/* 110 */           this.currentMethod = 0;
/* 111 */           currMethod = this.currentMethod++;
/* 112 */           info = curr < this.interceptorInfos.length ? this.interceptorInfos[curr] : null;
/*     */         }
/* 114 */         if (info != null)
/*     */         {
/*     */           try
/*     */           {
/* 118 */             Object localObject1 = info.getAroundInvokes()[currMethod].invoke(this.instances[curr], new Object[] { this });
/*     */ 
/* 136 */             this.currentInterceptor = oldInterceptor;
/* 137 */             this.currentMethod = oldMethod; return localObject1;
/*     */           }
/*     */           catch (InvocationTargetException e)
/*     */           {
/* 122 */             if ((e.getTargetException() instanceof Exception))
/*     */             {
/* 124 */               throw ((Exception)e.getCause());
/*     */             }
/*     */ 
/* 128 */             throw new RuntimeException(e.getCause());
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 136 */         this.currentInterceptor = oldInterceptor;
/* 137 */         this.currentMethod = oldMethod;
/*     */       }
/*     */     }
/*     */ 
/* 141 */     if ((this.beanAroundInvokes != null) && (this.currentBeanMethod < this.beanAroundInvokes.length))
/*     */     {
/*     */       try
/*     */       {
/* 145 */         int curr = this.currentBeanMethod++;
/* 146 */         oldMethod = this.beanAroundInvokes[curr].invoke(getTarget(), new Object[] { this });
/*     */         return oldMethod;
/*     */       }
/*     */       catch (InvocationTargetException e)
/*     */       {
/* 150 */         if ((e.getTargetException() instanceof Exception))
/*     */         {
/* 152 */           throw ((Exception)e.getCause());
/*     */         }
/*     */ 
/* 156 */         throw new RuntimeException(e.getCause());
/*     */       }
/*     */       finally
/*     */       {
/* 161 */         this.currentBeanMethod -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 166 */       return this.wrapped.invokeNext();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 170 */       throw e;
/*     */     }
/*     */     catch (Throwable t) {
/*     */     }
/* 174 */     throw new RuntimeException(t);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.InvocationContextImpl
 * JD-Core Version:    0.6.0
 */