/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Arrays;
/*     */ import javax.jms.Message;
/*     */ import javax.jms.MessageListener;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.advice.AspectFactory;
/*     */ import org.jboss.aop.joinpoint.Joinpoint;
/*     */ import org.jboss.aop.joinpoint.MethodJoinpoint;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.MethodHashing;
/*     */ 
/*     */ public class EJB3InterceptorsFactory
/*     */   implements AspectFactory
/*     */ {
/*  44 */   static Logger log = Logger.getLogger(EJB3InterceptorsFactory.class);
/*     */   static final long MESSAGE_LISTENER_ON_MESSAGE;
/*     */ 
/*     */   public String getName()
/*     */   {
/*  63 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public Object createPerVM()
/*     */   {
/*  68 */     throw new RuntimeException("NOT ALLOWED");
/*     */   }
/*     */ 
/*     */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*     */   {
/*  73 */     throw new RuntimeException("NOT ALLOWED");
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*     */   {
/*  78 */     throw new RuntimeException("NOT ALLOWED");
/*     */   }
/*     */ 
/*     */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*     */   {
/*  83 */     if ((jp instanceof MethodJoinpoint))
/*     */     {
/*  85 */       EJBContainer container = (EJBContainer)advisor;
/*  86 */       Class beanClass = container.getBeanClass();
/*     */       try
/*     */       {
/*  90 */         Method method = ((MethodJoinpoint)jp).getMethod();
/*  91 */         if (container.isBusinessMethod(method))
/*     */         {
/*  93 */           InterceptorInfo[] infos = container.getInterceptorRepository().getBusinessInterceptors(container, method);
/*  94 */           Method[] beanAroundInvoke = container.getInterceptorRepository().getBeanClassAroundInvokes(container);
/*  95 */           Object infoString = "[]";
/*  96 */           if (infoString != null)
/*  97 */             infoString = Arrays.asList(infos);
/*  98 */           log.debug("Bound interceptors for joinpoint: " + method + " - " + infoString);
/*  99 */           return new EJB3InterceptorsInterceptor(infos, beanAroundInvoke);
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 104 */         throw new RuntimeException("An exception occurred initialising interceptors for " + beanClass + "." + ((MethodJoinpoint)jp).getMethod().getName(), e);
/*     */       }
/*     */     }
/* 107 */     return new EJB3InterceptorsInterceptor(new InterceptorInfo[0], null);
/*     */   }
/*     */ 
/*     */   public Object createPerClass(Advisor advisor)
/*     */   {
/* 112 */     throw new RuntimeException("NOT ALLOWED");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  51 */       Class clazz = MessageListener.class;
/*  52 */       Method m = clazz.getDeclaredMethod("onMessage", new Class[] { Message.class });
/*  53 */       MESSAGE_LISTENER_ON_MESSAGE = MethodHashing.calculateHash(m);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  57 */       throw new RuntimeException("Error initialising hash for MessageListener.onMessage()", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.EJB3InterceptorsFactory
 * JD-Core Version:    0.6.0
 */