/*     */ package org.jboss.ejb3.interceptor;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData.MetaDataValue;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ 
/*     */ public class ClientInterceptorUtil
/*     */ {
/*     */   public static final String CLIENT_METADATA = "jboss.ejb3.client.invocation.metadata";
/*     */ 
/*     */   public static void addMetadata(Invocation invocation, Object key, Object value, PayloadKey payload)
/*     */   {
/*  46 */     invocation.getMetaData().addMetaData("jboss.ejb3.client.invocation.metadata", key, value, payload);
/*     */   }
/*     */ 
/*     */   public static void addMetadata(Invocation invocation, Object key, Object value)
/*     */   {
/*  51 */     invocation.getMetaData().addMetaData("jboss.ejb3.client.invocation.metadata", key, value);
/*     */   }
/*     */ 
/*     */   public static Object getMetadata(Invocation invocation, Object key)
/*     */   {
/*  56 */     return invocation.getMetaData().getMetaData("jboss.ejb3.client.invocation.metadata", key);
/*     */   }
/*     */ 
/*     */   static Map getClientMetadataMap(Invocation invocation)
/*     */   {
/*  61 */     Map map = invocation.getMetaData().tag("jboss.ejb3.client.invocation.metadata");
/*  62 */     if (map != null)
/*     */     {
/*  64 */       return new ClientValueMap(map, null);
/*     */     }
/*  66 */     return null;
/*     */   }
/*     */ 
/*     */   private static class ClientValueMap
/*     */     implements Map
/*     */   {
/*     */     Map marshalledMap;
/*     */     boolean haveUnmarshalledAllEntries;
/*     */ 
/*     */     private ClientValueMap(Map marshalledMap)
/*     */     {
/*  80 */       this.marshalledMap = marshalledMap;
/*     */     }
/*     */ 
/*     */     public void clear()
/*     */     {
/*  85 */       this.marshalledMap.clear();
/*     */     }
/*     */ 
/*     */     public boolean containsKey(Object key)
/*     */     {
/*  90 */       return this.marshalledMap.containsKey(key);
/*     */     }
/*     */ 
/*     */     public boolean containsValue(Object value)
/*     */     {
/*  95 */       unmarshallAllEntries();
/*  96 */       return this.marshalledMap.containsValue(value);
/*     */     }
/*     */ 
/*     */     public Set entrySet()
/*     */     {
/* 101 */       unmarshallAllEntries();
/* 102 */       return this.marshalledMap.entrySet();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 107 */       return this.marshalledMap.equals(o);
/*     */     }
/*     */ 
/*     */     public Object get(Object key)
/*     */     {
/* 112 */       return unmarshallEntry(key);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 117 */       return this.marshalledMap.hashCode();
/*     */     }
/*     */ 
/*     */     public boolean isEmpty()
/*     */     {
/* 122 */       return this.marshalledMap.isEmpty();
/*     */     }
/*     */ 
/*     */     public Set keySet()
/*     */     {
/* 127 */       return this.marshalledMap.keySet();
/*     */     }
/*     */ 
/*     */     public Object put(Object key, Object value)
/*     */     {
/* 132 */       return this.marshalledMap.put(key, value);
/*     */     }
/*     */ 
/*     */     public void putAll(Map t)
/*     */     {
/* 137 */       this.marshalledMap.putAll(t);
/*     */     }
/*     */ 
/*     */     public Object remove(Object key)
/*     */     {
/* 142 */       return this.marshalledMap.remove(key);
/*     */     }
/*     */ 
/*     */     public int size()
/*     */     {
/* 147 */       return this.marshalledMap.size();
/*     */     }
/*     */ 
/*     */     public Collection values()
/*     */     {
/* 152 */       unmarshallAllEntries();
/* 153 */       return this.marshalledMap.values();
/*     */     }
/*     */ 
/*     */     private void unmarshallAllEntries()
/*     */     {
/* 158 */       if (this.haveUnmarshalledAllEntries)
/*     */       {
/* 160 */         return;
/*     */       }
/*     */ 
/* 163 */       Iterator keys = this.marshalledMap.keySet().iterator();
/* 164 */       while (keys.hasNext())
/*     */       {
/* 167 */         unmarshallEntry(keys.next());
/*     */       }
/* 169 */       this.haveUnmarshalledAllEntries = true;
/*     */     }
/*     */ 
/*     */     private Object unmarshallEntry(Object key)
/*     */     {
/*     */       try
/*     */       {
/* 176 */         Object obj = this.marshalledMap.get(key);
/* 177 */         if ((obj instanceof SimpleMetaData.MetaDataValue))
/*     */         {
/* 179 */           Object realObj = ((SimpleMetaData.MetaDataValue)obj).get();
/* 180 */           this.marshalledMap.put(key, realObj);
/* 181 */           return realObj;
/*     */         }
/* 183 */         return obj;
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 187 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (ClassNotFoundException e) {
/*     */       }
/* 191 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.interceptor.ClientInterceptorUtil
 * JD-Core Version:    0.6.0
 */