/*     */ package org.jboss.ejb3.iiop;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.security.Principal;
/*     */ import java.util.HashMap;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.iiop.CorbaORB;
/*     */ import org.jboss.iiop.csiv2.SASCurrent;
/*     */ import org.jboss.iiop.rmi.AttributeAnalysis;
/*     */ import org.jboss.iiop.rmi.InterfaceAnalysis;
/*     */ import org.jboss.iiop.rmi.OperationAnalysis;
/*     */ import org.jboss.iiop.rmi.RmiIdlUtil;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
/*     */ import org.jboss.iiop.tm.InboundTransactionCurrent;
/*     */ import org.jboss.invocation.iiop.ReferenceData;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.SecurityAssociation;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ import org.omg.CORBA.BAD_OPERATION;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.ORBPackage.InvalidName;
/*     */ import org.omg.CORBA.SystemException;
/*     */ import org.omg.CORBA.portable.InvokeHandler;
/*     */ import org.omg.CORBA.portable.ResponseHandler;
/*     */ import org.omg.PortableServer.Current;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.Servant;
/*     */ 
/*     */ public class BeanCorbaServant extends Servant
/*     */   implements InvokeHandler
/*     */ {
/*     */   private static final Logger log;
/*     */   private final IORFactory factory;
/*     */   private final Current poaCurrent;
/*     */   private final Container container;
/*     */   private final InterfaceDef interfaceDef;
/*     */   private final String[] repositoryIds;
/*     */   private SASCurrent sasCurrent;
/*     */   private InboundTransactionCurrent inboundTxCurrent;
/*     */   private HashMap<String, SkeletonStrategy> methodMap;
/*     */ 
/*     */   protected BeanCorbaServant(IORFactory factory, Current poaCurrent, Container container, InterfaceDef interfaceDef, InterfaceAnalysis interfaceAnalysis)
/*     */   {
/*  84 */     assert (factory != null) : "factory is null";
/*  85 */     assert (poaCurrent != null) : "poaCurrent is null";
/*  86 */     assert (container != null) : "container is null";
/*  87 */     assert ((container instanceof SessionContainer)) : "only SessionContainer supported";
/*     */ 
/*  89 */     assert (interfaceAnalysis != null) : "interfaceAnalysis is null";
/*     */ 
/*  91 */     this.factory = factory;
/*  92 */     this.poaCurrent = poaCurrent;
/*  93 */     this.container = container;
/*  94 */     this.interfaceDef = interfaceDef;
/*  95 */     this.repositoryIds = interfaceAnalysis.getAllTypeIds();
/*     */     try
/*     */     {
/*  99 */       this.sasCurrent = ((SASCurrent)CorbaORB.getInstance().resolve_initial_references("SASCurrent"));
/*     */     }
/*     */     catch (InvalidName e)
/*     */     {
/* 103 */       log.warn("Can't find SASCurrent");
/* 104 */       this.sasCurrent = null;
/*     */     }
/*     */     try
/*     */     {
/* 108 */       this.inboundTxCurrent = ((InboundTransactionCurrent)CorbaORB.getInstance().resolve_initial_references("InboundTransactionCurrent"));
/*     */     }
/*     */     catch (InvalidName e)
/*     */     {
/* 113 */       log.warn("Can't find InboundTransactionCurrent");
/* 114 */       this.inboundTxCurrent = null;
/*     */     }
/*     */ 
/* 117 */     this.methodMap = new HashMap();
/* 118 */     AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
/* 119 */     for (int i = 0; i < attrs.length; i++) {
/* 120 */       OperationAnalysis op = attrs[i].getAccessorAnalysis();
/*     */ 
/* 122 */       log.debug("    " + op.getJavaName() + ": " + op.getIDLName());
/* 123 */       this.methodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */ 
/* 125 */       op = attrs[i].getMutatorAnalysis();
/* 126 */       if (op != null) {
/* 127 */         log.debug("    " + op.getJavaName() + ": " + op.getIDLName());
/* 128 */         this.methodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 133 */     OperationAnalysis[] ops = interfaceAnalysis.getOperations();
/* 134 */     for (int i = 0; i < ops.length; i++) {
/* 135 */       log.debug("    " + ops[i].getJavaName() + ": " + ops[i].getIDLName());
/* 136 */       this.methodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
/*     */     }
/*     */   }
/*     */ 
/*     */   public String[] _all_interfaces(POA poa, byte[] objectId)
/*     */   {
/* 144 */     return (String[])(String[])this.repositoryIds.clone();
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.Object _get_interface_def()
/*     */   {
/* 153 */     if (this.interfaceDef != null) {
/* 154 */       return this.interfaceDef;
/*     */     }
/* 156 */     return super._get_interface_def();
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler) throws SystemException
/*     */   {
/* 161 */     log.trace("invoke: " + opName);
/*     */ 
/* 163 */     SkeletonStrategy op = (SkeletonStrategy)this.methodMap.get(opName);
/* 164 */     if (op == null)
/*     */     {
/* 166 */       log.debug("Unable to find opname '" + opName + "' valid operations:" + this.methodMap.keySet());
/* 167 */       throw new BAD_OPERATION(opName);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 173 */       java.lang.Object id = ReferenceData.extractObjectId(this.poaCurrent.get_object_id());
/* 174 */       log.trace("id = " + id);
/*     */ 
/* 176 */       Transaction tx = null;
/* 177 */       if (this.inboundTxCurrent != null)
/* 178 */         tx = this.inboundTxCurrent.getCurrentTransaction();
/* 179 */       log.trace("tx = " + tx);
/*     */ 
/* 181 */       if (this.sasCurrent != null)
/*     */       {
/* 183 */         byte[] username = this.sasCurrent.get_incoming_username();
/* 184 */         byte[] credentials = this.sasCurrent.get_incoming_password();
/* 185 */         byte[] principalName = this.sasCurrent.get_incoming_principal_name();
/*     */ 
/* 187 */         if ((username != null) && (username.length > 0))
/*     */         {
/* 189 */           String name = new String(username, "UTF-8");
/* 190 */           int domainIndex = name.lastIndexOf("@");
/* 191 */           if (domainIndex > 0)
/* 192 */             name = name.substring(0, domainIndex);
/* 193 */           log.debug("username = " + name);
/* 194 */           Principal principal = new SimplePrincipal(name);
/* 195 */           SecurityAssociation.setPrincipal(principal);
/*     */         }
/*     */ 
/* 198 */         if ((credentials != null) && (credentials.length > 0))
/*     */         {
/* 200 */           SecurityAssociation.setCredential(new String(credentials, "UTF-8").toCharArray());
/*     */         }
/*     */ 
/* 203 */         if ((principalName != null) && (principalName.length > 0)) {
/* 204 */           log.warn("principalName = " + new String(principalName, "UTF-8"));
/*     */         }
/*     */       }
/* 207 */       java.lang.Object[] args = op.readParams((org.omg.CORBA_2_3.portable.InputStream)in);
/*     */ 
/* 209 */       java.lang.Object retVal = invoke(tx, id, op.getMethod(), args);
/*     */ 
/* 211 */       out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createReply();
/* 212 */       if (op.isNonVoid())
/* 213 */         op.writeRetval(out, retVal);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */       org.omg.CORBA_2_3.portable.OutputStream out;
/* 218 */       t.printStackTrace();
/* 219 */       if ((t instanceof Exception))
/*     */       {
/* 221 */         Exception e = (Exception)t;
/* 222 */         RmiIdlUtil.rethrowIfCorbaSystemException(e);
/* 223 */         out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createExceptionReply();
/* 224 */         op.writeException(out, e);
/*     */       }
/*     */       else {
/* 227 */         throw new RuntimeException("NYI");
/*     */       }
/*     */     }
/*     */     org.omg.CORBA_2_3.portable.OutputStream out;
/* 229 */     return out;
/*     */   }
/*     */ 
/*     */   private TransactionManager getTransactionManager()
/*     */   {
/* 235 */     return TransactionManagerLocator.getInstance().locate();
/*     */   }
/*     */ 
/*     */   private java.lang.Object invoke(java.lang.Object id, Method method, java.lang.Object[] args)
/*     */     throws Throwable
/*     */   {
/* 241 */     return ((SessionContainer)this.container).invoke(this.factory, id, method, args, null);
/*     */   }
/*     */ 
/*     */   private java.lang.Object invoke(Transaction tx, java.lang.Object id, Method method, java.lang.Object[] args) throws Throwable
/*     */   {
/* 246 */     if (tx == null) {
/* 247 */       return invoke(id, method, args);
/*     */     }
/*     */ 
/* 251 */     TransactionManager tm = getTransactionManager();
/*     */ 
/* 254 */     if (tm.getTransaction() != null)
/* 255 */       throw new RuntimeException("cannot import a transaction context when a transaction is already associated with the thread");
/* 256 */     tm.resume(tx);
/*     */     try
/*     */     {
/* 259 */       java.lang.Object localObject1 = invoke(id, method, args);
/*     */       return localObject1; } finally { tm.suspend(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     log = Logger.getLogger(BeanCorbaServant.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.iiop.BeanCorbaServant
 * JD-Core Version:    0.6.0
 */