/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import org.hibernate.cache.Cache;
/*     */ import org.hibernate.cache.CacheException;
/*     */ import org.hibernate.cache.CacheProvider;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TreeCacheProviderHook
/*     */   implements CacheProvider
/*     */ {
/*     */   public static final String HIBERNATE_CACHE_OBJECT_NAME_PROPERTY = "hibernate.treecache.mbean.object_name";
/*     */   public static final String DEFAULT_MBEAN_OBJECT_NAME = "jboss.cache:service=EJB3EntityTreeCache";
/*  59 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private TransactionalCacheFactory cacheFactory;
/*     */ 
/*     */   public Cache buildCache(String regionName, Properties properties)
/*     */     throws CacheException
/*     */   {
/*  74 */     return this.cacheFactory.buildCache(regionName, properties);
/*     */   }
/*     */ 
/*     */   public boolean isMinimalPutsEnabledByDefault()
/*     */   {
/*  79 */     return true;
/*     */   }
/*     */ 
/*     */   public long nextTimestamp()
/*     */   {
/*  84 */     return System.currentTimeMillis() / 100L;
/*     */   }
/*     */ 
/*     */   public void start(Properties properties)
/*     */   {
/*  99 */     this.cacheFactory = TransactionalCacheFactory.getFactory(properties);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected TransactionalCacheFactory getCacheFactory()
/*     */   {
/* 108 */     return this.cacheFactory;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.TreeCacheProviderHook
 * JD-Core Version:    0.6.0
 */