/*    */ package org.jboss.ejb3.entity;
/*    */ 
/*    */ import java.util.Properties;
/*    */ import org.hibernate.cache.Cache;
/*    */ import org.hibernate.cache.CacheException;
/*    */ import org.jboss.cache.Version;
/*    */ 
/*    */ public abstract class TransactionalCacheFactory
/*    */ {
/*    */   public static TransactionalCacheFactory getFactory(Properties hibernateConfig)
/*    */     throws CacheException
/*    */   {
/* 24 */     String factoryClass = null;
/* 25 */     short version = Version.getVersionShort();
/* 26 */     if ((version >= Version.getVersionShort("2.0.0.GA")) || (version <= 0))
/*    */     {
/* 28 */       factoryClass = "org.jboss.ejb3.entity.JBCCacheFactory";
/*    */     }
/*    */     else
/*    */     {
/* 35 */       throw new IllegalStateException("Cannot create factory for JBC 1.x");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 40 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
/* 41 */       TransactionalCacheFactory factory = (TransactionalCacheFactory)clazz.newInstance();
/* 42 */       factory.configure(hibernateConfig);
/*    */ 
/* 44 */       return factory;
/*    */     }
/*    */     catch (CacheException e)
/*    */     {
/* 48 */       throw e;
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 52 */     throw new CacheException(e);
/*    */   }
/*    */ 
/*    */   public abstract Cache buildCache(String paramString, Properties paramProperties)
/*    */     throws CacheException;
/*    */ 
/*    */   protected abstract void configure(Properties paramProperties);
/*    */ 
/*    */   public abstract boolean isOptimistic();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.TransactionalCacheFactory
 * JD-Core Version:    0.6.0
 */