/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.util.Comparator;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.hibernate.cache.CacheException;
/*     */ import org.hibernate.cache.OptimisticCache;
/*     */ import org.hibernate.cache.OptimisticCacheSource;
/*     */ import org.hibernate.cache.StandardQueryCache;
/*     */ import org.hibernate.cache.UpdateTimestampsCache;
/*     */ import org.jboss.cache.Cache;
/*     */ import org.jboss.cache.Fqn;
/*     */ import org.jboss.cache.InvocationContext;
/*     */ import org.jboss.cache.Node;
/*     */ import org.jboss.cache.Region;
/*     */ import org.jboss.cache.config.Configuration;
/*     */ import org.jboss.cache.config.Option;
/*     */ import org.jboss.cache.lock.TimeoutException;
/*     */ import org.jboss.cache.optimistic.DataVersion;
/*     */ 
/*     */ public class OptimisticJBCCache
/*     */   implements OptimisticCache
/*     */ {
/*  59 */   private static final Log log = LogFactory.getLog(OptimisticJBCCache.class);
/*     */   private static final String ITEM = "item";
/*     */   private Cache cache;
/*     */   private final String regionName;
/*     */   private final Fqn regionFqn;
/*     */   private OptimisticCacheSource source;
/*     */   private boolean localWritesOnly;
/*     */ 
/*     */   public OptimisticJBCCache(Cache cache, String regionName, String regionPrefix)
/*     */     throws CacheException
/*     */   {
/*  72 */     this.cache = cache;
/*  73 */     this.regionName = regionName;
/*  74 */     this.regionFqn = Fqn.fromString(SecondLevelCacheUtil.createRegionFqn(regionName, regionPrefix));
/*  75 */     Configuration config = cache.getConfiguration();
/*  76 */     if (config.isUseRegionBasedMarshalling())
/*     */     {
/*  78 */       this.localWritesOnly = StandardQueryCache.class.getName().equals(regionName);
/*     */ 
/*  80 */       boolean fetchState = config.isFetchInMemoryState();
/*     */       try
/*     */       {
/*  85 */         if (this.localWritesOnly) {
/*  86 */           config.setFetchInMemoryState(false);
/*     */         }
/*     */ 
/*  89 */         activateCacheRegion(this.regionFqn.toString());
/*     */       }
/*     */       finally
/*     */       {
/*  94 */         if (this.localWritesOnly)
/*  95 */           config.setFetchInMemoryState(fetchState);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 100 */       log.debug("TreeCache is not configured for region based marshalling");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setSource(OptimisticCacheSource source)
/*     */   {
/* 108 */     this.source = source;
/*     */   }
/*     */ 
/*     */   public void writeInsert(Object key, Object value, Object currentVersion) {
/* 112 */     writeUpdate(key, value, currentVersion, null);
/*     */   }
/*     */ 
/*     */   public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
/*     */     try {
/* 117 */       Option option = new Option();
/* 118 */       DataVersion dv = (this.source != null) && (this.source.isVersioned()) ? new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
/*     */ 
/* 121 */       option.setDataVersion(dv);
/* 122 */       option.setCacheModeLocal(this.localWritesOnly);
/* 123 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 124 */       this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */     }
/*     */     catch (Exception e) {
/* 127 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeLoad(Object key, Object value, Object currentVersion) {
/*     */     try {
/* 133 */       Option option = new Option();
/* 134 */       option.setFailSilently(true);
/* 135 */       option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 136 */       option.setCacheModeLocal(this.localWritesOnly);
/* 137 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 138 */       this.cache.remove(new Fqn(this.regionFqn, new Object[] { key }), "ITEM");
/*     */ 
/* 140 */       option = new Option();
/* 141 */       option.setFailSilently(true);
/* 142 */       DataVersion dv = (this.source != null) && (this.source.isVersioned()) ? new DataVersionAdapter(currentVersion, currentVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
/*     */ 
/* 145 */       option.setDataVersion(dv);
/* 146 */       option.setCacheModeLocal(this.localWritesOnly);
/* 147 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 148 */       this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */     }
/*     */     catch (Exception e) {
/* 151 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */     throws CacheException
/*     */   {
/*     */     try
/*     */     {
/* 160 */       Option option = new Option();
/* 161 */       option.setFailSilently(true);
/*     */ 
/* 163 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 164 */       return this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item");
/*     */     } catch (Exception e) {
/*     */     }
/* 167 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public Object read(Object key) throws CacheException
/*     */   {
/*     */     try {
/* 173 */       return this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item");
/*     */     } catch (Exception e) {
/*     */     }
/* 176 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public void update(Object key, Object value) throws CacheException
/*     */   {
/*     */     try {
/* 182 */       Option option = new Option();
/* 183 */       option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 184 */       option.setCacheModeLocal(this.localWritesOnly);
/* 185 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 186 */       this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */     }
/*     */     catch (Exception e) {
/* 189 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void put(Object key, Object value) throws CacheException {
/*     */     try {
/* 195 */       log.trace("performing put() into region [" + this.regionName + "]");
/*     */ 
/* 197 */       Option option = new Option();
/* 198 */       option.setFailSilently(true);
/* 199 */       option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 200 */       option.setCacheModeLocal(this.localWritesOnly);
/* 201 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 202 */       this.cache.put(new Fqn(this.regionFqn, new Object[] { key }), "item", value);
/*     */     }
/*     */     catch (TimeoutException te)
/*     */     {
/* 206 */       log.debug("ignoring write lock acquisition failure");
/*     */     }
/*     */     catch (Exception e) {
/* 209 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Object key) throws CacheException
/*     */   {
/*     */     try
/*     */     {
/* 217 */       if (this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item") != null) {
/* 218 */         Option option = new Option();
/* 219 */         option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 220 */         option.setCacheModeLocal(this.localWritesOnly);
/* 221 */         this.cache.getInvocationContext().setOptionOverrides(option);
/* 222 */         this.cache.removeNode(new Fqn(this.regionFqn, new Object[] { key }));
/*     */       }
/*     */       else {
/* 225 */         log.trace("skipping remove() call as the underlying node did not seem to exist");
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 229 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clear() throws CacheException {
/*     */     try {
/* 235 */       Option option = new Option();
/* 236 */       option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 237 */       option.setCacheModeLocal(this.localWritesOnly);
/* 238 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 239 */       this.cache.removeNode(this.regionFqn);
/*     */     }
/*     */     catch (Exception e) {
/* 242 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy() throws CacheException {
/*     */     try {
/* 248 */       Option option = new Option();
/* 249 */       option.setCacheModeLocal(true);
/* 250 */       option.setFailSilently(true);
/* 251 */       option.setDataVersion(NonLockingDataVersion.INSTANCE);
/* 252 */       this.cache.getInvocationContext().setOptionOverrides(option);
/* 253 */       this.cache.removeNode(this.regionFqn);
/*     */ 
/* 255 */       if ((this.cache.getConfiguration().isUseRegionBasedMarshalling()) && (!isSharedClassLoaderRegion(this.regionName)))
/*     */       {
/* 258 */         inactivateCacheRegion();
/*     */       }
/*     */     }
/*     */     catch (Exception e) {
/* 262 */       throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void lock(Object key) throws CacheException {
/* 267 */     throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
/*     */   }
/*     */ 
/*     */   public void unlock(Object key) throws CacheException {
/* 271 */     throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
/*     */   }
/*     */ 
/*     */   public long nextTimestamp() {
/* 275 */     return System.currentTimeMillis() / 100L;
/*     */   }
/*     */ 
/*     */   public int getTimeout() {
/* 279 */     return 600;
/*     */   }
/*     */ 
/*     */   public String getRegionName() {
/* 283 */     return this.regionName;
/*     */   }
/*     */ 
/*     */   public long getSizeInMemory() {
/* 287 */     return -1L;
/*     */   }
/*     */ 
/*     */   public long getElementCountInMemory() {
/*     */     try {
/* 292 */       Set children = getChildrenNames();
/* 293 */       return children.size();
/*     */     } catch (Exception e) {
/*     */     }
/* 296 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public long getElementCountOnDisk()
/*     */   {
/* 301 */     return 0L;
/*     */   }
/*     */ 
/*     */   public Map toMap() {
/*     */     try {
/* 306 */       Map result = new HashMap();
/* 307 */       Set childrenNames = getChildrenNames();
/* 308 */       if (childrenNames != null) {
/* 309 */         Iterator iter = childrenNames.iterator();
/* 310 */         while (iter.hasNext()) {
/* 311 */           Object key = iter.next();
/* 312 */           result.put(key, this.cache.get(new Fqn(this.regionFqn, new Object[] { key }), "item"));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 318 */       return result;
/*     */     } catch (Exception e) {
/*     */     }
/* 321 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   private Set getChildrenNames()
/*     */   {
/*     */     try
/*     */     {
/* 328 */       Node base = this.cache.getRoot().getChild(this.regionFqn);
/* 329 */       return base == null ? null : base.getChildrenNames();
/*     */     } catch (Exception e) {
/*     */     }
/* 332 */     throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 337 */     return "OptimisticTreeCache(" + this.regionName + ')';
/*     */   }
/*     */ 
/*     */   private boolean isSharedClassLoaderRegion(String regionName)
/*     */   {
/* 342 */     return (StandardQueryCache.class.getName().equals(regionName)) || (UpdateTimestampsCache.class.getName().equals(regionName));
/*     */   }
/*     */ 
/*     */   private void activateCacheRegion(String regionName)
/*     */     throws CacheException
/*     */   {
/* 348 */     Region region = this.cache.getRegion(this.regionFqn, true);
/* 349 */     if (!region.isActive())
/*     */     {
/*     */       try
/*     */       {
/* 355 */         if (!isSharedClassLoaderRegion(regionName))
/*     */         {
/* 357 */           region.registerContextClassLoader(Thread.currentThread().getContextClassLoader());
/*     */         }
/* 359 */         region.activate();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 363 */         throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void inactivateCacheRegion() throws CacheException
/*     */   {
/* 370 */     Region region = this.cache.getRegion(this.regionFqn, false);
/* 371 */     if ((region != null) && (region.isActive()))
/*     */     {
/*     */       try
/*     */       {
/* 375 */         region.deactivate();
/* 376 */         region.unregisterContextClassLoader();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 380 */         throw SecondLevelCacheUtil.convertToHibernateException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class CircumventChecksDataVersion
/*     */     implements DataVersion
/*     */   {
/*     */     private static final long serialVersionUID = 7996980646166032369L;
/* 475 */     public static final DataVersion INSTANCE = new CircumventChecksDataVersion();
/*     */ 
/* 477 */     public boolean newerThan(DataVersion dataVersion) { throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class NonLockingDataVersion
/*     */     implements DataVersion
/*     */   {
/*     */     private static final long serialVersionUID = 7050722490368630553L;
/* 460 */     public static final DataVersion INSTANCE = new NonLockingDataVersion();
/*     */ 
/* 462 */     public boolean newerThan(DataVersion dataVersion) { OptimisticJBCCache.log.trace("non locking lock check...");
/* 463 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class DataVersionAdapter
/*     */     implements DataVersion
/*     */   {
/*     */     private static final long serialVersionUID = 5564692336076405571L;
/*     */     private final Object currentVersion;
/*     */     private final Object previousVersion;
/*     */     private final Comparator versionComparator;
/*     */     private final String sourceIdentifer;
/*     */ 
/*     */     public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator, String sourceIdentifer)
/*     */     {
/* 394 */       this.currentVersion = currentVersion;
/* 395 */       this.previousVersion = previousVersion;
/* 396 */       this.versionComparator = versionComparator;
/* 397 */       this.sourceIdentifer = sourceIdentifer;
/* 398 */       OptimisticJBCCache.log.trace("created " + this);
/*     */     }
/*     */ 
/*     */     public boolean newerThan(DataVersion dataVersion)
/*     */     {
/* 414 */       OptimisticJBCCache.log.trace("checking [" + this + "] against [" + dataVersion + "]");
/* 415 */       if ((dataVersion instanceof OptimisticJBCCache.CircumventChecksDataVersion)) {
/* 416 */         OptimisticJBCCache.log.trace("skipping lock checks...");
/* 417 */         return false;
/*     */       }
/* 419 */       if ((dataVersion instanceof OptimisticJBCCache.NonLockingDataVersion))
/*     */       {
/* 422 */         OptimisticJBCCache.log.trace("skipping lock checks...");
/* 423 */         return false;
/*     */       }
/* 425 */       DataVersionAdapter other = (DataVersionAdapter)dataVersion;
/* 426 */       if (other.previousVersion == null) {
/* 427 */         OptimisticJBCCache.log.warn("Unexpected optimistic lock check on inserting data");
/*     */ 
/* 430 */         if (this == dataVersion) {
/* 431 */           OptimisticJBCCache.log.trace("skipping lock checks due to same DV instance");
/* 432 */           return false;
/*     */         }
/*     */       }
/*     */ 
/* 436 */       if (this.currentVersion == null)
/*     */       {
/* 441 */         return other.previousVersion != null;
/*     */       }
/*     */ 
/* 444 */       return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 448 */       return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.OptimisticJBCCache
 * JD-Core Version:    0.6.0
 */