/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.persistence.EntityManager;
/*     */ import javax.persistence.EntityManagerFactory;
/*     */ import javax.persistence.TransactionRequiredException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.ejb3.ThreadLocalStack;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.tm.TxUtils;
/*     */ 
/*     */ public class ManagedEntityManagerFactory
/*     */ {
/*  48 */   private static final Logger log = Logger.getLogger(ManagedEntityManagerFactory.class);
/*     */   protected EntityManagerFactory entityManagerFactory;
/*  51 */   protected TransactionLocal session = new TransactionLocal(TxUtil.getTransactionManager());
/*     */   protected String kernelName;
/*  54 */   public static ThreadLocalStack<Map> nonTxStack = new ThreadLocalStack();
/*     */ 
/* 143 */   public static ThreadLocal longLivedSession = new ThreadLocal();
/*     */ 
/*     */   public EntityManager getNonTxEntityManager()
/*     */   {
/*  58 */     Map map = (Map)nonTxStack.get();
/*     */ 
/*  60 */     EntityManager em = null;
/*  61 */     if (map != null) {
/*  62 */       em = (EntityManager)map.get(this);
/*     */     }
/*     */     else {
/*  65 */       map = new HashMap();
/*  66 */       nonTxStack.push(map);
/*     */     }
/*     */ 
/*  69 */     if (em == null)
/*     */     {
/*  71 */       em = this.entityManagerFactory.createEntityManager();
/*  72 */       map.put(this, em);
/*     */     }
/*  74 */     return em;
/*     */   }
/*     */ 
/*     */   public ManagedEntityManagerFactory(EntityManagerFactory sf, String kernelName)
/*     */   {
/*  79 */     this.entityManagerFactory = sf;
/*  80 */     this.kernelName = kernelName;
/*     */   }
/*     */ 
/*     */   public EntityManagerFactory getEntityManagerFactory()
/*     */   {
/*  85 */     return this.entityManagerFactory;
/*     */   }
/*     */ 
/*     */   public String getKernelName()
/*     */   {
/*  90 */     return this.kernelName;
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*  95 */     this.entityManagerFactory.close();
/*     */   }
/*     */ 
/*     */   public TransactionLocal getTransactionSession()
/*     */   {
/* 147 */     return this.session;
/*     */   }
/*     */ 
/*     */   public void registerExtendedWithTransaction(EntityManager pc)
/*     */   {
/* 152 */     pc.joinTransaction();
/* 153 */     this.session.set(pc);
/*     */   }
/*     */ 
/*     */   public void verifyInTx()
/*     */   {
/* 158 */     Transaction tx = this.session.getTransaction();
/* 159 */     if ((tx == null) || (!TxUtils.isActive(tx))) throw new TransactionRequiredException("EntityManager must be access within a transaction");
/* 160 */     if (!TxUtils.isActive(tx))
/* 161 */       throw new TransactionRequiredException("Transaction must be active to access EntityManager");
/*     */   }
/*     */ 
/*     */   public boolean isInTx() {
/* 165 */     Transaction tx = this.session.getTransaction();
/* 166 */     return (tx != null) && (TxUtils.isActive(tx));
/*     */   }
/*     */ 
/*     */   public EntityManager getTransactionScopedEntityManager()
/*     */   {
/* 172 */     Transaction tx = this.session.getTransaction();
/* 173 */     if ((tx == null) || (!TxUtils.isActive(tx))) return getNonTxEntityManager();
/*     */ 
/* 175 */     EntityManager rtnSession = (EntityManager)this.session.get();
/* 176 */     if (rtnSession == null)
/*     */     {
/* 178 */       rtnSession = createEntityManager();
/*     */       try
/*     */       {
/* 181 */         tx.registerSynchronization(new SessionSynchronization(rtnSession, tx, true));
/*     */       }
/*     */       catch (RollbackException e)
/*     */       {
/* 185 */         throw new RuntimeException(e);
/*     */       }
/*     */       catch (SystemException e)
/*     */       {
/* 189 */         throw new RuntimeException(e);
/*     */       }
/* 191 */       this.session.set(rtnSession);
/* 192 */       rtnSession.joinTransaction();
/*     */     }
/* 194 */     return rtnSession;
/*     */   }
/*     */ 
/*     */   public EntityManager createEntityManager()
/*     */   {
/* 199 */     return this.entityManagerFactory.createEntityManager();
/*     */   }
/*     */ 
/*     */   private static class SessionSynchronization
/*     */     implements Synchronization
/*     */   {
/*     */     private EntityManager manager;
/*     */     private Transaction tx;
/*     */     private boolean closeAtTxCompletion;
/*     */ 
/*     */     public SessionSynchronization(EntityManager session, Transaction tx, boolean close)
/*     */     {
/* 106 */       this.manager = session;
/* 107 */       this.tx = tx;
/* 108 */       this.closeAtTxCompletion = close;
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int status)
/*     */     {
/* 135 */       if (this.closeAtTxCompletion)
/*     */       {
/* 137 */         ManagedEntityManagerFactory.log.debug("************** closing entity managersession **************");
/* 138 */         this.manager.close();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.ManagedEntityManagerFactory
 * JD-Core Version:    0.6.0
 */