/*    */ package org.jboss.ejb3.entity;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import java.util.Map;
/*    */ import javax.persistence.EntityManager;
/*    */ import javax.persistence.EntityManagerFactory;
/*    */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*    */ 
/*    */ public class InjectedEntityManagerFactory
/*    */   implements EntityManagerFactory, Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = -3734435119658196788L;
/*    */   private transient EntityManagerFactory delegate;
/*    */   private transient ManagedEntityManagerFactory managedFactory;
/*    */ 
/*    */   public InjectedEntityManagerFactory()
/*    */   {
/*    */   }
/*    */ 
/*    */   public InjectedEntityManagerFactory(ManagedEntityManagerFactory managedFactory)
/*    */   {
/* 50 */     assert (managedFactory != null) : "managedFactory is null";
/*    */ 
/* 52 */     this.delegate = managedFactory.getEntityManagerFactory();
/* 53 */     this.managedFactory = managedFactory;
/*    */   }
/*    */ 
/*    */   public EntityManagerFactory getDelegate()
/*    */   {
/* 59 */     return this.delegate;
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out) throws IOException
/*    */   {
/* 64 */     out.writeUTF(this.managedFactory.getKernelName());
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 69 */     String kernelName = in.readUTF();
/* 70 */     PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
/* 71 */     if (deployment == null) throw new IOException("Unable to find persistence unit in registry: " + kernelName);
/* 72 */     this.managedFactory = deployment.getManagedFactory();
/* 73 */     this.delegate = this.managedFactory.getEntityManagerFactory();
/*    */   }
/*    */ 
/*    */   public EntityManager createEntityManager()
/*    */   {
/* 78 */     return getDelegate().createEntityManager();
/*    */   }
/*    */ 
/*    */   public EntityManager createEntityManager(Map map)
/*    */   {
/* 83 */     return this.delegate.createEntityManager(map);
/*    */   }
/*    */ 
/*    */   public EntityManager getEntityManager()
/*    */   {
/* 89 */     return new TransactionScopedEntityManager(this.managedFactory);
/*    */   }
/*    */ 
/*    */   public void close()
/*    */   {
/* 94 */     throw new IllegalStateException("It is illegal to close an injected EntityManagerFactory");
/*    */   }
/*    */ 
/*    */   public boolean isOpen()
/*    */   {
/* 99 */     return getDelegate().isOpen();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.InjectedEntityManagerFactory
 * JD-Core Version:    0.6.0
 */