/*     */ package org.jboss.ejb3.embedded.resource;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Timer;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MBeanParameterInfo;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ import javax.resource.spi.ActivationSpec;
/*     */ import javax.resource.spi.BootstrapContext;
/*     */ import javax.resource.spi.ResourceAdapter;
/*     */ import javax.resource.spi.UnavailableException;
/*     */ import javax.resource.spi.XATerminator;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.resource.spi.work.WorkManager;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.resource.deployment.ActivationSpecFactory;
/*     */ import org.jboss.resource.deployment.ResourceAdapterFactory;
/*     */ import org.jboss.resource.metadata.AuthenticationMechanismMetaData;
/*     */ import org.jboss.resource.metadata.ConfigPropertyMetaData;
/*     */ import org.jboss.resource.metadata.ConnectorMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionGroupMetaData;
/*     */ import org.jboss.resource.metadata.DescriptionMetaData;
/*     */ import org.jboss.resource.metadata.LicenseMetaData;
/*     */ import org.jboss.resource.metadata.MessageListenerMetaData;
/*     */ 
/*     */ public class RARDeployment
/*     */   implements BootstrapContext
/*     */ {
/*  61 */   private static final Logger log = Logger.getLogger(RARDeployment.class);
/*     */   protected DeploymentInfo di;
/*     */   protected WorkManager workManager;
/*     */   protected XATerminator xaTerminator;
/*     */   protected ConnectorMetaData cmd;
/*     */   protected ResourceAdapter resourceAdapter;
/*     */   protected ObjectName serviceName;
/*     */ 
/*     */   public RARDeployment(DeploymentInfo di)
/*     */     throws Exception
/*     */   {
/*  87 */     this.di = di;
/*  88 */     this.cmd = ((ConnectorMetaData)di.metaData);
/*     */ 
/*  90 */     this.resourceAdapter = ResourceAdapterFactory.createResourceAdapter(this.cmd);
/*  91 */     this.resourceAdapter.start(this);
/*     */   }
/*     */ 
/*     */   public ObjectName getServiceName()
/*     */   {
/*  98 */     return this.serviceName;
/*     */   }
/*     */ 
/*     */   public void setServiceName(ObjectName serviceName)
/*     */   {
/* 103 */     this.serviceName = serviceName;
/*     */   }
/*     */ 
/*     */   public Timer createTimer() throws UnavailableException
/*     */   {
/* 108 */     return new Timer(true);
/*     */   }
/*     */ 
/*     */   public WorkManager getWorkManager()
/*     */   {
/* 113 */     return this.workManager;
/*     */   }
/*     */ 
/*     */   public void setWorkManager(WorkManager workManager)
/*     */   {
/* 118 */     this.workManager = workManager;
/*     */   }
/*     */ 
/*     */   public XATerminator getXATerminator()
/*     */   {
/* 123 */     return this.xaTerminator;
/*     */   }
/*     */ 
/*     */   public void setXATerminator(XATerminator xaTerminator)
/*     */   {
/* 128 */     this.xaTerminator = xaTerminator;
/*     */   }
/*     */ 
/*     */   protected String getInternalDescription()
/*     */   {
/* 133 */     String description = null;
/* 134 */     DescriptionGroupMetaData dgmd = this.cmd.getDescription();
/* 135 */     if (dgmd != null)
/* 136 */       description = dgmd.getDescription();
/* 137 */     if (description == null)
/* 138 */       description = "RAR Deployment " + this.di.url;
/* 139 */     return description;
/*     */   }
/*     */ 
/*     */   protected MBeanAttributeInfo[] getInternalAttributeInfo()
/*     */   {
/* 144 */     Collection properties = this.cmd.getProperties();
/* 145 */     MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[11 + properties.size()];
/* 146 */     attrs[0] = new MBeanAttributeInfo("MetaData", ConnectorMetaData.class.getName(), "The meta data", true, false, false);
/* 147 */     attrs[1] = new MBeanAttributeInfo("AuthenticationMechanism", String.class.getName(), "The authentication mechanism", true, false, false);
/* 148 */     attrs[2] = new MBeanAttributeInfo("EISType", String.class.getName(), "The EIS type", true, false, false);
/* 149 */     attrs[3] = new MBeanAttributeInfo("License", String.class.getName(), "The license", true, false, false);
/* 150 */     attrs[4] = new MBeanAttributeInfo("RAClass", String.class.getName(), "The resource adapter class", true, false, false);
/* 151 */     attrs[5] = new MBeanAttributeInfo("RAVersion", String.class.getName(), "The resource adapter version", true, false, false);
/* 152 */     attrs[6] = new MBeanAttributeInfo("TransactionSupport", String.class.getName(), "The transaction support", true, false, false);
/* 153 */     attrs[7] = new MBeanAttributeInfo("VendorName", String.class.getName(), "The vendor name", true, false, false);
/* 154 */     attrs[8] = new MBeanAttributeInfo("Version", String.class.getName(), "The spec version", true, false, false);
/* 155 */     attrs[9] = new MBeanAttributeInfo("ReauthenticationSupport", Boolean.TYPE.getName(), "Whether reauthentication support is supported", true, false, false);
/* 156 */     attrs[10] = new MBeanAttributeInfo("ResourceAdapter", ResourceAdapter.class.getName(), "The resource adapter instance", true, false, false);
/* 157 */     int n = 11;
/* 158 */     for (Iterator i = properties.iterator(); i.hasNext(); )
/*     */     {
/* 160 */       ConfigPropertyMetaData cpmd = (ConfigPropertyMetaData)i.next();
/* 161 */       attrs[(n++)] = new MBeanAttributeInfo(cpmd.getName(), cpmd.getType(), cpmd.getDescription().getDescription(), true, false, false);
/*     */     }
/* 163 */     return attrs;
/*     */   }
/*     */ 
/*     */   protected Object getInternalAttribute(String attribute)
/*     */     throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 169 */     if ("MetaData".equals(attribute))
/* 170 */       return this.cmd;
/* 171 */     if ("AuthenticationMechanism".equals(attribute))
/* 172 */       return this.cmd.getAuthenticationMechanism().getAuthenticationMechansimType();
/* 173 */     if ("EISType".equals(attribute))
/* 174 */       return this.cmd.getEISType();
/* 175 */     if ("License".equals(attribute))
/* 176 */       return this.cmd.getLicense().getDescription().getDescription();
/* 177 */     if ("RAClass".equals(attribute))
/* 178 */       return this.cmd.getRAClass();
/* 179 */     if ("RAVersion".equals(attribute))
/* 180 */       return this.cmd.getRAVersion();
/* 181 */     if ("TransactionSupport".equals(attribute))
/* 182 */       return this.cmd.getTransactionSupport();
/* 183 */     if ("VendorName".equals(attribute))
/* 184 */       return this.cmd.getVendorName();
/* 185 */     if ("Version".equals(attribute))
/* 186 */       return this.cmd.getVersion();
/* 187 */     if ("ReauthenticationSupport".equals(attribute))
/* 188 */       return new Boolean(this.cmd.getReauthenticationSupport());
/* 189 */     if ("ResourceAdapter".equals(attribute))
/* 190 */       return this.resourceAdapter;
/* 191 */     Object property = this.cmd.getProperty(attribute);
/* 192 */     if (property != null) {
/* 193 */       return property;
/*     */     }
/* 195 */     return null;
/*     */   }
/*     */ 
/*     */   protected MBeanOperationInfo[] getInternalOperationInfo()
/*     */   {
/* 200 */     MBeanOperationInfo[] ops = new MBeanOperationInfo[3];
/*     */ 
/* 202 */     MBeanParameterInfo[] createActivationSpecParams = { new MBeanParameterInfo("MessagingType", Class.class.getName(), "The type of the message listener"), new MBeanParameterInfo("ActivationConfig", Collection.class.getName(), "A collection of activation config properties") };
/*     */ 
/* 207 */     ops[0] = new MBeanOperationInfo("createActivationSpec", "Create an activation spec", createActivationSpecParams, ActivationSpec.class.getName(), 1);
/*     */ 
/* 210 */     MBeanParameterInfo[] activationParams = { new MBeanParameterInfo("MessageEndpointFactory", MessageEndpointFactory.class.getName(), "The message endpoint factory"), new MBeanParameterInfo("ActivationSpec", ActivationSpec.class.getName(), "The activation spec") };
/*     */ 
/* 215 */     ops[1] = new MBeanOperationInfo("endpointActivation", "Active the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 217 */     ops[2] = new MBeanOperationInfo("endpointDeactivation", "Deactive the endpoint", activationParams, Void.class.getName(), 1);
/*     */ 
/* 220 */     return ops;
/*     */   }
/*     */ 
/*     */   public Object invoke(String actionName, Object[] params, String[] signature)
/*     */     throws MBeanException, ReflectionException
/*     */   {
/* 226 */     Object result = null;
/* 227 */     if ("createActivationSpec".equals(actionName))
/*     */     {
/* 229 */       if (params.length != 2)
/* 230 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 231 */       Class messagingType = (Class)params[0];
/* 232 */       Collection activationConfig = (Collection)params[1];
/* 233 */       result = createActivationSpec(messagingType, activationConfig);
/*     */     }
/* 235 */     else if ("endpointActivation".equals(actionName))
/*     */     {
/* 237 */       if (params.length != 2)
/* 238 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 239 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 240 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 241 */       endpointActivation(messageEndpointFactory, activationSpec);
/*     */     }
/* 243 */     else if ("endpointDeactivation".equals(actionName))
/*     */     {
/* 245 */       if (params.length != 2)
/* 246 */         throw new IllegalArgumentException("Wrong number of parameters for " + actionName);
/* 247 */       MessageEndpointFactory messageEndpointFactory = (MessageEndpointFactory)params[0];
/* 248 */       ActivationSpec activationSpec = (ActivationSpec)params[1];
/* 249 */       endpointDeactivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */ 
/* 252 */     return result;
/*     */   }
/*     */ 
/*     */   protected ActivationSpec createActivationSpec(Class messagingType, Collection activationConfig) throws MBeanException
/*     */   {
/* 257 */     boolean trace = log.isTraceEnabled();
/* 258 */     if (trace) {
/* 259 */       log.trace("CreateActivateSpec rar=" + getServiceName() + " messagingType=" + messagingType.getName() + " activationConfig=" + activationConfig);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 264 */       MessageListenerMetaData mlmd = this.cmd.getMessageListener(messagingType.getName());
/* 265 */       if (mlmd == null) {
/* 266 */         throw new DeploymentException("MessagingType '" + messagingType.getName() + "' not found in resource deployment " + getServiceName());
/*     */       }
/* 268 */       return ActivationSpecFactory.createActivationSpec(getServiceName(), messagingType.getName(), activationConfig, mlmd);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 272 */     throw new MBeanException(e, "Error in create activation spec " + getServiceName());
/*     */   }
/*     */ 
/*     */   protected void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec)
/*     */     throws MBeanException
/*     */   {
/* 278 */     boolean trace = log.isTraceEnabled();
/* 279 */     if (trace) {
/* 280 */       log.trace("EndpointActivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 284 */       activationSpec.setResourceAdapter(this.resourceAdapter);
/* 285 */       this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 289 */       throw new MBeanException(e, "Error in endpoint activation " + getServiceName());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws MBeanException
/*     */   {
/* 295 */     boolean trace = log.isTraceEnabled();
/* 296 */     if (trace) {
/* 297 */       log.trace("EndpointDeactivation rar=" + getServiceName() + " messagingEndpointFactory=" + messageEndpointFactory + " activationSpec=" + activationSpec);
/*     */     }
/*     */     try
/*     */     {
/* 301 */       this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 305 */       throw new MBeanException(e, "Error in endpoint deactivation " + getServiceName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.resource.RARDeployment
 * JD-Core Version:    0.6.0
 */