/*    */ package org.jboss.ejb3.deployers;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.security.jacc.PolicyConfiguration;
/*    */ import org.jboss.ejb3.DependencyPolicy;
/*    */ import org.jboss.ejb3.DeploymentScope;
/*    */ import org.jboss.ejb3.Ejb3Deployment;
/*    */ import org.jboss.ejb3.MCKernelAbstraction;
/*    */ import org.jboss.ejb3.javaee.JavaEEComponent;
/*    */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
/*    */ import org.jboss.ejb3.security.JaccHelper;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*    */ 
/*    */ public class Ejb3JBoss5Deployment extends Ejb3Deployment
/*    */ {
/* 48 */   private static final Logger log = Logger.getLogger(Ejb3JBoss5Deployment.class);
/*    */   private org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit;
/*    */ 
/*    */   public Ejb3JBoss5Deployment(org.jboss.ejb3.DeploymentUnit ejb3Unit, Kernel kernel, MBeanServer mbeanServer, org.jboss.deployers.structure.spi.DeploymentUnit jbossUnit, DeploymentScope deploymentScope, JBossMetaData metaData, PersistenceUnitsMetaData persistenceUnitsMetaData, Ejb3Deployer deployer)
/*    */   {
/* 54 */     super(ejb3Unit, deploymentScope, metaData, persistenceUnitsMetaData, deployer);
/* 55 */     this.jbossUnit = jbossUnit;
/* 56 */     this.kernelAbstraction = new MCKernelAbstraction(kernel, mbeanServer);
/*    */ 
/* 59 */     this.mbeanServer = mbeanServer;
/*    */   }
/*    */ 
/*    */   protected PolicyConfiguration createPolicyConfiguration() throws Exception
/*    */   {
/* 64 */     return JaccHelper.initialiseJacc(getJaccContextId());
/*    */   }
/*    */ 
/*    */   protected void putJaccInService(PolicyConfiguration pc, org.jboss.ejb3.DeploymentUnit ejb3Unit)
/*    */   {
/*    */     try
/*    */     {
/* 71 */       JaccHelper.putJaccInService(pc, this.jbossUnit);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 75 */       throw new RuntimeException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public DependencyPolicy createDependencyPolicy(JavaEEComponent component)
/*    */   {
/* 81 */     return new JBoss5DependencyPolicy(component);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.Ejb3JBoss5Deployment
 * JD-Core Version:    0.6.0
 */