/*     */ package org.jboss.ejb3.client;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.annotation.PostConstruct;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NameClassPair;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.DependencyPolicy;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ import org.jboss.injection.DependsHandler;
/*     */ import org.jboss.injection.EJBInjectionHandler;
/*     */ import org.jboss.injection.EncInjector;
/*     */ import org.jboss.injection.InjectionContainer;
/*     */ import org.jboss.injection.InjectionHandler;
/*     */ import org.jboss.injection.InjectionUtil;
/*     */ import org.jboss.injection.Injector;
/*     */ import org.jboss.injection.JndiInjectHandler;
/*     */ import org.jboss.injection.PersistenceUnitHandler;
/*     */ import org.jboss.injection.ResourceHandler;
/*     */ import org.jboss.injection.WebServiceRefHandler;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
/*     */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ClientContainer
/*     */   implements InjectionContainer
/*     */ {
/*  75 */   private static final Logger log = Logger.getLogger(ClientContainer.class);
/*     */   private Class<?> mainClass;
/*     */   private JBossClientMetaData xml;
/*     */   private String applicationClientName;
/*  82 */   private List<Injector> injectors = new ArrayList();
/*  83 */   private Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap();
/*  84 */   private Map<String, EncInjector> encInjectors = new HashMap();
/*     */   private Context enc;
/*     */   private Context encEnv;
/*  89 */   private List<Method> postConstructs = new ArrayList();
/*     */ 
/*     */   public ClientContainer(JBossClientMetaData xml, Class<?> mainClass, String applicationClientName) throws Exception
/*     */   {
/*  93 */     this.xml = xml;
/*  94 */     this.mainClass = mainClass;
/*  95 */     this.applicationClientName = applicationClientName;
/*     */ 
/*  98 */     Context ctx = InitialContextFactory.getInitialContext();
/*  99 */     this.enc = ((Context)ctx.lookup(applicationClientName));
/* 100 */     log.debug("Client ENC(" + applicationClientName + "):");
/* 101 */     NamingEnumeration e = this.enc.list("");
/* 102 */     while (e.hasMore())
/*     */     {
/* 104 */       NameClassPair ncp = (NameClassPair)e.next();
/* 105 */       log.debug("  " + ncp);
/*     */     }
/*     */ 
/* 111 */     processMetadata(null);
/*     */ 
/* 113 */     for (EncInjector injector : this.encInjectors.values())
/*     */     {
/* 115 */       log.trace("encInjector: " + injector);
/*     */     }
/*     */ 
/* 119 */     for (Injector injector : this.injectors)
/*     */     {
/* 121 */       log.trace("injector: " + injector);
/* 122 */       injector.inject((Object)null);
/*     */     }
/*     */ 
/* 125 */     postConstruct();
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz)
/*     */   {
/* 133 */     return clazz.getAnnotation(annotationClass);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Method method)
/*     */   {
/* 141 */     return method.getAnnotation(annotationClass);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method method)
/*     */   {
/* 149 */     return method.getAnnotation(annotationClass);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Class<?> clazz, Field field)
/*     */   {
/* 157 */     return field.getAnnotation(annotationClass);
/*     */   }
/*     */ 
/*     */   public <T extends Annotation> T getAnnotation(Class<T> annotationClass, Field field)
/*     */   {
/* 165 */     return field.getAnnotation(annotationClass);
/*     */   }
/*     */ 
/*     */   public ClassLoader getClassloader()
/*     */   {
/* 174 */     return Thread.currentThread().getContextClassLoader();
/*     */   }
/*     */ 
/*     */   public DependencyPolicy getDependencyPolicy()
/*     */   {
/* 182 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public String getDeploymentDescriptorType()
/*     */   {
/* 190 */     return "application-client.xml";
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(Class businessInterface)
/*     */     throws NameNotFoundException
/*     */   {
/* 198 */     throw new RuntimeException("NYI");
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(String link, Class<?> businessInterface)
/*     */   {
/* 207 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Context getEnc()
/*     */   {
/* 218 */     return this.enc;
/*     */   }
/*     */ 
/*     */   public Map<String, Map<AccessibleObject, Injector>> getEncInjections()
/*     */   {
/* 226 */     return this.encInjections;
/*     */   }
/*     */ 
/*     */   public Map<String, EncInjector> getEncInjectors()
/*     */   {
/* 234 */     return this.encInjectors;
/*     */   }
/*     */ 
/*     */   public RemoteEnvironment getEnvironmentRefGroup()
/*     */   {
/* 242 */     return this.xml;
/*     */   }
/*     */ 
/*     */   public String getIdentifier()
/*     */   {
/* 253 */     return this.applicationClientName;
/*     */   }
/*     */ 
/*     */   public List<Injector> getInjectors()
/*     */   {
/* 261 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public Class<?> getMainClass()
/*     */   {
/* 266 */     return this.mainClass;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName)
/*     */     throws NameNotFoundException
/*     */   {
/* 274 */     throw new NotImplementedException();
/*     */   }
/*     */ 
/*     */   public boolean hasJNDIBinding(String jndiName)
/*     */   {
/* 279 */     return false;
/*     */   }
/*     */ 
/*     */   public void invokeMain(String[] args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException
/*     */   {
/* 284 */     Class[] parameterTypes = { args.getClass() };
/* 285 */     Method method = this.mainClass.getDeclaredMethod("main", parameterTypes);
/* 286 */     method.invoke(null, new Object[] { args });
/*     */   }
/*     */ 
/*     */   private void postConstruct()
/*     */     throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException
/*     */   {
/* 299 */     log.info("postConstructs = " + this.postConstructs);
/* 300 */     for (Method method : this.postConstructs)
/*     */     {
/* 302 */       method.setAccessible(true);
/*     */       Object instance;
/*     */       Object instance;
/* 304 */       if (Modifier.isStatic(method.getModifiers()))
/* 305 */         instance = null;
/*     */       else
/* 307 */         instance = method.getDeclaringClass().newInstance();
/* 308 */       Object[] args = null;
/* 309 */       method.invoke(instance, args);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processMetadata(DependencyPolicy dependencyPolicy) throws Exception
/*     */   {
/* 315 */     log.debug("processMetadata");
/* 316 */     processPostConstructs();
/*     */ 
/* 319 */     Collection handlers = new ArrayList();
/* 320 */     handlers.add(new EJBInjectionHandler());
/*     */ 
/* 322 */     handlers.add(new DependsHandler());
/* 323 */     handlers.add(new JndiInjectHandler());
/* 324 */     handlers.add(new PersistenceUnitHandler());
/*     */ 
/* 326 */     handlers.add(new ResourceHandler(false));
/* 327 */     handlers.add(new WebServiceRefHandler());
/*     */     try
/*     */     {
/* 335 */       InjectionHandler handler;
/* 335 */       for (Iterator i$ = handlers.iterator(); i$.hasNext(); handler.loadXml(this.xml, this)) handler = (InjectionHandler)i$.next();
/*     */ 
/* 337 */       Map tmp = InjectionUtil.processAnnotations(this, handlers, getMainClass());
/* 338 */       this.injectors.addAll(tmp.values());
/*     */     }
/*     */     finally
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processPostConstructs()
/*     */     throws ClassNotFoundException, SecurityException, NoSuchMethodException
/*     */   {
/* 370 */     processPostConstructs(this.mainClass);
/*     */ 
/* 372 */     LifecycleCallbacksMetaData callbacks = this.xml.getPostConstructs();
/* 373 */     if (callbacks != null)
/*     */     {
/* 375 */       for (LifecycleCallbackMetaData callback : callbacks)
/*     */       {
/* 377 */         String className = callback.getClassName();
/* 378 */         String methodName = callback.getMethodName();
/*     */         Class lifecycleClass;
/*     */         Class lifecycleClass;
/* 380 */         if (className == null)
/* 381 */           lifecycleClass = this.mainClass;
/*     */         else
/* 383 */           lifecycleClass = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 384 */         Class[] parameterTypes = new Class[0];
/* 385 */         Method method = lifecycleClass.getDeclaredMethod(methodName, parameterTypes);
/* 386 */         this.postConstructs.add(method);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processPostConstructs(Class<?> cls)
/*     */   {
/* 393 */     if (cls == null) {
/* 394 */       return;
/*     */     }
/* 396 */     for (Method method : cls.getDeclaredMethods())
/*     */     {
/* 398 */       PostConstruct postConstruct = (PostConstruct)method.getAnnotation(PostConstruct.class);
/* 399 */       if (postConstruct == null)
/*     */       {
/*     */         continue;
/*     */       }
/* 403 */       if (this.postConstructs.size() > 0)
/* 404 */         throw new IllegalStateException("only one @PostConstruct allowed");
/* 405 */       this.postConstructs.add(method);
/*     */     }
/*     */ 
/* 409 */     processPostConstructs(cls.getSuperclass());
/*     */   }
/*     */ 
/*     */   public Container resolveEjbContainer(String link, Class businessIntf)
/*     */   {
/* 417 */     log.warn("resolveEjbContainer(" + link + ", " + businessIntf + ") not implemented");
/* 418 */     return null;
/*     */   }
/*     */ 
/*     */   public Container resolveEjbContainer(Class businessIntf)
/*     */     throws NameNotFoundException
/*     */   {
/* 426 */     return null;
/*     */   }
/*     */ 
/*     */   public String resolveMessageDestination(String link)
/*     */   {
/* 432 */     return null;
/*     */   }
/*     */ 
/*     */   public VirtualFile getRootFile()
/*     */   {
/* 437 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.client.ClientContainer
 * JD-Core Version:    0.6.0
 */