/*    */ package org.jboss.ejb3.cache.impl;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.ejb3.cache.grouped.PassivationGroup;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class PassivationGroupImpl
/*    */   implements PassivationGroup
/*    */ {
/* 39 */   private static final Logger log = Logger.getLogger(PassivationGroupImpl.class);
/*    */   private static final long serialVersionUID = 1L;
/* 42 */   private Object id = new GUID();
/* 43 */   private Map<Object, Object> members = new HashMap();
/* 44 */   private transient Map<Object, GroupedPassivatingCacheImpl.Entry> active = new HashMap();
/*    */ 
/*    */   void addMember(Object key, GroupedPassivatingCacheImpl.Entry entry)
/*    */   {
/* 53 */     log.trace("add member " + key + ", " + entry);
/* 54 */     this.members.put(key, entry.obj);
/* 55 */     this.active.put(key, entry);
/*    */   }
/*    */ 
/*    */   public Object getId()
/*    */   {
/* 60 */     return this.id;
/*    */   }
/*    */ 
/*    */   Object getMember(Object key)
/*    */   {
/* 65 */     return this.members.get(key);
/*    */   }
/*    */ 
/*    */   void postActivate()
/*    */   {
/*    */   }
/*    */ 
/*    */   void prePassivate()
/*    */   {
/* 75 */     for (GroupedPassivatingCacheImpl.Entry entry : this.active.values())
/*    */     {
/* 77 */       entry.passivate();
/*    */     }
/* 79 */     this.active.clear();
/*    */   }
/*    */ 
/*    */   void removeActive(Object key)
/*    */   {
/* 84 */     this.active.remove(key);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.PassivationGroupImpl
 * JD-Core Version:    0.6.0
 */