/*     */ package org.jboss.ejb3.cache.impl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.ejb.NoSuchEJBException;
/*     */ import org.jboss.ejb3.cache.Identifiable;
/*     */ import org.jboss.ejb3.cache.ObjectStore;
/*     */ import org.jboss.ejb3.cache.PassivatingCache;
/*     */ import org.jboss.ejb3.cache.PassivationManager;
/*     */ import org.jboss.ejb3.cache.StatefulObjectFactory;
/*     */ import org.jboss.ejb3.cache.grouped.GroupedPassivatingCache;
/*     */ import org.jboss.ejb3.cache.grouped.PassivationGroup;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class GroupedPassivatingCacheImpl<T extends Identifiable,  extends Serializable>
/*     */   implements GroupedPassivatingCache<T>
/*     */ {
/*     */   private static final Logger log;
/*     */   private PassivatingCache<PassivationGroup> groupCache;
/*     */   private SimplePassivatingCache<GroupedPassivatingCacheImpl<T>.Entry> delegate;
/*  52 */   private Map<Object, GroupedPassivatingCacheImpl<T>.Entry> storage = new HashMap();
/*     */ 
/*     */   public GroupedPassivatingCacheImpl(StatefulObjectFactory<T> factory, PassivationManager<T> passivationManager, ObjectStore<T> store, PassivatingCache<PassivationGroup> groupCache)
/*     */   {
/* 175 */     assert (groupCache != null) : "groupCache is null";
/* 176 */     assert (passivationManager != null) : "passivationManager is null";
/*     */ 
/* 178 */     this.groupCache = groupCache;
/* 179 */     EntryContainer container = new EntryContainer(factory, passivationManager, store);
/* 180 */     this.delegate = new SimplePassivatingCache(container, container, container);
/*     */   }
/*     */ 
/*     */   public void passivate(Object key)
/*     */   {
/* 185 */     this.delegate.passivate(key);
/*     */   }
/*     */ 
/*     */   public T create(Class<?>[] initTypes, Object[] initValues)
/*     */   {
/* 190 */     return ((Entry)this.delegate.create(initTypes, initValues)).obj;
/*     */   }
/*     */ 
/*     */   public T get(Object key) throws NoSuchEJBException
/*     */   {
/* 195 */     return ((Entry)this.delegate.get(key)).obj;
/*     */   }
/*     */ 
/*     */   public T peek(Object key) throws NoSuchEJBException
/*     */   {
/* 200 */     return ((Entry)this.delegate.peek(key)).obj;
/*     */   }
/*     */ 
/*     */   public void release(T obj)
/*     */   {
/* 205 */     this.delegate.releaseByKey(obj.getId());
/*     */   }
/*     */ 
/*     */   public void remove(Object key)
/*     */   {
/* 210 */     this.delegate.remove(key);
/*     */   }
/*     */ 
/*     */   public void setGroup(T obj, PassivationGroup group)
/*     */   {
/* 216 */     Object key = obj.getId();
/* 217 */     Entry entry = (Entry)this.delegate.peek(key);
/* 218 */     if (entry.group != null)
/* 219 */       throw new IllegalStateException("object " + key + " already associated with a passivation group");
/* 220 */     entry.group = ((PassivationGroupImpl)group);
/* 221 */     entry.groupId = group.getId();
/*     */ 
/* 223 */     entry.group.addMember(key, entry);
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 228 */     this.delegate.setName(name + "-delegate");
/*     */   }
/*     */ 
/*     */   public void setSessionTimeout(int sessionTimeout)
/*     */   {
/* 233 */     this.delegate.setSessionTimeout(sessionTimeout);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 238 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 243 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  47 */     log = Logger.getLogger(GroupedPassivatingCacheImpl.class);
/*     */   }
/*     */ 
/*     */   private class EntryContainer
/*     */     implements StatefulObjectFactory<GroupedPassivatingCacheImpl<T>.Entry>, PassivationManager<GroupedPassivatingCacheImpl<T>.Entry>, ObjectStore<GroupedPassivatingCacheImpl<T>.Entry>
/*     */   {
/*     */     private StatefulObjectFactory<T> factory;
/*     */     private PassivationManager<T> passivationManager;
/*     */     private ObjectStore<T> store;
/*     */ 
/*     */     EntryContainer(PassivationManager<T> factory, ObjectStore<T> passivationManager)
/*     */     {
/* 101 */       this.factory = factory;
/* 102 */       this.passivationManager = passivationManager;
/* 103 */       this.store = store;
/*     */     }
/*     */ 
/*     */     public GroupedPassivatingCacheImpl<T>.Entry create(Class<?>[] initTypes, Object[] initValues)
/*     */     {
/* 108 */       return new GroupedPassivatingCacheImpl.Entry(GroupedPassivatingCacheImpl.this, (Identifiable)this.factory.create(initTypes, initValues));
/*     */     }
/*     */ 
/*     */     public void destroy(GroupedPassivatingCacheImpl<T>.Entry entry)
/*     */     {
/* 113 */       this.factory.destroy(entry.obj);
/*     */     }
/*     */ 
/*     */     public GroupedPassivatingCacheImpl<T>.Entry load(Object key)
/*     */     {
/* 118 */       GroupedPassivatingCacheImpl.Entry entry = (GroupedPassivatingCacheImpl.Entry)GroupedPassivatingCacheImpl.this.storage.get(key);
/* 119 */       if (entry != null)
/*     */       {
/* 121 */         GroupedPassivatingCacheImpl.log.trace("entry = " + entry);
/* 122 */         return entry;
/*     */       }
/*     */ 
/* 125 */       Identifiable obj = this.store.load(key);
/* 126 */       if (obj == null)
/* 127 */         return null;
/* 128 */       return new GroupedPassivatingCacheImpl.Entry(GroupedPassivatingCacheImpl.this, obj);
/*     */     }
/*     */ 
/*     */     public void postActivate(GroupedPassivatingCacheImpl<T>.Entry entry)
/*     */     {
/* 134 */       GroupedPassivatingCacheImpl.log.trace("post activate " + entry);
/* 135 */       if (entry.obj == null)
/*     */       {
/* 137 */         if (entry.group == null)
/*     */         {
/* 140 */           entry.group = ((PassivationGroupImpl)GroupedPassivatingCacheImpl.this.groupCache.peek(entry.groupId));
/*     */         }
/* 142 */         entry.obj = ((Identifiable)entry.group.getMember(entry.id));
/*     */       }
/* 144 */       this.passivationManager.postActivate((Serializable)entry.obj);
/*     */     }
/*     */ 
/*     */     public void prePassivate(GroupedPassivatingCacheImpl<T>.Entry entry)
/*     */     {
/* 149 */       GroupedPassivatingCacheImpl.log.trace("pre passivate " + entry);
/* 150 */       this.passivationManager.prePassivate((Serializable)entry.obj);
/*     */ 
/* 152 */       if (entry.group != null)
/*     */       {
/* 154 */         entry.group.removeActive(entry.id);
/* 155 */         entry.group.prePassivate();
/* 156 */         GroupedPassivatingCacheImpl.this.groupCache.passivate(entry.groupId);
/*     */ 
/* 158 */         entry.group = null;
/* 159 */         entry.obj = null;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void store(GroupedPassivatingCacheImpl<T>.Entry entry)
/*     */     {
/* 165 */       GroupedPassivatingCacheImpl.log.trace("store " + entry);
/* 166 */       if (entry.groupId == null)
/* 167 */         this.store.store(entry.obj);
/*     */       else
/* 169 */         GroupedPassivatingCacheImpl.this.storage.put(entry.id, entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class Entry
/*     */     implements Identifiable, Serializable
/*     */   {
/*     */     private static final long serialVersionUID = 1L;
/*     */     Object id;
/*     */     T obj;
/*     */     PassivationGroupImpl group;
/*     */     Object groupId;
/*     */ 
/*     */     Entry()
/*     */     {
/*  65 */       assert (obj != null) : "obj is null";
/*     */ 
/*  67 */       this.obj = obj;
/*  68 */       this.id = obj.getId();
/*     */     }
/*     */ 
/*     */     public Object getId()
/*     */     {
/*  73 */       return this.id;
/*     */     }
/*     */ 
/*     */     void passivate()
/*     */     {
/*  79 */       this.group = null;
/*     */ 
/*  81 */       GroupedPassivatingCacheImpl.this.delegate.passivate(this.id);
/*     */ 
/*  83 */       this.obj = null;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/*  89 */       return super.toString() + "{id=" + this.id + ",obj=" + this.obj + ",groupId=" + this.groupId + ",group=" + this.group + "}";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.GroupedPassivatingCacheImpl
 * JD-Core Version:    0.6.0
 */