/*    */ package org.jboss.ejb3.cache;
/*    */ 
/*    */ import java.util.Map;
/*    */ 
/*    */ public class CacheFactoryRegistry
/*    */ {
/*    */   private Map<String, Class<? extends Ejb3CacheFactory>> factories;
/*    */ 
/*    */   public Map<String, Class<? extends Ejb3CacheFactory>> getFactories()
/*    */   {
/* 41 */     return this.factories;
/*    */   }
/*    */ 
/*    */   public void setFactories(Map<String, Class<? extends Ejb3CacheFactory>> factories)
/*    */   {
/* 46 */     this.factories = factories;
/*    */   }
/*    */ 
/*    */   public Ejb3CacheFactory getCacheFactory(String name)
/*    */     throws CacheFactoryNotRegisteredException
/*    */   {
/* 60 */     Class cacheFactory = (Class)this.factories.get(name);
/*    */ 
/* 63 */     if (cacheFactory == null)
/*    */     {
/* 65 */       throw new CacheFactoryNotRegisteredException("Cache Factory with name " + name + " is not registered.");
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 71 */       return (Ejb3CacheFactory)cacheFactory.newInstance();
/*    */     }
/*    */     catch (InstantiationException e)
/*    */     {
/* 75 */       throw new RuntimeException("Error in instanciating cache factory " + cacheFactory.getName(), e);
/*    */     }
/*    */     catch (IllegalAccessException e) {
/*    */     }
/* 79 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.CacheFactoryRegistry
 * JD-Core Version:    0.6.0
 */