/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.ejb.Local;
/*     */ import javax.ejb.LocalHome;
/*     */ import javax.ejb.Remote;
/*     */ import javax.ejb.RemoteHome;
/*     */ import javax.jws.WebService;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.annotation.AnnotationRepository;
/*     */ import org.jboss.ejb.LocalImpl;
/*     */ import org.jboss.ejb.RemoteImpl;
/*     */ import org.jboss.ejb3.annotation.JndiBindingPolicy;
/*     */ import org.jboss.ejb3.annotation.LocalBinding;
/*     */ import org.jboss.ejb3.annotation.LocalHomeBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.annotation.RemoteBindings;
/*     */ import org.jboss.ejb3.annotation.RemoteHomeBinding;
/*     */ import org.jboss.ejb3.jndipolicy.DefaultJndiBindingPolicy;
/*     */ import org.jboss.ejb3.jndipolicy.Ejb3DeploymentSummary;
/*     */ import org.jboss.ejb3.jndipolicy.impl.PackagingBasedJndiBindingPolicy;
/*     */ import org.jboss.ejb3.lang.ClassHelper;
/*     */ import org.jboss.ejb3.service.ServiceContainer;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.ejb3.stateful.StatefulContainer;
/*     */ import org.jboss.ejb3.stateless.StatelessContainer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ProxyFactoryHelper
/*     */ {
/*     */   private static final Logger log;
/*     */ 
/*     */   private static String getEndpointInterface(Container container)
/*     */   {
/*  73 */     WebService ws = (WebService)((EJBContainer)container).resolveAnnotation(WebService.class);
/*  74 */     if (ws != null)
/*     */     {
/*  76 */       return ws.endpointInterface();
/*     */     }
/*  78 */     return null;
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getLocalAndBusinessLocalInterfaces(Container container)
/*     */   {
/*  89 */     Set localAndBusinessLocalInterfaces = new HashSet();
/*     */ 
/*  92 */     Class beanClass = container.getBeanClass();
/*     */ 
/*  95 */     Local localAnnotation = (Local)((EJBContainer)container).getAnnotation(Local.class);
/*     */ 
/*  98 */     LocalHome localHomeAnnotation = (LocalHome)((EJBContainer)container).getAnnotation(LocalHome.class);
/*     */ 
/* 101 */     Remote remoteAnnotation = (Remote)((EJBContainer)container).getAnnotation(Remote.class);
/*     */ 
/* 104 */     Class[] remoteAndBusinessRemoteInterfaces = getRemoteAndBusinessRemoteInterfaces(container);
/*     */ 
/* 107 */     Set businessInterfacesImplementedByBeanClass = getBusinessInterfaces(beanClass);
/*     */ 
/* 110 */     Set businessInterfacesDirectlyImplementedByBeanClass = getBusinessInterfaces(beanClass, false);
/*     */ 
/* 114 */     boolean isStateless = (container instanceof StatelessContainer);
/*     */ 
/* 118 */     if (localHomeAnnotation != null)
/*     */     {
/* 120 */       localAndBusinessLocalInterfaces.addAll(getReturnTypesFromCreateMethods(localHomeAnnotation.value(), isStateless));
/*     */     }
/*     */ 
/* 125 */     for (Class clazz : businessInterfacesImplementedByBeanClass)
/*     */     {
/* 128 */       if (clazz.isAnnotationPresent(Local.class))
/*     */       {
/* 131 */         localAndBusinessLocalInterfaces.add(clazz);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 141 */     if ((businessInterfacesDirectlyImplementedByBeanClass.size() == 1) && (localAndBusinessLocalInterfaces.size() == 0))
/*     */     {
/* 144 */       Class singleInterface = (Class)businessInterfacesDirectlyImplementedByBeanClass.iterator().next();
/*     */ 
/* 147 */       if ((remoteAnnotation == null) && (singleInterface.getAnnotation(Remote.class) == null))
/*     */       {
/* 150 */         Class[] returnValue = { singleInterface };
/*     */ 
/* 152 */         Local li = new LocalImpl(returnValue);
/* 153 */         ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, li);
/* 154 */         return returnValue;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 159 */     if (localAnnotation != null)
/*     */     {
/* 162 */       if ((localAnnotation.value() == null) || (localAnnotation.value().length == 0))
/*     */       {
/* 165 */         if (businessInterfacesImplementedByBeanClass.size() == 0)
/*     */         {
/* 167 */           throw new RuntimeException("Use of empty @Local on bean " + container.getEjbName() + " and there are no valid business interfaces");
/*     */         }
/*     */ 
/* 171 */         if (businessInterfacesImplementedByBeanClass.size() > 1)
/*     */         {
/* 173 */           throw new RuntimeException("Use of empty @Local on bean " + container.getEjbName() + " with more than one default interface " + businessInterfacesImplementedByBeanClass);
/*     */         }
/*     */ 
/* 183 */         if (remoteAnnotation == null)
/*     */         {
/* 186 */           Class[] returnValue = (Class[])businessInterfacesImplementedByBeanClass.toArray(new Class[0]);
/*     */ 
/* 188 */           Local li = new LocalImpl(returnValue);
/* 189 */           ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, li);
/* 190 */           return returnValue;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 198 */         for (Class clazz : localAnnotation.value())
/*     */         {
/* 201 */           localAndBusinessLocalInterfaces.add(clazz);
/*     */         }
/*     */ 
/* 205 */         for (Class clazz : businessInterfacesImplementedByBeanClass)
/*     */         {
/* 208 */           if (clazz.isAnnotationPresent(Local.class))
/*     */           {
/* 211 */             localAndBusinessLocalInterfaces.add(clazz);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 218 */     if (localAndBusinessLocalInterfaces.size() > 0)
/*     */     {
/*     */       Class remoteInterface;
/* 222 */       for (remoteInterface : remoteAndBusinessRemoteInterfaces)
/*     */       {
/* 224 */         for (Class localInterface : localAndBusinessLocalInterfaces)
/*     */         {
/* 226 */           if (localInterface.equals(remoteInterface))
/*     */           {
/* 228 */             throw new RuntimeException("@Remote and @Local may not both be specified on the same interface \"" + remoteInterface.toString() + "\" per EJB3 Spec 4.6.7, Bullet 5.4");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 235 */       Class[] rtn = (Class[])localAndBusinessLocalInterfaces.toArray(new Class[0]);
/*     */ 
/* 237 */       localAnnotation = new LocalImpl(rtn);
/* 238 */       ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, localAnnotation);
/* 239 */       return rtn;
/*     */     }
/*     */ 
/* 245 */     String endpoint = getEndpointInterface(container);
/*     */ 
/* 248 */     if ((remoteAndBusinessRemoteInterfaces.length == 0) && (endpoint == null)) {
/* 249 */       throw new RuntimeException("Bean Class " + beanClass.getName() + " has no local, webservice, or remote interfaces defined and does not implement at least one business interface: " + container.getEjbName());
/*     */     }
/*     */ 
/* 258 */     return new Class[0];
/*     */   }
/*     */ 
/*     */   public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass)
/*     */   {
/* 276 */     return getBusinessInterfaces(beanClass, new HashSet());
/*     */   }
/*     */ 
/*     */   public static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, boolean includeSupers)
/*     */   {
/* 294 */     return getBusinessInterfaces(beanClass, new HashSet(), includeSupers);
/*     */   }
/*     */ 
/*     */   private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces)
/*     */   {
/* 299 */     return getBusinessInterfaces(beanClass, interfaces, true);
/*     */   }
/*     */ 
/*     */   private static Set<Class<?>> getBusinessInterfaces(Class<?> beanClass, Set<Class<?>> interfaces, boolean includeSupers)
/*     */   {
/* 311 */     for (Class intf : beanClass.getInterfaces())
/*     */     {
/* 313 */       if (intf.equals(Externalizable.class))
/*     */         continue;
/* 315 */       if (intf.equals(Serializable.class))
/*     */         continue;
/* 317 */       if (intf.getName().startsWith("javax.ejb"))
/*     */       {
/*     */         continue;
/*     */       }
/* 321 */       if (intf.getName().startsWith("org.jboss.aop")) {
/*     */         continue;
/*     */       }
/* 324 */       interfaces.add(intf);
/*     */     }
/*     */ 
/* 328 */     if ((!includeSupers) || (beanClass.getSuperclass() == null))
/*     */     {
/* 330 */       return interfaces;
/*     */     }
/*     */ 
/* 335 */     return getBusinessInterfaces(beanClass.getSuperclass(), interfaces);
/*     */   }
/*     */ 
/*     */   public static Class<?> getLocalHomeInterface(Container container)
/*     */   {
/* 341 */     LocalHome li = (LocalHome)((EJBContainer)container).getAnnotation(LocalHome.class);
/* 342 */     if (li != null)
/* 343 */       return li.value();
/* 344 */     return null;
/*     */   }
/*     */ 
/*     */   public static Class<?> getRemoteHomeInterface(Container container)
/*     */   {
/* 349 */     RemoteHome li = (RemoteHome)((EJBContainer)container).getAnnotation(RemoteHome.class);
/* 350 */     if (li != null)
/* 351 */       return li.value();
/* 352 */     return null;
/*     */   }
/*     */ 
/*     */   public static boolean publishesInterface(Container container, Class<?> businessInterface)
/*     */   {
/* 357 */     if (!(container instanceof SessionContainer))
/* 358 */       return false;
/* 359 */     Class[] remotes = getRemoteAndBusinessRemoteInterfaces(container);
/* 360 */     for (Class intf : remotes)
/*     */     {
/* 362 */       if (intf.getName().equals(businessInterface.getName())) {
/* 363 */         return true;
/*     */       }
/*     */     }
/* 366 */     Class remoteHome = getRemoteHomeInterface(container);
/* 367 */     if (remoteHome != null)
/*     */     {
/* 369 */       if (businessInterface.getName().equals(remoteHome.getName()))
/*     */       {
/* 371 */         return true;
/*     */       }
/*     */     }
/* 374 */     Class[] locals = getLocalAndBusinessLocalInterfaces(container);
/* 375 */     for (Class clazz : locals)
/*     */     {
/* 377 */       if (clazz.getName().equals(businessInterface.getName()))
/*     */       {
/* 379 */         return true;
/*     */       }
/*     */     }
/* 382 */     Class localHome = getLocalHomeInterface(container);
/* 383 */     if (localHome != null)
/*     */     {
/* 385 */       if (businessInterface.getName().equals(localHome.getName()))
/*     */       {
/* 387 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 391 */     return false;
/*     */   }
/*     */ 
/*     */   public static String getJndiName(Container container, Class<?> businessInterface)
/*     */   {
/* 404 */     assert (container != null) : "container is null";
/* 405 */     assert (businessInterface != null) : "businessInterface is null";
/*     */ 
/* 408 */     String jndiName = null;
/* 409 */     boolean isHome = false;
/* 410 */     boolean isLocal = false;
/*     */ 
/* 413 */     Class[] remotes = getRemoteAndBusinessRemoteInterfaces(container);
/* 414 */     for (Class clazz : remotes)
/*     */     {
/* 416 */       if (!clazz.getName().equals(businessInterface.getName())) {
/*     */         continue;
/*     */       }
/* 419 */       RemoteBindings bindings = (RemoteBindings)((EJBContainer)container).getAnnotation(RemoteBindings.class);
/* 420 */       if (bindings != null)
/*     */       {
/* 423 */         return bindings.value()[0].jndiBinding();
/*     */       }
/*     */ 
/* 426 */       RemoteBinding binding = (RemoteBinding)((EJBContainer)container).getAnnotation(RemoteBinding.class);
/* 427 */       if (binding != null)
/*     */       {
/* 430 */         return binding.jndiBinding();
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 436 */     Class remoteHome = getRemoteHomeInterface(container);
/* 437 */     if (remoteHome != null)
/*     */     {
/* 439 */       if (businessInterface.getName().equals(remoteHome.getName()))
/*     */       {
/* 442 */         RemoteHomeBinding binding = (RemoteHomeBinding)((EJBContainer)container).getAnnotation(RemoteHomeBinding.class);
/* 443 */         if (binding != null)
/*     */         {
/* 446 */           return binding.jndiBinding();
/*     */         }
/*     */ 
/* 450 */         isHome = true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 455 */     Class localHome = getLocalHomeInterface(container);
/* 456 */     if (localHome != null)
/*     */     {
/* 458 */       if (businessInterface.getName().equals(localHome.getName()))
/*     */       {
/* 461 */         LocalHomeBinding binding = (LocalHomeBinding)((EJBContainer)container).getAnnotation(LocalHomeBinding.class);
/* 462 */         if (binding != null)
/*     */         {
/* 465 */           return binding.jndiBinding();
/*     */         }
/*     */ 
/* 469 */         isHome = true;
/* 470 */         isLocal = true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 475 */     Class[] locals = getLocalAndBusinessLocalInterfaces(container);
/* 476 */     for (Class clazz : locals)
/*     */     {
/* 478 */       if (!clazz.getName().equals(businessInterface.getName())) {
/*     */         continue;
/*     */       }
/* 481 */       LocalBinding binding = (LocalBinding)((EJBContainer)container).getAnnotation(LocalBinding.class);
/* 482 */       if (binding != null)
/*     */       {
/* 485 */         return binding.jndiBinding();
/*     */       }
/*     */ 
/* 489 */       isLocal = true;
/*     */     }
/*     */ 
/* 494 */     if (jndiName == null)
/*     */     {
/* 497 */       log.debug("JNDI name has not been explicitly set for EJB " + container.getEjbName() + ", interface " + businessInterface.getName());
/*     */ 
/* 501 */       Ejb3DeploymentSummary summary = getDeploymentSummaryFromContainer(container);
/* 502 */       summary.setHome(isHome);
/* 503 */       summary.setLocal(isLocal);
/* 504 */       jndiName = getJndiBindingPolicy(container).getJndiName(summary);
/*     */     }
/*     */ 
/* 508 */     return jndiName;
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getLocalInterfaces(Container container)
/*     */   {
/* 520 */     return getInterfacesAssignableFromClass(getLocalAndBusinessLocalInterfaces(container), EJBLocalObject.class, true);
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getRemoteInterfaces(Container container)
/*     */   {
/* 533 */     return getInterfacesAssignableFromClass(getRemoteAndBusinessRemoteInterfaces(container), EJBObject.class, true);
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getLocalBusinessInterfaces(Container container)
/*     */   {
/* 546 */     return getInterfacesAssignableFromClass(getLocalAndBusinessLocalInterfaces(container), EJBLocalObject.class, false);
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getRemoteBusinessInterfaces(Container container)
/*     */   {
/* 559 */     return getInterfacesAssignableFromClass(getRemoteAndBusinessRemoteInterfaces(container), EJBObject.class, false);
/*     */   }
/*     */ 
/*     */   private static Class<?>[] getInterfacesAssignableFromClass(Class<?>[] interfaces, Class<?> clazz, boolean assignable)
/*     */   {
/* 576 */     List subset = new ArrayList();
/*     */ 
/* 579 */     for (Class interfaze : interfaces)
/*     */     {
/* 582 */       if ((assignable) && (clazz.isAssignableFrom(interfaze)))
/*     */       {
/* 584 */         subset.add(interfaze);
/*     */       }
/*     */ 
/* 588 */       if ((assignable) || (clazz.isAssignableFrom(interfaze)))
/*     */         continue;
/* 590 */       subset.add(interfaze);
/*     */     }
/*     */ 
/* 595 */     return (Class[])subset.toArray(new Class[0]);
/*     */   }
/*     */ 
/*     */   public static Class<?>[] getRemoteAndBusinessRemoteInterfaces(Container container)
/*     */   {
/* 609 */     Remote remoteAnnotation = (Remote)((EJBContainer)container).getAnnotation(Remote.class);
/* 610 */     RemoteHome remoteHomeAnnotation = (RemoteHome)((EJBContainer)container).getAnnotation(RemoteHome.class);
/* 611 */     Set remoteAndRemoteBusinessInterfaces = new HashSet();
/* 612 */     Class beanClass = container.getBeanClass();
/* 613 */     boolean isStateless = (container instanceof StatelessContainer);
/*     */ 
/* 616 */     Class[] businessInterfaces = (Class[])getBusinessInterfaces(beanClass).toArray(new Class[0]);
/*     */ 
/* 621 */     if (remoteHomeAnnotation != null)
/*     */     {
/* 623 */       remoteAndRemoteBusinessInterfaces.addAll(getReturnTypesFromCreateMethods(remoteHomeAnnotation.value(), isStateless));
/*     */     }
/*     */ 
/* 628 */     if (remoteAnnotation == null)
/*     */     {
/* 631 */       for (Class clazz : businessInterfaces)
/*     */       {
/* 634 */         if (!clazz.isAnnotationPresent(Remote.class)) {
/*     */           continue;
/*     */         }
/* 637 */         remoteAndRemoteBusinessInterfaces.add(clazz);
/*     */       }
/*     */ 
/*     */     }
/* 645 */     else if (remoteAnnotation.value().length > 0)
/*     */     {
/* 647 */       for (Class clazz : remoteAnnotation.value())
/*     */       {
/* 649 */         remoteAndRemoteBusinessInterfaces.add(clazz);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 656 */       if (businessInterfaces.length == 0)
/*     */       {
/* 658 */         throw new RuntimeException("Use of empty @Remote on bean " + container.getEjbName() + " and there are no valid business interfaces");
/*     */       }
/*     */ 
/* 663 */       if (businessInterfaces.length > 1)
/*     */       {
/* 665 */         throw new RuntimeException("Use of empty @Remote on bean " + container.getEjbName() + " with more than one default interface " + businessInterfaces);
/*     */       }
/*     */ 
/* 671 */       Class[] rtn = { businessInterfaces[0] };
/*     */ 
/* 673 */       remoteAnnotation = new RemoteImpl(rtn);
/* 674 */       ((EJBContainer)container).getAnnotations().addClassAnnotation(Remote.class, remoteAnnotation);
/* 675 */       return rtn;
/*     */     }
/*     */ 
/* 681 */     if (remoteAndRemoteBusinessInterfaces.size() > 0)
/*     */     {
/* 684 */       Class[] remotesArray = (Class[])remoteAndRemoteBusinessInterfaces.toArray(new Class[remoteAndRemoteBusinessInterfaces.size()]);
/*     */ 
/* 686 */       remoteAnnotation = new RemoteImpl(remotesArray);
/* 687 */       ((Advisor)container).getAnnotations().addClassAnnotation(Remote.class, remoteAnnotation);
/* 688 */       return remoteAnnotation.value();
/*     */     }
/*     */ 
/* 693 */     return new Class[0];
/*     */   }
/*     */ 
/*     */   private static Set<Class<?>> getReturnTypesFromCreateMethods(Class<?> homeInterface, boolean isStateless)
/*     */   {
/* 708 */     assert ((EJBHome.class.isAssignableFrom(homeInterface)) || (EJBLocalHome.class.isAssignableFrom(homeInterface)));
/*     */ 
/* 711 */     if ((!EJBHome.class.isAssignableFrom(homeInterface)) && (!EJBLocalHome.class.isAssignableFrom(homeInterface)))
/*     */     {
/* 713 */       throw new RuntimeException("Declared EJB 2.1 Home Interface " + homeInterface.getName() + " does not extend " + EJBHome.class.getName() + " or " + EJBLocalHome.class.getName() + " as required by EJB 3.0 Core Specification 4.6.8 and 4.6.10");
/*     */     }
/*     */ 
/* 719 */     Set types = new HashSet();
/* 720 */     List createMethods = null;
/*     */ 
/* 723 */     if (isStateless)
/*     */     {
/* 726 */       String specViolationErrorMessage = "EJB 3.0 Specification Violation (4.6.8 Bullet 4, 4.6.10 Bullet 4): \"A stateless session bean must define exactly one create method with no arguments.\"; found in " + homeInterface.getName();
/*     */ 
/* 731 */       createMethods = new ArrayList();
/*     */       try
/*     */       {
/* 734 */         createMethods.add(homeInterface.getMethod("create", new Class[0]));
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/* 741 */         throw new RuntimeException(specViolationErrorMessage);
/*     */       }
/*     */ 
/* 747 */       if (createMethods.size() > 1)
/*     */       {
/* 749 */         throw new RuntimeException(specViolationErrorMessage);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 755 */       createMethods = ClassHelper.getAllMethodsByPrefix(homeInterface, "create");
/*     */     }
/* 757 */     if (createMethods.size() == 0)
/*     */     {
/* 759 */       throw new RuntimeException("EJB 3.0 Core Specification Violation (4.6.8 Bullet 5): EJB2.1 Home Interface " + homeInterface + " does not declare a 'create<METHOD>' method");
/*     */     }
/*     */ 
/* 764 */     for (Method method : createMethods)
/*     */     {
/* 766 */       types.add(method.getReturnType());
/*     */     }
/*     */ 
/* 770 */     return types;
/*     */   }
/*     */ 
/*     */   public static String getClientBindUrl(RemoteBinding binding) throws Exception
/*     */   {
/* 775 */     String clientBindUrl = binding.clientBindUrl();
/* 776 */     if (clientBindUrl.trim().length() == 0)
/*     */     {
/* 778 */       ObjectName connectionON = new ObjectName("jboss.remoting:type=Connector,name=DefaultEjb3Connector,handler=ejb3");
/*     */ 
/* 780 */       KernelAbstraction kernelAbstraction = KernelAbstractionFactory.getInstance();
/*     */       try
/*     */       {
/* 783 */         clientBindUrl = (String)kernelAbstraction.getAttribute(connectionON, "InvokerLocator");
/* 784 */         if (clientBindUrl == null)
/* 785 */           clientBindUrl = "socket://0.0.0.0:3873";
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 789 */         clientBindUrl = "socket://0.0.0.0:3873";
/*     */       }
/*     */     }
/*     */ 
/* 793 */     return clientBindUrl;
/*     */   }
/*     */ 
/*     */   public static String getHomeJndiName(Container container)
/*     */   {
/* 799 */     Advisor advisor = (Advisor)container;
/*     */ 
/* 802 */     RemoteHomeBinding binding = (RemoteHomeBinding)advisor.resolveAnnotation(RemoteHomeBinding.class);
/* 803 */     if (binding != null) {
/* 804 */       return binding.jndiBinding();
/*     */     }
/*     */ 
/* 807 */     return getJndiBindingPolicy(container).getDefaultRemoteHomeJndiName(getDeploymentSummaryFromContainer(container));
/*     */   }
/*     */ 
/*     */   public static String getLocalHomeJndiName(Container container)
/*     */   {
/* 814 */     Advisor advisor = (Advisor)container;
/*     */ 
/* 817 */     LocalHomeBinding binding = (LocalHomeBinding)advisor.resolveAnnotation(LocalHomeBinding.class);
/* 818 */     if (binding != null) {
/* 819 */       return binding.jndiBinding();
/*     */     }
/*     */ 
/* 822 */     return getJndiBindingPolicy(container).getDefaultLocalHomeJndiName(getDeploymentSummaryFromContainer(container));
/*     */   }
/*     */ 
/*     */   public static String getLocalJndiName(Container container)
/*     */   {
/* 828 */     return getLocalJndiName(container, true);
/*     */   }
/*     */ 
/*     */   private static String getLocalJndiName(Container container, boolean conflictCheck)
/*     */   {
/* 834 */     Advisor advisor = (Advisor)container;
/*     */ 
/* 837 */     LocalBinding localBinding = (LocalBinding)advisor.resolveAnnotation(LocalBinding.class);
/*     */ 
/* 840 */     if (localBinding == null)
/*     */     {
/* 843 */       String name = getJndiBindingPolicy(container).getDefaultLocalJndiName(getDeploymentSummaryFromContainer(container));
/*     */ 
/* 846 */       if (conflictCheck) {
/* 847 */         checkForJndiNamingConflict(container);
/*     */       }
/* 849 */       return name;
/*     */     }
/*     */ 
/* 854 */     return localBinding.jndiBinding();
/*     */   }
/*     */ 
/*     */   public static String getRemoteJndiName(Container container)
/*     */   {
/* 860 */     return getRemoteJndiName(container, true);
/*     */   }
/*     */ 
/*     */   public static String getRemoteJndiName(Container container, boolean check)
/*     */   {
/* 865 */     Advisor advisor = (Advisor)container;
/* 866 */     RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
/*     */ 
/* 868 */     return getRemoteJndiName(container, binding);
/*     */   }
/*     */ 
/*     */   private static void checkForJndiNamingConflict(Container container)
/*     */   {
/* 873 */     if (((Advisor)container).resolveAnnotation(Local.class) != null)
/*     */     {
/* 875 */       Ejb3DeploymentSummary summary = getDeploymentSummaryFromContainer(container);
/* 876 */       String localJndiName = getJndiBindingPolicy(container).getDefaultLocalJndiName(summary);
/* 877 */       String remoteJndiName = getJndiBindingPolicy(container).getDefaultRemoteJndiName(summary);
/* 878 */       String ejbName = container.getEjbName();
/* 879 */       if (localJndiName.equals(remoteJndiName))
/*     */       {
/* 881 */         throw new EJBException("Conflict between default jndi name " + remoteJndiName + " for both remote and local for ejb-name:" + ejbName + ", bean class=" + container.getBeanClass());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String getRemoteJndiName(Container container, RemoteBinding binding)
/*     */   {
/* 890 */     return getRemoteJndiName(container, binding, true);
/*     */   }
/*     */ 
/*     */   public static String getRemoteJndiName(Container container, RemoteBinding binding, boolean conflictCheck)
/*     */   {
/* 895 */     String jndiName = null;
/* 896 */     if ((binding == null) || (binding.jndiBinding() == null) || (binding.jndiBinding().equals("")))
/*     */     {
/* 898 */       jndiName = getDefaultRemoteJndiName(container);
/*     */ 
/* 900 */       if (conflictCheck)
/* 901 */         checkForJndiNamingConflict(container);
/*     */     }
/*     */     else
/*     */     {
/* 905 */       jndiName = binding.jndiBinding();
/*     */     }
/*     */ 
/* 908 */     return jndiName;
/*     */   }
/*     */ 
/*     */   public static String getDefaultRemoteJndiName(Container container)
/*     */   {
/* 913 */     return getJndiBindingPolicy(container).getDefaultRemoteJndiName(getDeploymentSummaryFromContainer(container));
/*     */   }
/*     */ 
/*     */   private static DefaultJndiBindingPolicy getJndiBindingPolicy(Container container)
/*     */   {
/* 926 */     EJBContainer ejbContainer = (EJBContainer)container;
/* 927 */     JndiBindingPolicy bindingPolicy = (JndiBindingPolicy)ejbContainer.getAnnotation(JndiBindingPolicy.class);
/* 928 */     Class policy = null;
/* 929 */     if (bindingPolicy != null) {
/* 930 */       policy = bindingPolicy.policy();
/*     */     }
/*     */     else {
/* 933 */       Class policyClass = PackagingBasedJndiBindingPolicy.class;
/* 934 */       log.warn("No default JNDI Binding Policy Defined (see ejb3-interceptors-aop.xml for example); defaulting to " + policyClass.getName());
/*     */ 
/* 936 */       policy = policyClass;
/*     */     }
/* 938 */     log.debug("Obtaining JNDI name from policy " + policy.getName());
/*     */     try
/*     */     {
/* 941 */       return (DefaultJndiBindingPolicy)policy.newInstance();
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/* 945 */       throw new RuntimeException("Could not instanciate JNDI Binding Policy: " + policy.getName(), e);
/*     */     }
/*     */     catch (IllegalAccessException e) {
/*     */     }
/* 949 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private static Ejb3DeploymentSummary getDeploymentSummaryFromContainer(Container container)
/*     */   {
/* 956 */     Ejb3DeploymentSummary summary = new Ejb3DeploymentSummary();
/* 957 */     summary.setEjbName(container.getEjbName());
/* 958 */     summary.setService(container instanceof ServiceContainer);
/* 959 */     summary.setStateful(container instanceof StatefulContainer);
/* 960 */     summary.setDeploymentName(((EJBContainer)container).getDeployment().getName());
/* 961 */     summary.setBeanClass(container.getBeanClass());
/* 962 */     if ((container instanceof EJBContainer))
/*     */     {
/* 964 */       DeploymentScope scope = ((EJBContainer)container).getDeployment().getEar();
/* 965 */       if (scope != null)
/*     */       {
/* 967 */         summary.setDeploymentScopeBaseName(scope.getBaseName());
/*     */       }
/*     */     }
/* 970 */     return summary;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  69 */     log = Logger.getLogger(ProxyFactoryHelper.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.ProxyFactoryHelper
 * JD-Core Version:    0.6.0
 */