/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
/*     */ import org.jboss.beans.metadata.spi.DemandMetaData;
/*     */ import org.jboss.beans.metadata.spi.DependencyMetaData;
/*     */ import org.jboss.beans.metadata.spi.SupplyMetaData;
/*     */ import org.jboss.ejb3.dependency.EjbLinkDemandMetaData;
/*     */ import org.jboss.ejb3.javaee.JavaEEComponent;
/*     */ 
/*     */ public class MCDependencyPolicy
/*     */   implements DependencyPolicy
/*     */ {
/*     */   private JavaEEComponent component;
/*  45 */   private Set<DependencyMetaData> dependencies = new HashSet();
/*  46 */   private Set<DemandMetaData> demands = new HashSet();
/*  47 */   private Set<SupplyMetaData> supplies = new HashSet();
/*     */ 
/*     */   public MCDependencyPolicy(JavaEEComponent component)
/*     */   {
/*  51 */     assert (component != null) : "component is null";
/*     */ 
/*  53 */     this.component = component;
/*     */   }
/*     */ 
/*     */   public void addDependency(String dependency)
/*     */   {
/*  58 */     addDependency(new AbstractDemandMetaData(dependency));
/*     */   }
/*     */ 
/*     */   public void addDependency(DemandMetaData dependency) {
/*  62 */     this.demands.add(dependency);
/*     */   }
/*     */ 
/*     */   public void addDependency(DependencyMetaData dependency) {
/*  66 */     this.dependencies.add(dependency);
/*     */   }
/*     */ 
/*     */   public void addDatasource(String jndiName)
/*     */   {
/*  71 */     String ds = jndiName;
/*  72 */     if (ds.startsWith("java:/"))
/*     */     {
/*  74 */       ds = ds.substring(6);
/*     */     }
/*  77 */     else if (ds.startsWith("java:"))
/*     */     {
/*  79 */       ds = ds.substring(5);
/*     */     }
/*  81 */     addDependency(ds);
/*     */   }
/*     */ 
/*     */   public void addDependency(Class<?> businessInterface)
/*     */   {
/*  88 */     addDependency("Class:" + businessInterface.getName());
/*     */   }
/*     */ 
/*     */   public void addDependency(String ejbLink, Class<?> businessInterface)
/*     */   {
/* 102 */     assert (ejbLink != null) : "ejbLink is null";
/*     */ 
/* 108 */     int hashIndex = ejbLink.indexOf('#');
/* 109 */     if (hashIndex != -1)
/*     */     {
/* 116 */       String unitName = ejbLink.substring(0, hashIndex);
/*     */ 
/* 123 */       String ejbName = ejbLink.substring(hashIndex + 1);
/* 124 */       addDependency(this.component.createObjectName(unitName, ejbName));
/*     */     }
/*     */     else {
/* 127 */       addDependency(new EjbLinkDemandMetaData(this.component, ejbLink));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addJNDIName(String name, ClassLoader loader) {
/* 132 */     assert (name != null) : "name is null";
/* 133 */     assert (name.length() > 0) : "name is empty";
/*     */ 
/* 135 */     addDependency("jndi:" + name);
/*     */   }
/*     */ 
/*     */   public Set<DependencyMetaData> getDependencies()
/*     */   {
/* 140 */     return this.dependencies;
/*     */   }
/*     */ 
/*     */   public Set<DemandMetaData> getDemands() {
/* 144 */     return this.demands;
/*     */   }
/*     */ 
/*     */   public void addSupply(Class<?> businessInterface)
/*     */   {
/* 149 */     this.supplies.add(new AbstractSupplyMetaData("Class:" + businessInterface.getName()));
/*     */   }
/*     */ 
/*     */   public Set<SupplyMetaData> getSupplies()
/*     */   {
/* 154 */     return this.supplies;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.MCDependencyPolicy
 * JD-Core Version:    0.6.0
 */