/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import org.jboss.ejb3.remoting.Proxy;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public abstract class LocalProxy
/*    */   implements InvocationHandler, Externalizable, Proxy
/*    */ {
/* 41 */   private static Logger log = Logger.getLogger(LocalProxy.class);
/*    */ 
/* 43 */   private transient Container container = null;
/*    */   protected String containerClusterUid;
/*    */   protected String containerGuid;
/*    */   protected String proxyName;
/*    */ 
/*    */   public LocalProxy()
/*    */   {
/*    */   }
/*    */ 
/*    */   protected LocalProxy(Container container)
/*    */   {
/* 55 */     this.container = container;
/* 56 */     this.containerGuid = Ejb3Registry.guid(container);
/* 57 */     this.containerClusterUid = Ejb3Registry.clusterUid(container);
/* 58 */     this.proxyName = container.getEjbName();
/*    */   }
/*    */ 
/*    */   protected Container getContainer()
/*    */   {
/* 63 */     if (this.container == null)
/* 64 */       this.container = Ejb3Registry.findContainer(this.containerGuid);
/* 65 */     if (this.container == null)
/* 66 */       log.warn("Container " + this.containerGuid + " is not yet available");
/* 67 */     return this.container;
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 72 */     this.containerGuid = in.readUTF();
/* 73 */     this.containerClusterUid = in.readUTF();
/* 74 */     this.proxyName = in.readUTF();
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out) throws IOException
/*    */   {
/* 79 */     out.writeUTF(this.containerGuid);
/* 80 */     out.writeUTF(this.containerClusterUid);
/* 81 */     out.writeUTF(this.proxyName);
/*    */   }
/*    */ 
/*    */   public abstract String toString();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.LocalProxy
 * JD-Core Version:    0.6.0
 */