/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanServerLocator;
/*     */ 
/*     */ public class InitialContextFactory
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(InitialContextFactory.class);
/*     */ 
/*  47 */   private static Properties props = null;
/*  48 */   private static Properties securityProperties = null;
/*  49 */   private static InitialContext baseInitialContext = null;
/*  50 */   private static Context haContext = null;
/*  51 */   private static Integer haJndiPort = null;
/*     */ 
/*     */   public static InitialContext getInitialContext()
/*     */     throws NamingException
/*     */   {
/*     */     InitialContext jndiContext;
/*  57 */     if (props == null)
/*     */     {
/*  59 */       if (baseInitialContext == null)
/*     */       {
/*  61 */         baseInitialContext = new InitialContext();
/*     */       }
/*  63 */       InitialContext jndiContext = baseInitialContext;
/*     */       try
/*     */       {
/*  67 */         jndiContext.getEnvironment();
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/*  71 */         jndiContext = InitialContextFactory.baseInitialContext = new InitialContext();
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*     */       InitialContext jndiContext;
/*  76 */       if (securityProperties != null)
/*     */       {
/*  78 */         Properties combinedProps = new Properties();
/*  79 */         combinedProps.putAll(props);
/*  80 */         combinedProps.putAll(securityProperties);
/*  81 */         jndiContext = new InitialContext(combinedProps);
/*     */       }
/*     */       else {
/*  84 */         jndiContext = new InitialContext(props);
/*     */       }
/*     */     }
/*  87 */     return jndiContext;
/*     */   }
/*     */ 
/*     */   public static InitialContext getInitialContext(Hashtable props)
/*     */     throws NamingException
/*     */   {
/*  93 */     InitialContext ctx = null;
/*  94 */     if (props != null)
/*     */     {
/*  96 */       ctx = new InitialContext(props);
/*     */     }
/*     */     else
/*     */     {
/* 100 */       ctx = getInitialContext();
/*     */     }
/* 102 */     return ctx;
/*     */   }
/*     */ 
/*     */   public static Context getHAContext(Context ctx)
/*     */     throws NamingException
/*     */   {
/* 108 */     if (haContext == null)
/*     */     {
/* 110 */       Hashtable env = ctx.getEnvironment();
/* 111 */       Object providerUrl = env.get("java.naming.provider.url");
/* 112 */       if (providerUrl == null)
/*     */       {
/*     */         try
/*     */         {
/* 116 */           String bindAddress = System.getProperty("jboss.bind.address");
/* 117 */           env.put("java.naming.provider.url", bindAddress + ":" + getHaJndiPort());
/* 118 */           InitialContext haCtx = new InitialContext(env);
/* 119 */           haCtx.bind("HA_TEST", null);
/* 120 */           haCtx.unbind("HA_TEST");
/* 121 */           haContext = haCtx;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 125 */           log.debug("Unable to access HA JNDI: " + e);
/*     */         }
/*     */       }
/*     */     }
/* 129 */     return haContext;
/*     */   }
/*     */ 
/*     */   private static Integer getHaJndiPort() throws Exception
/*     */   {
/* 134 */     if (haJndiPort == null)
/*     */     {
/* 136 */       MBeanServer server = MBeanServerLocator.locateJBoss();
/* 137 */       ObjectName objectName = new ObjectName("jboss:service=HAJNDI");
/* 138 */       haJndiPort = (Integer)server.getAttribute(objectName, "Port");
/*     */     }
/* 140 */     return haJndiPort;
/*     */   }
/*     */ 
/*     */   public static void setProperties(Properties properties)
/*     */   {
/* 145 */     props = properties;
/*     */   }
/*     */ 
/*     */   public static void setSecurity(String user, String password)
/*     */   {
/* 150 */     if (props != null)
/*     */     {
/* 152 */       securityProperties = new Properties();
/* 153 */       securityProperties.put("java.naming.security.principal", user);
/* 154 */       securityProperties.put("java.naming.security.credentials", password);
/* 155 */       securityProperties.put("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.InitialContextFactory
 * JD-Core Version:    0.6.0
 */