/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import java.net.URL;
/*    */ import javassist.bytecode.ClassFile;
/*    */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*    */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*    */ 
/*    */ public abstract class Ejb3HandlerFactory
/*    */ {
/*    */   public abstract Ejb3Handler createHandler(ClassFile paramClassFile)
/*    */     throws Exception;
/*    */ 
/*    */   public static Ejb3HandlerFactory getInstance(Ejb3Deployment di)
/*    */     throws Exception
/*    */   {
/* 76 */     URL ddResource = di.getDeploymentUnit().getEjbJarXml();
/*    */ 
/* 78 */     URL jbossDdResource = di.getDeploymentUnit().getJbossXml();
/*    */ 
/* 80 */     if ((ddResource == null) && (jbossDdResource == null)) {
/* 81 */       return new AnnotationFactory(di);
/*    */     }
/* 83 */     return new DDFactory(di);
/*    */   }
/*    */ 
/*    */   private static class AnnotationFactory extends Ejb3HandlerFactory
/*    */   {
/*    */     private Ejb3Deployment di;
/*    */ 
/*    */     public AnnotationFactory(Ejb3Deployment di)
/*    */       throws Exception
/*    */     {
/* 64 */       this.di = di;
/*    */     }
/*    */ 
/*    */     public Ejb3Handler createHandler(ClassFile cf)
/*    */       throws Exception
/*    */     {
/* 70 */       return new Ejb3AnnotationHandler(this.di, cf);
/*    */     }
/*    */   }
/*    */ 
/*    */   private static class DDFactory extends Ejb3HandlerFactory
/*    */   {
/*    */     private JBossMetaData dd;
/*    */     private Ejb3Deployment di;
/*    */ 
/*    */     public DDFactory(Ejb3Deployment di)
/*    */       throws Exception
/*    */     {
/* 44 */       this.di = di;
/* 45 */       this.dd = di.getMetaData();
/*    */ 
/* 47 */       InterceptorInfoRepository repository = this.di.getDeploymentUnit().getInterceptorInfoRepository();
/* 48 */       repository.initialise(this.dd);
/*    */     }
/*    */ 
/*    */     public Ejb3Handler createHandler(ClassFile cf)
/*    */       throws Exception
/*    */     {
/* 54 */       return new Ejb3DescriptorHandler(this.di, cf, this.dd);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.Ejb3HandlerFactory
 * JD-Core Version:    0.6.0
 */