/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.lang.reflect.Member;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMember;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.annotation.factory.AnnotationCreator;
/*     */ import org.jboss.aop.annotation.AnnotationRepository;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
/*     */ import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
/*     */ import org.jboss.metadata.plugins.loader.reflection.ClassMetaDataRetrievalFactory;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ import org.jboss.metadata.spi.context.MetaDataContext;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
/*     */ import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
/*     */ import org.jboss.metadata.spi.scope.CommonLevels;
/*     */ import org.jboss.metadata.spi.scope.Scope;
/*     */ import org.jboss.metadata.spi.scope.ScopeKey;
/*     */ import org.jboss.metadata.spi.signature.ConstructorSignature;
/*     */ import org.jboss.metadata.spi.signature.FieldSignature;
/*     */ import org.jboss.metadata.spi.signature.MethodSignature;
/*     */ import org.jboss.metadata.spi.signature.Signature;
/*     */ 
/*     */ public class AnnotationRepositoryToMetaData extends AnnotationRepository
/*     */ {
/*  64 */   private static final Logger log = Logger.getLogger(AnnotationRepositoryToMetaData.class);
/*     */   private MetaData metaData;
/*     */   private MemoryMetaDataLoader mutableMetaData;
/*     */   private ClassLoader classLoader;
/*     */ 
/*     */   public AnnotationRepositoryToMetaData(EJBContainer container)
/*     */   {
/*  77 */     if (container == null) {
/*  78 */       throw new IllegalArgumentException("Null container");
/*     */     }
/*  80 */     Class beanClass = container.getClazz();
/*  81 */     if (beanClass == null)
/*  82 */       throw new IllegalArgumentException("Null bean class");
/*  83 */     String name = container.getObjectName().getCanonicalName();
/*  84 */     if (name == null)
/*  85 */       throw new IllegalArgumentException("Null name");
/*  86 */     this.classLoader = container.getClassloader();
/*  87 */     if (this.classLoader == null) {
/*  88 */       throw new IllegalArgumentException("Null class");
/*     */     }
/*  90 */     MetaDataRetrieval classMetaData = ClassMetaDataRetrievalFactory.INSTANCE.getMetaDataRetrieval(new Scope(CommonLevels.CLASS, beanClass));
/*  91 */     ScopeKey instanceScope = new ScopeKey(CommonLevels.INSTANCE, name);
/*  92 */     this.mutableMetaData = new MemoryMetaDataLoader(instanceScope);
/*  93 */     MetaDataRetrieval dynamicXml = new EJBMetaDataLoader(instanceScope, container);
/*     */ 
/*  95 */     MetaDataContext classContext = new AbstractMetaDataContext(classMetaData);
/*  96 */     MetaDataRetrieval[] instance = { dynamicXml, this.mutableMetaData };
/*  97 */     MetaDataContext instanceContext = new AbstractMetaDataContext(classContext, Arrays.asList(instance));
/*  98 */     this.metaData = new MetaDataRetrievalToMetaDataBridge(instanceContext);
/*     */   }
/*     */ 
/*     */   protected static Signature getSignature(CtMember member)
/*     */   {
/* 109 */     if (member == null) {
/* 110 */       throw new IllegalArgumentException("Null member");
/*     */     }
/*     */     try
/*     */     {
/* 114 */       if ((member instanceof CtMethod))
/*     */       {
/* 116 */         CtMethod method = (CtMethod)member;
/* 117 */         CtClass[] parameterTypes = method.getParameterTypes();
/* 118 */         String[] params = Signature.NO_PARAMETERS;
/* 119 */         if (parameterTypes.length > 0)
/*     */         {
/* 121 */           params = new String[parameterTypes.length];
/* 122 */           for (int i = 0; i < params.length; i++)
/* 123 */             params[i] = parameterTypes[i].getName();
/*     */         }
/* 125 */         return new MethodSignature(method.getName(), params);
/*     */       }
/* 127 */       if ((member instanceof CtConstructor))
/*     */       {
/* 129 */         CtConstructor constructor = (CtConstructor)member;
/* 130 */         CtClass[] parameterTypes = constructor.getParameterTypes();
/* 131 */         String[] params = Signature.NO_PARAMETERS;
/* 132 */         if (parameterTypes.length > 0)
/*     */         {
/* 134 */           params = new String[parameterTypes.length];
/* 135 */           for (int i = 0; i < params.length; i++)
/* 136 */             params[i] = parameterTypes[i].getName();
/*     */         }
/* 138 */         return new ConstructorSignature(params);
/*     */       }
/* 140 */       if ((member instanceof CtField))
/*     */       {
/* 142 */         return new FieldSignature(member.getName());
/*     */       }
/* 144 */       throw new IllegalArgumentException("Unknown member type: " + member);
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 148 */     throw new RuntimeException("Error determing signature: " + member, e);
/*     */   }
/*     */ 
/*     */   protected Annotation initAnnotation(Object annotation)
/*     */   {
/* 160 */     if (annotation == null) {
/* 161 */       throw new IllegalArgumentException("Null annotation");
/*     */     }
/* 163 */     if ((annotation instanceof Annotation)) {
/* 164 */       return (Annotation)annotation;
/*     */     }
/* 166 */     if (!(annotation instanceof String)) {
/* 167 */       throw new IllegalArgumentException("Not an annotation: " + annotation);
/*     */     }
/*     */     try
/*     */     {
/* 171 */       return (Annotation)AnnotationCreator.createAnnotation((String)annotation, this.classLoader);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 175 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 179 */     throw new RuntimeException("Error creating annotation: " + annotation, e);
/*     */   }
/*     */ 
/*     */   protected Class loadClass(String className)
/*     */   {
/*     */     try
/*     */     {
/* 187 */       return this.classLoader.loadClass(className);
/*     */     }
/*     */     catch (ClassNotFoundException e) {
/*     */     }
/* 191 */     throw new RuntimeException("Unable to load class for annotation " + className + " using class loader " + this.classLoader);
/*     */   }
/*     */ 
/*     */   public void addAnnotation(CtMember m, String annotation)
/*     */   {
/* 197 */     this.mutableMetaData.addAnnotation(getSignature(m), initAnnotation(annotation));
/*     */   }
/*     */ 
/*     */   public void addAnnotation(Member m, Class annotation, Object value)
/*     */   {
/* 202 */     this.mutableMetaData.addAnnotation(m, initAnnotation(value));
/*     */   }
/*     */ 
/*     */   public void addAnnotation(Member m, String annotation, Object value)
/*     */   {
/* 207 */     this.mutableMetaData.addAnnotation(m, initAnnotation(value));
/*     */   }
/*     */ 
/*     */   public void addClassAnnotation(Class annotation, Object value)
/*     */   {
/* 212 */     this.mutableMetaData.addAnnotation(initAnnotation(value));
/*     */   }
/*     */ 
/*     */   public void addClassAnnotation(String annotation, String value)
/*     */   {
/* 217 */     this.mutableMetaData.addAnnotation(initAnnotation(value));
/*     */   }
/*     */ 
/*     */   public void disableAnnotation(Member m, String annotation)
/*     */   {
/* 222 */     log.warn("Not implemented: disableAnnotation(" + m + ", " + annotation + ")");
/*     */   }
/*     */ 
/*     */   public void disableAnnotation(String annotation)
/*     */   {
/* 227 */     log.warn("Not implemented: disableAnnotation(" + annotation + ")");
/*     */   }
/*     */ 
/*     */   public void enableAnnotation(String annotation)
/*     */   {
/* 232 */     log.warn("Not implemented: enableAnnotation(" + annotation + ")");
/*     */   }
/*     */ 
/*     */   public Map getAnnotations()
/*     */   {
/* 237 */     log.warn("Not implemented: getAnnotations()");
/* 238 */     return Collections.emptyMap();
/*     */   }
/*     */ 
/*     */   public Map getClassAnnotations()
/*     */   {
/* 243 */     log.warn("Not implemented: getClassAnnotations()");
/* 244 */     return Collections.emptyMap();
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(CtMember m, String annotation)
/*     */   {
/* 249 */     if (annotation == null)
/* 250 */       throw new IllegalArgumentException("Null annotation");
/* 251 */     MetaData component = this.metaData.getComponentMetaData(getSignature(m));
/* 252 */     if (component == null)
/* 253 */       return false;
/* 254 */     return component.isMetaDataPresent(annotation);
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(Member m, Class annotation)
/*     */   {
/* 259 */     if (annotation == null)
/* 260 */       throw new IllegalArgumentException("Null annotation");
/* 261 */     MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
/* 262 */     if (component == null)
/* 263 */       return false;
/* 264 */     return component.isAnnotationPresent(annotation);
/*     */   }
/*     */ 
/*     */   public boolean hasAnnotation(Member m, String annotation)
/*     */   {
/* 269 */     if (annotation == null)
/* 270 */       throw new IllegalArgumentException("Null annotation");
/* 271 */     MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
/* 272 */     if (component == null)
/* 273 */       return false;
/* 274 */     return component.isAnnotationPresent(loadClass(annotation));
/*     */   }
/*     */ 
/*     */   public boolean hasClassAnnotation(Class annotation)
/*     */   {
/* 279 */     if (annotation == null)
/* 280 */       throw new IllegalArgumentException("Null annotation");
/* 281 */     return this.metaData.isAnnotationPresent(annotation);
/*     */   }
/*     */ 
/*     */   public boolean hasClassAnnotation(String annotation)
/*     */   {
/* 286 */     if (annotation == null)
/* 287 */       throw new IllegalArgumentException("Null annotation");
/* 288 */     return this.metaData.isAnnotationPresent(loadClass(annotation));
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Class annotation)
/*     */   {
/* 293 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Member m, Class annotation)
/*     */   {
/* 298 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(Member m, String annotation)
/*     */   {
/* 303 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isDisabled(String annotation)
/*     */   {
/* 308 */     return false;
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/* 313 */     if (annotation == null)
/* 314 */       throw new IllegalArgumentException("Null annotation");
/* 315 */     return this.metaData.getAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Member m, Class annotation)
/*     */   {
/* 320 */     if (annotation == null)
/* 321 */       throw new IllegalArgumentException("Null annotation");
/* 322 */     MetaData component = this.metaData.getComponentMetaData(Signature.getSignature(m));
/* 323 */     if (component == null)
/* 324 */       return null;
/* 325 */     return component.getAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   protected Object resolveAnnotation(Member m, String annotation)
/*     */   {
/* 330 */     return resolveAnnotation(m, loadClass(annotation));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.AnnotationRepositoryToMetaData
 * JD-Core Version:    0.6.0
 */